/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.plugins.namespace;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.internal.impldep.org.apache.ivy.plugins.namespace.NamespaceRule;
import org.gradle.internal.impldep.org.apache.ivy.plugins.namespace.NamespaceTransformer;

public class Namespace {
    public static final Namespace SYSTEM_NAMESPACE = new Namespace();
    private List rules = new ArrayList();
    private String name;
    private boolean chainRules = false;
    private NamespaceTransformer fromSystemTransformer = new NamespaceTransformer(){

        public ModuleRevisionId transform(ModuleRevisionId mrid) {
            if (mrid == null) {
                return null;
            }
            Iterator iter = Namespace.this.rules.iterator();
            while (iter.hasNext()) {
                NamespaceRule rule = (NamespaceRule)iter.next();
                ModuleRevisionId nmrid = rule.getFromSystem().transform(mrid);
                if (Namespace.this.chainRules) {
                    mrid = nmrid;
                    continue;
                }
                if (nmrid.equals(mrid)) continue;
                return nmrid;
            }
            return mrid;
        }

        public boolean isIdentity() {
            return Namespace.this.rules.isEmpty();
        }
    };
    private NamespaceTransformer toSystemTransformer = new NamespaceTransformer(){

        public ModuleRevisionId transform(ModuleRevisionId mrid) {
            if (mrid == null) {
                return null;
            }
            Iterator iter = Namespace.this.rules.iterator();
            while (iter.hasNext()) {
                NamespaceRule rule = (NamespaceRule)iter.next();
                ModuleRevisionId nmrid = rule.getToSystem().transform(mrid);
                if (Namespace.this.chainRules) {
                    mrid = nmrid;
                    continue;
                }
                if (nmrid.equals(mrid)) continue;
                return nmrid;
            }
            return mrid;
        }

        public boolean isIdentity() {
            return Namespace.this.rules.isEmpty();
        }
    };

    public void addRule(NamespaceRule rule) {
        this.rules.add(rule);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NamespaceTransformer getFromSystemTransformer() {
        return this.fromSystemTransformer;
    }

    public NamespaceTransformer getToSystemTransformer() {
        return this.toSystemTransformer;
    }

    public boolean isChainrules() {
        return this.chainRules;
    }

    public void setChainrules(boolean chainRules) {
        this.chainRules = chainRules;
    }
}

