/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.settings.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.gradle.internal.impldep.org.apache.maven.settings.Settings;
import org.gradle.internal.impldep.org.apache.maven.settings.io.SettingsWriter;
import org.gradle.internal.impldep.org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Component;
import org.gradle.internal.impldep.org.codehaus.plexus.util.IOUtil;
import org.gradle.internal.impldep.org.codehaus.plexus.util.WriterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=SettingsWriter.class)
public class DefaultSettingsWriter
implements SettingsWriter {
    @Override
    public void write(File output, Map<String, Object> options, Settings settings) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("output file missing");
        }
        if (settings == null) {
            throw new IllegalArgumentException("settings missing");
        }
        output.getParentFile().mkdirs();
        this.write(WriterFactory.newXmlWriter(output), options, settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Writer output, Map<String, Object> options, Settings settings) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("output writer missing");
        }
        if (settings == null) {
            throw new IllegalArgumentException("settings missing");
        }
        try {
            SettingsXpp3Writer w = new SettingsXpp3Writer();
            w.write(output, settings);
        }
        finally {
            IOUtil.close(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream output, Map<String, Object> options, Settings settings) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("output stream missing");
        }
        if (settings == null) {
            throw new IllegalArgumentException("settings missing");
        }
        try {
            String encoding = settings.getModelEncoding();
            if (encoding == null || encoding.length() <= 0) {
                encoding = "UTF-8";
            }
            this.write(new OutputStreamWriter(output, encoding), options, settings);
        }
        finally {
            IOUtil.close(output);
        }
    }
}

