/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.toolchain;

import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.impldep.org.apache.maven.toolchain.RequirementMatcher;
import org.gradle.internal.impldep.org.apache.maven.toolchain.Toolchain;
import org.gradle.internal.impldep.org.apache.maven.toolchain.ToolchainPrivate;
import org.gradle.internal.impldep.org.apache.maven.toolchain.model.ToolchainModel;
import org.gradle.internal.impldep.org.codehaus.plexus.logging.Logger;

public abstract class DefaultToolchain
implements Toolchain,
ToolchainPrivate {
    private String type;
    private Map<String, RequirementMatcher> provides = new HashMap<String, RequirementMatcher>();
    public static final String KEY_TYPE = "type";
    private ToolchainModel model;
    private Logger logger;

    protected DefaultToolchain(ToolchainModel model, Logger logger) {
        this.model = model;
        this.logger = logger;
    }

    protected DefaultToolchain(ToolchainModel model, String type, Logger logger) {
        this(model, logger);
        this.type = type;
    }

    public final String getType() {
        return this.type != null ? this.type : this.model.getType();
    }

    public final ToolchainModel getModel() {
        return this.model;
    }

    public final void addProvideToken(String type, RequirementMatcher matcher) {
        this.provides.put(type, matcher);
    }

    public boolean matchesRequirements(Map requirements) {
        for (String key : requirements.keySet()) {
            RequirementMatcher matcher = this.provides.get(key);
            if (matcher == null) {
                this.getLog().debug("Toolchain " + this + " is missing required property: " + key);
                return false;
            }
            if (matcher.matches((String)requirements.get(key))) continue;
            this.getLog().debug("Toolchain " + this + " doesn't match required property: " + key);
            return false;
        }
        return true;
    }

    protected Logger getLog() {
        return this.logger;
    }
}

