/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.openpgp;

import java.io.EOFException;
import java.io.InputStream;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.BCPGInputStream;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.InputStreamPacket;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPDataValidationException;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPEncryptedData;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPException;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.gradle.internal.impldep.org.bouncycastle.util.io.TeeInputStream;

public class PGPPBEEncryptedData
extends PGPEncryptedData {
    SymmetricKeyEncSessionPacket keyData;

    PGPPBEEncryptedData(SymmetricKeyEncSessionPacket symmetricKeyEncSessionPacket, InputStreamPacket inputStreamPacket) {
        super(inputStreamPacket);
        this.keyData = symmetricKeyEncSessionPacket;
    }

    public int getSymmetricAlgorithm(PBEDataDecryptorFactory pBEDataDecryptorFactory) throws PGPException {
        byte[] byArray = pBEDataDecryptorFactory.makeKeyFromPassPhrase(this.keyData.getEncAlgorithm(), this.keyData.getS2K());
        byte[] byArray2 = pBEDataDecryptorFactory.recoverSessionData(this.keyData.getEncAlgorithm(), byArray, this.keyData.getSecKeyData());
        return byArray2[0];
    }

    public InputStream getDataStream(PBEDataDecryptorFactory pBEDataDecryptorFactory) throws PGPException {
        try {
            boolean bl;
            int n;
            int n2;
            int n3 = this.keyData.getEncAlgorithm();
            byte[] byArray = pBEDataDecryptorFactory.makeKeyFromPassPhrase(n3, this.keyData.getS2K());
            boolean bl2 = this.encData instanceof SymmetricEncIntegrityPacket;
            byte[] byArray2 = pBEDataDecryptorFactory.recoverSessionData(this.keyData.getEncAlgorithm(), byArray, this.keyData.getSecKeyData());
            byte[] byArray3 = new byte[byArray2.length - 1];
            System.arraycopy(byArray2, 1, byArray3, 0, byArray3.length);
            PGPDataDecryptor pGPDataDecryptor = pBEDataDecryptorFactory.createDataDecryptor(bl2, byArray2[0] & 0xFF, byArray3);
            this.encStream = new BCPGInputStream(pGPDataDecryptor.getInputStream(this.encData.getInputStream()));
            if (bl2) {
                this.truncStream = new PGPEncryptedData.TruncatedStream(this.encStream);
                this.integrityCalculator = pGPDataDecryptor.getIntegrityCalculator();
                this.encStream = new TeeInputStream(this.truncStream, this.integrityCalculator.getOutputStream());
            }
            byte[] byArray4 = new byte[pGPDataDecryptor.getBlockSize()];
            for (n2 = 0; n2 != byArray4.length; ++n2) {
                n = this.encStream.read();
                if (n < 0) {
                    throw new EOFException("unexpected end of stream.");
                }
                byArray4[n2] = (byte)n;
            }
            n2 = this.encStream.read();
            n = this.encStream.read();
            if (n2 < 0 || n < 0) {
                throw new EOFException("unexpected end of stream.");
            }
            boolean bl3 = byArray4[byArray4.length - 2] == (byte)n2 && byArray4[byArray4.length - 1] == (byte)n;
            boolean bl4 = bl = n2 == 0 && n == 0;
            if (!bl3 && !bl) {
                throw new PGPDataValidationException("data check failed.");
            }
            return this.encStream;
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }
}

