/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gradle.internal.impldep.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.gradle.internal.impldep.org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.gradle.internal.impldep.org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.gradle.internal.impldep.org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.gradle.internal.impldep.org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.gradle.internal.impldep.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.gradle.internal.impldep.org.codehaus.plexus.configuration.PlexusConfiguration;
import org.gradle.internal.impldep.org.codehaus.plexus.util.StringUtils;

public class CollectionConverter
extends AbstractConfigurationConverter {
    public boolean canConvert(Class type) {
        return Collection.class.isAssignableFrom(type) && !Map.class.isAssignableFrom(type);
    }

    public Object fromConfiguration(ConverterLookup converterLookup, PlexusConfiguration configuration, Class type, Class baseType, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object retValue = this.fromExpression(configuration, expressionEvaluator, type);
        if (retValue != null) {
            return retValue;
        }
        Class implementation = this.getClassForImplementationHint(null, configuration, classLoader);
        if (implementation != null) {
            retValue = this.instantiateObject(implementation);
        } else {
            int modifiers = type.getModifiers();
            if (Modifier.isAbstract(modifiers)) {
                retValue = this.getDefaultCollection(type);
            } else {
                try {
                    retValue = type.newInstance();
                }
                catch (IllegalAccessException e) {
                    String msg = "An attempt to convert configuration entry " + configuration.getName() + "' into " + type + " object failed: " + e.getMessage();
                    throw new ComponentConfigurationException(msg, (Throwable)e);
                }
                catch (InstantiationException e) {
                    String msg = "An attempt to convert configuration entry " + configuration.getName() + "' into " + type + " object failed: " + e.getMessage();
                    throw new ComponentConfigurationException(msg, (Throwable)e);
                }
            }
        }
        for (int i = 0; i < configuration.getChildCount(); ++i) {
            PlexusConfiguration c = configuration.getChild(i);
            String configEntry = c.getName();
            String name = this.fromXML(configEntry);
            Class<Object> childType = this.getClassForImplementationHint(null, c, classLoader);
            if (childType == null && name.indexOf(46) > 0) {
                try {
                    childType = classLoader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (childType == null) {
                String className;
                String baseTypeName = baseType.getName();
                int lastDot = baseTypeName.lastIndexOf(46);
                if (lastDot == -1) {
                    className = name;
                } else {
                    String basePackage = baseTypeName.substring(0, lastDot);
                    className = basePackage + "." + StringUtils.capitalizeFirstLetter(name);
                }
                try {
                    childType = classLoader.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    if (c.getChildCount() == 0) {
                        childType = String.class;
                    }
                    throw new ComponentConfigurationException("Error loading class '" + className + "'", (Throwable)e);
                }
            }
            ConfigurationConverter converter = converterLookup.lookupConverterForType(childType);
            Object object = converter.fromConfiguration(converterLookup, c, childType, baseType, classLoader, expressionEvaluator, listener);
            Collection collection = (Collection)retValue;
            collection.add(object);
        }
        return retValue;
    }

    protected Collection getDefaultCollection(Class collectionType) {
        AbstractCollection retValue = null;
        if (List.class.isAssignableFrom(collectionType)) {
            retValue = new ArrayList();
        } else if (SortedSet.class.isAssignableFrom(collectionType)) {
            retValue = new TreeSet();
        } else if (Set.class.isAssignableFrom(collectionType)) {
            retValue = new HashSet();
        }
        return retValue;
    }
}

