/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.codehaus.plexus.util.dag;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gradle.internal.impldep.org.codehaus.plexus.util.dag.DAG;
import org.gradle.internal.impldep.org.codehaus.plexus.util.dag.Vertex;

public class TopologicalSorter {
    private static final Integer NOT_VISTITED = new Integer(0);
    private static final Integer VISITING = new Integer(1);
    private static final Integer VISITED = new Integer(2);

    public static List sort(DAG graph) {
        return TopologicalSorter.dfs(graph);
    }

    public static List sort(Vertex vertex) {
        LinkedList retValue = new LinkedList();
        HashMap vertexStateMap = new HashMap();
        TopologicalSorter.dfsVisit(vertex, vertexStateMap, retValue);
        return retValue;
    }

    private static List dfs(DAG graph) {
        List verticies = graph.getVerticies();
        LinkedList retValue = new LinkedList();
        HashMap vertexStateMap = new HashMap();
        for (Vertex vertex : verticies) {
            if (!TopologicalSorter.isNotVisited(vertex, vertexStateMap)) continue;
            TopologicalSorter.dfsVisit(vertex, vertexStateMap, retValue);
        }
        return retValue;
    }

    private static boolean isNotVisited(Vertex vertex, Map vertexStateMap) {
        if (!vertexStateMap.containsKey(vertex)) {
            return true;
        }
        Integer state = (Integer)vertexStateMap.get(vertex);
        return NOT_VISTITED.equals(state);
    }

    private static void dfsVisit(Vertex vertex, Map vertexStateMap, LinkedList list) {
        vertexStateMap.put(vertex, VISITING);
        List verticies = vertex.getChildren();
        for (Vertex v : verticies) {
            if (!TopologicalSorter.isNotVisited(v, vertexStateMap)) continue;
            TopologicalSorter.dfsVisit(v, vertexStateMap, list);
        }
        vertexStateMap.put(vertex, VISITED);
        list.add(vertex.getLabel());
    }
}

