/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.file.PackBitmapIndexV1;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.file.PackIndex;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.AnyObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectId;

public abstract class PackBitmapIndex {
    public static final int FLAG_REUSE = 1;
    byte[] packChecksum;

    public static PackBitmapIndex open(File idxFile, PackIndex packIndex, PackReverseIndex reverseIndex) throws IOException {
        FileInputStream fd = new FileInputStream(idxFile);
        try {
            PackBitmapIndex packBitmapIndex = PackBitmapIndex.read(fd, packIndex, reverseIndex);
            return packBitmapIndex;
        }
        catch (IOException ioe) {
            String path = idxFile.getAbsolutePath();
            IOException err = new IOException(MessageFormat.format(JGitText.get().unreadablePackIndex, path));
            err.initCause(ioe);
            throw err;
        }
        finally {
            try {
                fd.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static PackBitmapIndex read(InputStream fd, PackIndex packIndex, PackReverseIndex reverseIndex) throws IOException {
        return new PackBitmapIndexV1(fd, packIndex, reverseIndex);
    }

    public abstract int findPosition(AnyObjectId var1);

    public abstract ObjectId getObject(int var1) throws IllegalArgumentException;

    public abstract EWAHCompressedBitmap ofObjectType(EWAHCompressedBitmap var1, int var2);

    public abstract EWAHCompressedBitmap getBitmap(AnyObjectId var1);

    public abstract int getObjectCount();

    public abstract int getBitmapCount();
}

