/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.lib;

import org.gradle.internal.impldep.org.eclipse.jgit.lib.Config;

public class CoreConfig {
    public static final Config.SectionParser<CoreConfig> KEY = new Config.SectionParser<CoreConfig>(){

        @Override
        public CoreConfig parse(Config cfg) {
            return new CoreConfig(cfg);
        }
    };
    private final int compression;
    private final int packIndexVersion;
    private final boolean logAllRefUpdates;
    private final String excludesfile;
    private final String attributesfile;

    private CoreConfig(Config rc) {
        this.compression = rc.getInt("core", "compression", -1);
        this.packIndexVersion = rc.getInt("pack", "indexversion", 2);
        this.logAllRefUpdates = rc.getBoolean("core", "logallrefupdates", true);
        this.excludesfile = rc.getString("core", null, "excludesfile");
        this.attributesfile = rc.getString("core", null, "attributesfile");
    }

    public int getCompression() {
        return this.compression;
    }

    public int getPackIndexVersion() {
        return this.packIndexVersion;
    }

    public boolean isLogAllRefUpdates() {
        return this.logAllRefUpdates;
    }

    public String getExcludesFile() {
        return this.excludesfile;
    }

    public String getAttributesFile() {
        return this.attributesfile;
    }

    public static enum AutoCRLF {
        FALSE,
        TRUE,
        INPUT;

    }

    public static enum CheckStat {
        MINIMAL,
        DEFAULT;

    }

    public static enum EOL {
        CRLF,
        LF,
        NATIVE;

    }

    public static enum EolStreamType {
        TEXT_CRLF,
        TEXT_LF,
        AUTO_CRLF,
        AUTO_LF,
        DIRECT;

    }

    public static enum HideDotFiles {
        FALSE,
        TRUE,
        DOTGITONLY;

    }

    public static enum SymLinks {
        FALSE,
        TRUE;

    }
}

