/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;

public class StreamCopyThread
extends Thread {
    private static final int BUFFER_SIZE = 1024;
    private final InputStream src;
    private final OutputStream dst;
    private volatile boolean done;
    private final AtomicInteger flushCount = new AtomicInteger(0);

    public StreamCopyThread(InputStream i, OutputStream o) {
        this.setName(Thread.currentThread().getName() + "-StreamCopy");
        this.src = i;
        this.dst = o;
    }

    public void flush() {
        this.flushCount.incrementAndGet();
        this.interrupt();
    }

    public void halt() throws InterruptedException {
        while (true) {
            this.join(250L);
            if (!this.isAlive()) break;
            this.done = true;
            this.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            byte[] buf = new byte[1024];
            int flushCountBeforeRead = 0;
            boolean readInterrupted = false;
            try {
                while (true) {
                    int n;
                    if (readInterrupted) {
                        this.dst.flush();
                        readInterrupted = false;
                        if (!this.flushCount.compareAndSet(flushCountBeforeRead, 0)) {
                            this.interrupt();
                        }
                    }
                    if (this.done) {
                        break;
                    }
                    flushCountBeforeRead = this.flushCount.get();
                    try {
                        n = this.src.read(buf);
                    }
                    catch (InterruptedIOException wakey) {
                        readInterrupted = true;
                        continue;
                    }
                    if (n < 0) {
                        break;
                    }
                    boolean writeInterrupted = false;
                    while (true) {
                        try {
                            this.dst.write(buf, 0, n);
                        }
                        catch (InterruptedIOException wakey) {
                            writeInterrupted = true;
                            continue;
                        }
                        break;
                    }
                    if (!writeInterrupted && this.flushCount.get() <= 0) continue;
                    this.interrupt();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        finally {
            try {
                this.src.close();
            }
            catch (IOException iOException) {}
            try {
                this.dst.close();
            }
            catch (IOException iOException) {}
        }
    }
}

