/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.aether.connector.wagon;

import java.io.File;
import org.gradle.internal.impldep.org.apache.maven.wagon.events.TransferEvent;
import org.gradle.internal.impldep.org.apache.maven.wagon.observers.AbstractTransferListener;
import org.gradle.internal.impldep.org.sonatype.aether.RequestTrace;
import org.gradle.internal.impldep.org.sonatype.aether.connector.wagon.WagonCancelledException;
import org.gradle.internal.impldep.org.sonatype.aether.transfer.TransferCancelledException;
import org.gradle.internal.impldep.org.sonatype.aether.transfer.TransferEvent;
import org.gradle.internal.impldep.org.sonatype.aether.transfer.TransferListener;
import org.gradle.internal.impldep.org.sonatype.aether.util.listener.DefaultTransferEvent;
import org.gradle.internal.impldep.org.sonatype.aether.util.listener.DefaultTransferResource;

class WagonTransferListenerAdapter
extends AbstractTransferListener {
    private final DefaultTransferResource resource;
    private final TransferListener delegate;
    private long transferredBytes;

    public WagonTransferListenerAdapter(TransferListener delegate, String repositoryUrl, String resourceName, File file, RequestTrace trace) {
        this.delegate = delegate;
        this.resource = new DefaultTransferResource(repositoryUrl, resourceName, file, trace);
    }

    public void transferStarted(TransferEvent event) {
        this.transferredBytes = 0L;
        this.resource.setContentLength(event.getResource().getContentLength());
        try {
            this.delegate.transferStarted(this.wrap(event, TransferEvent.EventType.STARTED));
        }
        catch (TransferCancelledException transferCancelledException) {
            // empty catch block
        }
    }

    public void transferProgress(TransferEvent event, byte[] buffer, int length) {
        this.transferredBytes += (long)length;
        try {
            this.delegate.transferProgressed(this.wrap(event, TransferEvent.EventType.PROGRESSED).setDataBuffer(buffer, 0, length));
        }
        catch (TransferCancelledException e) {
            throw new WagonCancelledException(e);
        }
    }

    private DefaultTransferEvent wrap(TransferEvent event, TransferEvent.EventType type) {
        DefaultTransferEvent e = this.newEvent();
        e.setRequestType(event.getRequestType() == 6 ? TransferEvent.RequestType.PUT : TransferEvent.RequestType.GET);
        e.setType(type);
        return e;
    }

    public DefaultTransferEvent newEvent() {
        DefaultTransferEvent e = new DefaultTransferEvent();
        e.setResource(this.resource);
        e.setTransferredBytes(this.transferredBytes);
        return e;
    }
}

