/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.generators;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import jetbrains.plugins.yeoman.YeomanBundle;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorInfo;
import jetbrains.plugins.yeoman.generators.YeomanInstalledGeneratorInfo;
import jetbrains.plugins.yeoman.projectGenerator.ui.run.YeomanRunGeneratorForm;
import jetbrains.plugins.yeoman.projectGenerator.util.YeomanCommandLineUtil;
import jetbrains.plugins.yeoman.settings.YeomanNodeFiles;
import org.jetbrains.annotations.NotNull;

public class YeomanGeneratorInstaller {
    public static final String LOCAL_GENERATORS_RELATIVE_PATH = "extLibs" + File.separator + "yeoman" + File.separator + "generators_local";

    public static YeomanGeneratorInstaller getInstance() {
        return new YeomanGeneratorInstaller();
    }

    public File install(YeomanGeneratorInfo info, YeomanNodeFiles files) {
        if (files.getInterpreter() == null) {
            throw new RuntimeException(YeomanBundle.message("yeoman.generator.node.error", new Object[0]));
        }
        File directory = YeomanGeneratorInstaller.getModuleDirectory(info);
        FileUtil.createDirectory((File)new File(directory, "node_modules"));
        GeneralCommandLine commandLine = YeomanCommandLineUtil.createNpmInstallCommandLine(null, directory);
        String infoName = info.getName();
        assert (infoName != null);
        commandLine.addParameter(infoName);
        YeomanRunGeneratorForm.LOGGER.debug(commandLine.getCommandLineString());
        Ref exceptionRef = Ref.create(null);
        Runnable action = YeomanCommandLineUtil.createExecuteCommandLineAction(DefaultProjectFactory.getInstance().getDefaultProject(), commandLine, (Ref<? super RuntimeException>)exceptionRef, null);
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(action, "Yeoman Generator Installation", true, null)) {
            FileUtil.delete((File)directory);
            return null;
        }
        RuntimeException exception = (RuntimeException)exceptionRef.get();
        if (exception != null) {
            YeomanRunGeneratorForm.LOGGER.debug(exception.getMessage(), (Throwable)exception);
            FileUtil.delete((File)directory);
            throw exception;
        }
        return directory;
    }

    public boolean uninstall(YeomanInstalledGeneratorInfo installInfo) {
        File file = new File(FileUtil.toSystemDependentName((String)installInfo.getFilePath()));
        if (file.exists()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                if (file.exists()) {
                    FileUtil.delete((File)file);
                }
            }, "Uninstalling Yeoman Generator...", false, null);
        }
        return true;
    }

    @NotNull
    private static File getModuleDirectory(YeomanGeneratorInfo info) {
        File file = new File(PathManager.getSystemPath(), LOCAL_GENERATORS_RELATIVE_PATH + File.separator + info.getName());
        FileUtil.createParentDirs((File)file);
        FileUtil.createDirectory((File)file);
        File file2 = file;
        if (file2 == null) {
            YeomanGeneratorInstaller.$$$reportNull$$$0(0);
        }
        return file2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/generators/YeomanGeneratorInstaller", "getModuleDirectory"));
    }
}

