/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.builder;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.WebModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import icons.YeomanIcons;
import javax.swing.Icon;
import jetbrains.plugins.yeoman.projectGenerator.builder.YeomanRunGeneratorWizardStep;
import jetbrains.plugins.yeoman.projectGenerator.builder.YeomanSelectGeneratorWizardStep;
import jetbrains.plugins.yeoman.projectGenerator.template.YeomanProjectGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YeomanModuleBuilder
extends ModuleBuilder {
    private final YeomanProjectGenerator.Settings mySettings = new YeomanProjectGenerator.Settings();

    public YeomanModuleBuilder() {
        this.mySettings.tempPath = YeomanProjectGenerator.createTemp().getAbsolutePath();
    }

    public void setupRootModel(ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        this.doAddContentEntry(modifiableRootModel);
    }

    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            YeomanModuleBuilder.$$$reportNull$$$0(0);
        }
        if (modulesProvider == null) {
            YeomanModuleBuilder.$$$reportNull$$$0(1);
        }
        return new ModuleWizardStep[]{new YeomanRunGeneratorWizardStep(this, wizardContext)};
    }

    public String getName() {
        return "Yeoman";
    }

    public String getPresentableName() {
        return "Yeoman";
    }

    public String getDescription() {
        return "Yeoman project Type";
    }

    @Nullable
    public String getBuilderId() {
        return "Yeoman";
    }

    public Icon getNodeIcon() {
        return YeomanIcons.Yeoman;
    }

    public ModuleType getModuleType() {
        return WebModuleType.getInstance();
    }

    public String getParentGroup() {
        return "Static Web";
    }

    @Nullable
    public Module commitModule(@NotNull Project project, @Nullable ModifiableModuleModel model) {
        if (project == null) {
            YeomanModuleBuilder.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Module module = super.commitModule(project, model);
        if (module != null) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            VirtualFile[] contentRoots = moduleRootManager.getContentRoots();
            VirtualFile toStoreDirectory = project.getBaseDir();
            if (contentRoots.length > 0 && contentRoots[0] != null) {
                toStoreDirectory = contentRoots[0];
            }
            YeomanProjectGenerator.generateProject(project, toStoreDirectory, this.mySettings);
        }
        return module;
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        YeomanSelectGeneratorWizardStep step = new YeomanSelectGeneratorWizardStep(this, context);
        Disposer.register((Disposable)parentDisposable, (Disposable)step);
        return step;
    }

    public YeomanProjectGenerator.Settings getSettings() {
        return this.mySettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "jetbrains/plugins/yeoman/projectGenerator/builder/YeomanModuleBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createWizardSteps";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "commitModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

