/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.builder;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.StepWithSubSteps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jetbrains.plugins.yeoman.projectGenerator.builder.YeomanModuleBuilder;
import jetbrains.plugins.yeoman.projectGenerator.builder.YeomanSelectGeneratorWizardStep;
import jetbrains.plugins.yeoman.projectGenerator.template.YeomanProjectGeneratorPanel;
import jetbrains.plugins.yeoman.projectGenerator.template.YeomanProjectGeneratorRunPanel;

public class YeomanRunGeneratorWizardStep
extends ModuleWizardStep
implements StepWithSubSteps,
Disposable {
    private final YeomanModuleBuilder myBuilder;
    private JPanel myOwnerPanel;
    private YeomanProjectGeneratorRunPanel myPanel;
    private JScrollPane myScrollPane;

    public YeomanRunGeneratorWizardStep(YeomanModuleBuilder builder, WizardContext context) {
        this.myBuilder = builder;
        Disposer.register((Disposable)context.getDisposable(), (Disposable)this);
    }

    public JComponent getComponent() {
        if (this.myOwnerPanel == null) {
            this.myOwnerPanel = new JPanel(new BorderLayout());
            this.myScrollPane = YeomanProjectGeneratorPanel.createScrollPane();
            this.myOwnerPanel.add((Component)this.myScrollPane, "Center");
        }
        return this.myOwnerPanel;
    }

    private void createPanelIfNecessary() {
        if (this.myPanel == null) {
            this.myPanel = new YeomanProjectGeneratorRunPanel(YeomanSelectGeneratorWizardStep.createOwnerPanel(this.myScrollPane, this.myOwnerPanel), this.myBuilder.getSettings());
        }
    }

    public void updateDataModel() {
        if (this.myPanel != null) {
            if (this.myPanel.isReadyToClose()) {
                this.myPanel.commitSettings();
                Disposer.dispose((Disposable)this.myPanel);
            } else if (this.myPanel.isRendered()) {
                this.myPanel.next(null);
            }
        }
    }

    public void updateStep() {
        if (this.myOwnerPanel != null) {
            this.createPanelIfNecessary();
            if (!this.myPanel.isRendered()) {
                this.myPanel.render();
            }
        }
    }

    public boolean isLast() {
        return this.myPanel == null || this.myPanel.isReadyToClose();
    }

    public boolean isFirst() {
        return true;
    }

    public void doPreviousAction() {
        if (this.myPanel != null) {
            Disposer.dispose((Disposable)this.myPanel);
            this.myPanel = null;
        }
    }

    public void dispose() {
        if (this.myPanel != null) {
            Disposer.dispose((Disposable)this.myPanel);
            this.myPanel = null;
        }
    }
}

