/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.step;

import com.intellij.ide.util.projectWizard.AbstractNewProjectStep;
import com.intellij.ide.util.projectWizard.ProjectSettingsStepBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.DirectoryProjectGenerator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import jetbrains.plugins.yeoman.projectGenerator.template.YeomanProjectGenerator;
import jetbrains.plugins.yeoman.projectGenerator.template.YeomanProjectGeneratorOwnerPanel;
import jetbrains.plugins.yeoman.projectGenerator.template.YeomanProjectGeneratorPanel;

public class YeomanProjectSettingsStep
extends ProjectSettingsStepBase {
    private YeomanProjectGeneratorPanel myPanel;

    public YeomanProjectSettingsStep(DirectoryProjectGenerator projectGenerator, AbstractNewProjectStep.AbstractCallback callback) {
        super(projectGenerator, callback);
    }

    public boolean checkValid() {
        boolean b = super.checkValid();
        if (!b) {
            return false;
        }
        if (this.myPanel != null) {
            if (!this.myPanel.isEnable()) {
                this.setErrorText("");
                return false;
            }
            String validate = this.myPanel.validate();
            if (!StringUtil.isEmpty((String)validate)) {
                this.setErrorText(validate);
                return false;
            }
        }
        return true;
    }

    public void onPanelSelected() {
        this.checkValid();
    }

    public JPanel createPanel() {
        this.myLazyGeneratorPeer = this.createLazyPeer();
        if (this.myProjectGenerator instanceof YeomanProjectGenerator) {
            final YeomanProjectGeneratorPanel panel = ((YeomanProjectGenerator)this.myProjectGenerator).createPanel();
            panel.setValidateHandler(new YeomanProjectGeneratorOwnerPanel.ValidateHandler(){

                @Override
                public void validate() {
                    YeomanProjectSettingsStep.this.checkValid();
                }
            });
            ActionListener closeAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogWrapper dialog = DialogWrapper.findInstance((Component)YeomanProjectSettingsStep.this.myCreateButton);
                    if (dialog != null) {
                        dialog.close(0);
                    }
                    Project project = ProjectManager.getInstance().getDefaultProject();
                    AbstractNewProjectStep.doGenerateProject((Project)project, (String)YeomanProjectSettingsStep.this.getProjectLocation(), (DirectoryProjectGenerator)YeomanProjectSettingsStep.this.myProjectGenerator, (Object)panel.getSettings());
                }
            };
            LabeledComponent component = this.createLocationComponent();
            component.setLabelLocation("West");
            panel.init((LabeledComponent<TextFieldWithBrowseButton>)component, this.createErrorLabel(), this.createActionButton(), closeAction);
            panel.showFirstStep();
            panel.getMainPanel().addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    Disposer.dispose((Disposable)panel);
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }
            });
            this.registerValidators();
            this.myPanel = panel;
            return panel.getMainPanel();
        }
        return new JPanel();
    }
}

