/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.template;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.ide.util.projectWizard.AbstractNewProjectStep;
import com.intellij.ide.util.projectWizard.CustomStepProjectGenerator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractActionWithPanel;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.DirectoryProjectGeneratorBase;
import icons.YeomanIcons;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import jetbrains.plugins.yeoman.YeomanBundle;
import jetbrains.plugins.yeoman.generators.YeomanInstalledGeneratorInfo;
import jetbrains.plugins.yeoman.projectGenerator.step.YeomanProjectSettingsStep;
import jetbrains.plugins.yeoman.projectGenerator.template.YeomanProjectGeneratorPanel;
import jetbrains.plugins.yeoman.projectGenerator.ui.run.YeomanRunGeneratorForm;
import jetbrains.plugins.yeoman.projectGenerator.util.YeomanCommandLineUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YeomanProjectGenerator
extends DirectoryProjectGeneratorBase<Settings>
implements CustomStepProjectGenerator {
    public static final Logger LOGGER = Logger.getInstance(YeomanRunGeneratorForm.class);
    public static final String BOWER_JSON = "bower.json";

    @Nls
    @NotNull
    public String getName() {
        String string = YeomanBundle.message("settings.yeoman.name", new Object[0]);
        if (string == null) {
            YeomanProjectGenerator.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public Icon getLogo() {
        return YeomanIcons.Yeoman;
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Settings settings, @NotNull Module module) {
        if (project == null) {
            YeomanProjectGenerator.$$$reportNull$$$0(1);
        }
        if (baseDir == null) {
            YeomanProjectGenerator.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            YeomanProjectGenerator.$$$reportNull$$$0(3);
        }
        if (module == null) {
            YeomanProjectGenerator.$$$reportNull$$$0(4);
        }
        YeomanProjectGenerator.generateProject(project, baseDir, settings);
    }

    public static void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @Nullable Settings settings) {
        if (project == null) {
            YeomanProjectGenerator.$$$reportNull$$$0(5);
        }
        if (baseDir == null) {
            YeomanProjectGenerator.$$$reportNull$$$0(6);
        }
        assert (settings != null);
        File baseDirFile = VfsUtilCore.virtualToIoFile((VirtualFile)baseDir);
        if (ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                indicator.setText(YeomanBundle.message("yeoman.generator.running.process", new Object[0]));
                YeomanProjectGenerator.moveFiles(new File(settings.appPath), baseDirFile);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }, YeomanBundle.message("yeoman.welcome.dialog.after.initialize", new Object[0]), false, project) && settings.runNpmAndBowerInstall && new File(baseDirFile, "package.json").exists()) {
            YeomanProjectGenerator.installAllDepends(project, baseDirFile);
        }
        baseDir.refresh(true, true);
    }

    private static void moveFiles(@NotNull File fromDir, @NotNull File toDir) {
        if (fromDir == null) {
            YeomanProjectGenerator.$$$reportNull$$$0(7);
        }
        if (toDir == null) {
            YeomanProjectGenerator.$$$reportNull$$$0(8);
        }
        try {
            File toFile;
            File fromFile;
            File[] files = fromDir.listFiles();
            if (files == null) {
                return;
            }
            boolean success = true;
            File[] fileArray = files;
            int n = fileArray.length;
            for (int i = 0; i < n && (success = (fromFile = fileArray[i]).renameTo(toFile = new File(toDir, fromFile.getName()))); ++i) {
            }
            if (success) {
                return;
            }
            FileUtil.copyDir((File)fromDir, (File)toDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            fromDir.delete();
        }
    }

    private static void installAllDepends(@NotNull Project project, @NotNull File dir) {
        if (project == null) {
            YeomanProjectGenerator.$$$reportNull$$$0(9);
        }
        if (dir == null) {
            YeomanProjectGenerator.$$$reportNull$$$0(10);
        }
        GeneralCommandLine npmInstallCommandLine = YeomanCommandLineUtil.createNpmInstallCommandLine(project, dir);
        YeomanProjectGenerator.installDepends(project, npmInstallCommandLine, YeomanBundle.message("yeoman.generator.running.npm", new Object[0]), () -> {
            if (dir == null) {
                YeomanProjectGenerator.$$$reportNull$$$0(15);
            }
            if (project == null) {
                YeomanProjectGenerator.$$$reportNull$$$0(16);
            }
            if (new File(dir, BOWER_JSON).exists()) {
                GeneralCommandLine line = YeomanCommandLineUtil.createBowerInstallCommandLine(project, dir);
                YeomanProjectGenerator.installDepends(project, line, YeomanBundle.message("yeoman.generator.running.bower", new Object[0]), null);
            }
        });
    }

    private static void installDepends(final @NotNull Project project, final @Nullable GeneralCommandLine line, String title, final Runnable success) {
        if (project == null) {
            YeomanProjectGenerator.$$$reportNull$$$0(11);
        }
        if (line == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project == null) {
                YeomanProjectGenerator.$$$reportNull$$$0(14);
            }
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, title, true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    YeomanCommandLineUtil.createExecuteCommandLineAction(project, line, (Ref<? super RuntimeException>)new Ref(null), indicator).run();
                }

                public boolean shouldStartInBackground() {
                    return false;
                }

                public void onSuccess() {
                    if (success != null) {
                        success.run();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGenerator$1", "run"));
                }
            });
        });
    }

    @NotNull
    public ValidationResult validate(@NotNull String baseDirPath) {
        if (baseDirPath == null) {
            YeomanProjectGenerator.$$$reportNull$$$0(12);
        }
        ValidationResult validationResult = ValidationResult.OK;
        if (validationResult == null) {
            YeomanProjectGenerator.$$$reportNull$$$0(13);
        }
        return validationResult;
    }

    public YeomanProjectGeneratorPanel createPanel() {
        Settings settings = new Settings();
        settings.tempPath = YeomanProjectGenerator.createTemp().getAbsolutePath();
        return new YeomanProjectGeneratorPanel(settings);
    }

    public static File createTemp() {
        try {
            return FileUtil.createTempDirectory((String)"yeoman-project-generator", null, (boolean)false);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public AbstractActionWithPanel createStep(DirectoryProjectGenerator projectGenerator, AbstractNewProjectStep.AbstractCallback callback) {
        return new YeomanProjectSettingsStep(projectGenerator, callback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGenerator";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromDir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGenerator";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "moveFiles";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "installAllDepends";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "installDepends";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$installDepends$2";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$installAllDepends$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Settings {
        public String tempPath;
        public String appPath;
        public boolean runNpmAndBowerInstall = true;
        public String options;
        public YeomanInstalledGeneratorInfo info;
    }
}

