/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.ui.list;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.RoundedActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBGradientPaint;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.YeomanIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import jetbrains.plugins.yeoman.YeomanBundle;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorFullInfo;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorInfo;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorInstaller;
import jetbrains.plugins.yeoman.generators.YeomanInstalledGeneratorInfo;
import jetbrains.plugins.yeoman.projectGenerator.ui.list.YeomanGeneratorsMain;
import jetbrains.plugins.yeoman.settings.YeomanGlobalSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YeomanGeneratorInfoPanelHeader {
    private final JBPanel myRootPanel;
    private final JBLabel myGeneratorHeaderLabel;
    private final YeomanGeneratorsMain myParent;
    private final boolean myHasInstallButton;
    private YeomanGeneratorInfo myInfo;
    private final JButton myActionButton;
    private final JPanel myStartsHolder;
    private State myState = State.AVAILABLE;

    public YeomanGeneratorInfoPanelHeader(YeomanGeneratorsMain parent, boolean allAvailable) {
        this.myParent = parent;
        this.myHasInstallButton = allAvailable;
        this.myRootPanel = new JBPanel((LayoutManager)new VerticalLayout(5, 2));
        this.myRootPanel.setBackground(UIUtil.getTextFieldBackground());
        this.myRootPanel.setBorder((Border)JBUI.Borders.empty());
        this.myGeneratorHeaderLabel = new JBLabel();
        this.myGeneratorHeaderLabel.setFont(UIUtil.getLabelFont());
        UIUtil.addBorder((JComponent)this.myGeneratorHeaderLabel, (Border)JBUI.Borders.empty((int)12, (int)0, (int)0, (int)0));
        this.myRootPanel.add((Component)this.myGeneratorHeaderLabel);
        this.myActionButton = this.createActionButton();
        RelativeFont.BOLD.install((Component)this.myGeneratorHeaderLabel);
        this.myRootPanel.add((Component)this.myActionButton);
        this.myActionButton.setVisible(false);
        this.myStartsHolder = new JPanel(new BorderLayout());
        this.myStartsHolder.setBackground(UIUtil.getTextFieldBackground());
        this.myRootPanel.add((Component)this.myStartsHolder);
    }

    private JButton createActionButton() {
        RoundedActionButton actionButton = new RoundedActionButton(5, 8){

            @NotNull
            protected Color getButtonForeground() {
                switch (YeomanGeneratorInfoPanelHeader.this.myState) {
                    case AVAILABLE: {
                        JBColor jBColor = new JBColor((Color)Gray._240, (Color)Gray._210);
                        if (jBColor == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return jBColor;
                    }
                    case GLOBAL_INSTALLED: 
                    case LOCAL_INSTALLED: {
                        JBColor jBColor = new JBColor((Color)Gray._0, (Color)Gray._210);
                        if (jBColor == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return jBColor;
                    }
                }
                JBColor jBColor = new JBColor((Color)Gray._80, (Color)Gray._60);
                if (jBColor == null) {
                    1.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            protected Paint getBackgroundPaint() {
                switch (YeomanGeneratorInfoPanelHeader.this.myState) {
                    case AVAILABLE: {
                        JBGradientPaint jBGradientPaint = new JBGradientPaint((JComponent)((Object)this), (Color)new JBColor(new Color(96, 204, 105), new Color(81, 149, 87)), (Color)new JBColor(new Color(50, 101, 41), new Color(40, 70, 47)));
                        if (jBGradientPaint == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return jBGradientPaint;
                    }
                    case GLOBAL_INSTALLED: 
                    case LOCAL_INSTALLED: {
                        Object object = UIUtil.isUnderDarcula() ? ColorUtil.mix((Color)UIManager.getColor("Button.darcula.startColor"), (Color)UIManager.getColor("Button.darcula.endColor"), (double)0.5) : Gray._240;
                        if (object == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        return object;
                    }
                }
                Gray gray = Gray._238;
                if (gray == null) {
                    1.$$$reportNull$$$0(5);
                }
                return gray;
            }

            @NotNull
            protected Paint getBackgroundBorderPaint() {
                switch (YeomanGeneratorInfoPanelHeader.this.myState) {
                    case AVAILABLE: {
                        JBColor jBColor = new JBColor(new Color(201, 223, 201), (Color)Gray._70);
                        if (jBColor == null) {
                            1.$$$reportNull$$$0(6);
                        }
                        return jBColor;
                    }
                    case GLOBAL_INSTALLED: 
                    case LOCAL_INSTALLED: {
                        JBColor jBColor = new JBColor((Color)Gray._220, Gray._100.withAlpha(180));
                        if (jBColor == null) {
                            1.$$$reportNull$$$0(7);
                        }
                        return jBColor;
                    }
                }
                Gray gray = Gray._208;
                if (gray == null) {
                    1.$$$reportNull$$$0(8);
                }
                return gray;
            }

            public String getText() {
                switch (YeomanGeneratorInfoPanelHeader.this.myState) {
                    case AVAILABLE: {
                        return YeomanBundle.message("yeoman.generators.dialog.install.generator", new Object[0]);
                    }
                    case GLOBAL_INSTALLED: 
                    case LOCAL_INSTALLED: {
                        return YeomanBundle.message("yeoman.generators.dialog.uninstall.generator", new Object[0]);
                    }
                }
                return super.getText();
            }

            public Icon getIcon() {
                switch (YeomanGeneratorInfoPanelHeader.this.myState) {
                    case AVAILABLE: {
                        return AllIcons.General.DownloadPlugin;
                    }
                    case GLOBAL_INSTALLED: 
                    case LOCAL_INSTALLED: {
                        return AllIcons.Actions.Delete;
                    }
                }
                return super.getIcon();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "jetbrains/plugins/yeoman/projectGenerator/ui/list/YeomanGeneratorInfoPanelHeader$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getButtonForeground";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBackgroundPaint";
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBackgroundBorderPaint";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        actionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                YeomanGeneratorInfo yeomanGeneratorInfo = YeomanGeneratorInfoPanelHeader.this.myInfo;
                if (yeomanGeneratorInfo != null) {
                    boolean updated = false;
                    switch (YeomanGeneratorInfoPanelHeader.this.myState) {
                        case AVAILABLE: {
                            try {
                                updated = null != YeomanGeneratorInstaller.getInstance().install(yeomanGeneratorInfo, YeomanGlobalSettings.getInstance());
                            }
                            catch (RuntimeException ex) {
                                Messages.showErrorDialog((Component)YeomanGeneratorInfoPanelHeader.this.myParent.getMainPanel(), (String)(YeomanBundle.message("yeoman.generators.dialog.install.error", new Object[0]) + " " + yeomanGeneratorInfo.getName()));
                            }
                            break;
                        }
                        case GLOBAL_INSTALLED: 
                        case LOCAL_INSTALLED: {
                            if (0 != Messages.showYesNoDialog((Component)YeomanGeneratorInfoPanelHeader.this.myParent.getMainPanel(), (String)YeomanBundle.message("yeoman.generators.prompt.uninstall", yeomanGeneratorInfo.getName()), (String)YeomanBundle.message("yeoman.generators.prompt.uninstall.title", new Object[0]), (Icon)Messages.getQuestionIcon())) {
                                return;
                            }
                            YeomanInstalledGeneratorInfo installedGeneratorInfo = YeomanGeneratorInfoPanelHeader.this.myParent.getInstalledGeneratorInfo(YeomanGeneratorInfoPanelHeader.this.myInfo);
                            if (installedGeneratorInfo == null) break;
                            updated = YeomanGeneratorInstaller.getInstance().uninstall(installedGeneratorInfo);
                            break;
                        }
                    }
                    if (updated) {
                        YeomanGeneratorInfoPanelHeader.this.myParent.handleUpdate();
                        YeomanGeneratorInfoPanelHeader.this.myParent.select(yeomanGeneratorInfo);
                    }
                }
            }
        });
        return actionButton;
    }

    public JComponent getComponent() {
        return this.myRootPanel;
    }

    public void updateInfo(YeomanGeneratorInfo info) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myInfo = info;
        this.myRootPanel.setVisible(true);
        this.myGeneratorHeaderLabel.setText(info == null ? "no info" : info.getName());
        this.myActionButton.setVisible(false);
        this.myState = this.getState(info);
        if (this.myInfo != null) {
            this.myActionButton.setVisible(this.myHasInstallButton && this.myState != State.GLOBAL_INSTALLED && this.myState != State.INCORRECT);
            YeomanGeneratorFullInfo fullInfo = this.myParent.getFullGeneratorInfo(info);
            this.myStartsHolder.removeAll();
            if (fullInfo == null) {
                this.myStartsHolder.setVisible(false);
            } else {
                this.myStartsHolder.setVisible(true);
                this.myStartsHolder.add(YeomanGeneratorInfoPanelHeader.createPanelWithStartsGithubAndRemoveButton(fullInfo));
            }
        }
    }

    @NotNull
    private State getState(YeomanGeneratorInfo info) {
        if (YeomanGlobalSettings.getInstance().getInterpreter() == null) {
            State state = State.INCORRECT;
            if (state == null) {
                YeomanGeneratorInfoPanelHeader.$$$reportNull$$$0(0);
            }
            return state;
        }
        YeomanInstalledGeneratorInfo installInfo = this.myParent.getInstalledGeneratorInfo(info);
        if (installInfo == null) {
            State state = State.AVAILABLE;
            if (state == null) {
                YeomanGeneratorInfoPanelHeader.$$$reportNull$$$0(1);
            }
            return state;
        }
        State state = installInfo.isGlobal() ? State.GLOBAL_INSTALLED : State.LOCAL_INSTALLED;
        if (state == null) {
            YeomanGeneratorInfoPanelHeader.$$$reportNull$$$0(2);
        }
        return state;
    }

    @Nullable
    private static JComponent createStarsLabel(@NotNull YeomanGeneratorFullInfo fullInfo) {
        int stars;
        if (fullInfo == null) {
            YeomanGeneratorInfoPanelHeader.$$$reportNull$$$0(3);
        }
        if ((stars = fullInfo.getStars()) > 0) {
            JBLabel label = new JBLabel(String.valueOf(stars), YeomanIcons.Rating0, 2);
            label.setFont(UIUtil.getLabelFont());
            return label;
        }
        return null;
    }

    @Nullable
    private static JComponent createOnGithub(@NotNull YeomanGeneratorFullInfo fullInfo) {
        String text;
        if (fullInfo == null) {
            YeomanGeneratorInfoPanelHeader.$$$reportNull$$$0(4);
        }
        if (!StringUtil.isEmpty((String)(text = fullInfo.getWebsite()))) {
            JEditorPane pane = new JEditorPane("text/html", "");
            pane.setEditable(false);
            pane.addHyperlinkListener((HyperlinkListener)new BrowserHyperlinkListener());
            StringBuilder builder = new StringBuilder("<a href=\"" + text + "\">on GitHub</a>");
            YeomanGeneratorsMain.setTextValue(builder, null, pane);
            return pane;
        }
        return null;
    }

    private static JPanel createPanelWithStartsGithubAndRemoveButton(@NotNull YeomanGeneratorFullInfo fullInfo) {
        JComponent github;
        if (fullInfo == null) {
            YeomanGeneratorInfoPanelHeader.$$$reportNull$$$0(5);
        }
        JPanel result = new JPanel((LayoutManager)new HorizontalLayout(1, 0));
        result.setBorder((Border)JBUI.Borders.empty());
        result.setBackground(UIUtil.getTextFieldBackground());
        JComponent label = YeomanGeneratorInfoPanelHeader.createStarsLabel(fullInfo);
        if (label != null) {
            result.add(label);
        }
        if ((github = YeomanGeneratorInfoPanelHeader.createOnGithub(fullInfo)) != null) {
            result.add(github);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/plugins/yeoman/projectGenerator/ui/list/YeomanGeneratorInfoPanelHeader";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/plugins/yeoman/projectGenerator/ui/list/YeomanGeneratorInfoPanelHeader";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createStarsLabel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createOnGithub";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPanelWithStartsGithubAndRemoveButton";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum State {
        AVAILABLE,
        LOCAL_INSTALLED,
        GLOBAL_INSTALLED,
        INCORRECT;

    }
}

