/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.ui.list;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.SortableColumnModel;
import java.util.Collection;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorInfo;
import jetbrains.plugins.yeoman.projectGenerator.ui.list.YeomanGeneratorCellRenderer;
import org.jetbrains.annotations.Nullable;

public class YeomanGeneratorTableModel
extends AbstractTableModel
implements SortableColumnModel {
    private final ColumnInfo[] myColumnInfos;
    private final List<YeomanGeneratorInfo> myAllView = ContainerUtil.newArrayList();
    private final List<YeomanGeneratorInfo> myView = ContainerUtil.newArrayList();

    public YeomanGeneratorTableModel() {
        this.myColumnInfos = new ColumnInfo[]{new ColumnInfo<YeomanGeneratorInfo, String>("Generators"){

            @Nullable
            public String valueOf(YeomanGeneratorInfo o) {
                return o.getYoName();
            }

            @Nullable
            public TableCellRenderer getRenderer(YeomanGeneratorInfo info) {
                return new YeomanGeneratorCellRenderer(info);
            }
        }};
    }

    public ColumnInfo[] getColumnInfos() {
        return this.myColumnInfos;
    }

    public void setSortable(boolean aBoolean) {
    }

    public boolean isSortable() {
        return true;
    }

    public Object getRowValue(int row) {
        return this.myView.get(row);
    }

    @Nullable
    public RowSorter.SortKey getDefaultSortKey() {
        return null;
    }

    @Override
    public int getRowCount() {
        return this.myView.size();
    }

    @Override
    public int getColumnCount() {
        return this.myColumnInfos.length;
    }

    public YeomanGeneratorInfo getObjectAt(int row) {
        return this.myView.get(row);
    }

    public void setAllViews(Collection<? extends YeomanGeneratorInfo> infos) {
        this.myAllView.clear();
        this.myAllView.addAll(infos);
        this.filter(null);
    }

    protected void filter(@Nullable String filter) {
        this.myView.clear();
        if (StringUtil.isEmpty((String)filter)) {
            this.myView.addAll(this.myAllView);
            this.fireTableDataChanged();
            return;
        }
        for (YeomanGeneratorInfo info : this.myAllView) {
            if (!StringUtil.containsIgnoreCase((String)info.getYoName(), (String)filter)) continue;
            this.myView.add(info);
        }
        this.fireTableDataChanged();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.myColumnInfos[columnIndex].valueOf(this.getRowValue(rowIndex));
    }

    public List<YeomanGeneratorInfo> getView() {
        return this.myView;
    }
}

