/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.ui.list;

import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.Gray;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.text.html.HTMLEditorKit;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorFullInfo;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorInfo;
import jetbrains.plugins.yeoman.generators.YeomanInstalledGeneratorInfo;
import jetbrains.plugins.yeoman.projectGenerator.ui.list.YeomanGeneratorInfoPanelHeader;
import jetbrains.plugins.yeoman.projectGenerator.ui.list.YeomanGeneratorSpeedSearch;
import jetbrains.plugins.yeoman.projectGenerator.ui.list.YeomanGeneratorTable;
import jetbrains.plugins.yeoman.projectGenerator.ui.list.YeomanGeneratorTableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YeomanGeneratorsMain
implements Disposable {
    @NonNls
    private static final String TEXT_SUFFIX = "</body></html>";
    protected JPanel main;
    protected JPanel myToolbarPanel;
    protected JEditorPane myDescriptionTextArea;
    protected JPanel myInfoPanel;
    protected JPanel myTablePanel;
    protected JBScrollPane myDescriptionScrollPane;
    protected JPanel myHeader;
    private JSplitPane mySplitPane;
    protected YeomanGeneratorTable myGeneratorTable;
    @Nullable
    protected MyPluginsFilter myFilter;
    private YeomanGeneratorInfoPanelHeader myGeneratorInfoPanelHeader;
    private ActionToolbar myActionToolbar;
    protected YeomanGeneratorTableModel myModel;

    public YeomanGeneratorTableModel getModel() {
        return this.myModel;
    }

    public YeomanGeneratorsMain() {
        this.$$$setupUI$$$();
    }

    protected void init(boolean isFullInfo) {
        Container parent;
        ActionGroup group;
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.main);
        this.myDescriptionTextArea.setEditorKit(new HTMLEditorKit());
        this.myDescriptionTextArea.setEditable(false);
        this.myDescriptionTextArea.addHyperlinkListener((HyperlinkListener)new BrowserHyperlinkListener());
        this.myDescriptionTextArea.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)0, (int)0));
        this.myModel = new YeomanGeneratorTableModel();
        this.myGeneratorTable = new YeomanGeneratorTable(this.myModel);
        JScrollPane scrollpanel = ScrollPaneFactory.createScrollPane((Component)((Object)this.myGeneratorTable), (int)20, (int)30);
        this.myTablePanel.add((Component)scrollpanel, "Center");
        this.myDescriptionScrollPane.setBackground(UIUtil.getTextFieldBackground());
        BorderUIResource.LineBorderUIResource border = new BorderUIResource.LineBorderUIResource((Color)new JBColor((Color)Gray._220, (Color)Gray._55), 1);
        this.myInfoPanel.setBorder(border);
        this.myGeneratorInfoPanelHeader = new YeomanGeneratorInfoPanelHeader(this, isFullInfo);
        this.myHeader.setBackground(UIUtil.getTextFieldBackground());
        this.myHeader.add((Component)this.myGeneratorInfoPanelHeader.getComponent(), "Center");
        this.installTableActions();
        if (this.myFilter != null) {
            this.myToolbarPanel.add((Component)((Object)this.myFilter), "West");
        }
        if ((group = this.getActionGroup(true)) != null) {
            this.myActionToolbar = ActionManager.getInstance().createActionToolbar("YeomanGenerators", group, true);
            JComponent component = this.myActionToolbar.getComponent();
            component.setBorder((Border)JBUI.Borders.emptyBottom((int)6));
            this.myToolbarPanel.add((Component)component, "Center");
        }
        if ((parent = this.myInfoPanel.getParent()) instanceof Splitter) {
            ((Splitter)parent).setDividerWidth(2);
        }
    }

    protected ActionGroup getActionGroup(boolean b) {
        return null;
    }

    public void dispose() {
    }

    public void repaint() {
        this.myModel.fireTableDataChanged();
    }

    protected void installTableActions() {
        new YeomanGeneratorSpeedSearch(this.myGeneratorTable);
        this.myGeneratorTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                YeomanGeneratorsMain.this.refresh();
            }
        });
    }

    private void refresh() {
        YeomanGeneratorInfo selectedValue = this.getSelectedValue();
        YeomanGeneratorFullInfo generator = this.getFullGeneratorInfo(selectedValue);
        YeomanGeneratorsMain.setTextValue(generator == null ? null : new StringBuilder(generator.getDescription()), null, this.myDescriptionTextArea);
        this.myGeneratorInfoPanelHeader.updateInfo(selectedValue);
        JComponent parent = (JComponent)this.myHeader.getParent();
        parent.revalidate();
        parent.repaint();
    }

    @Nullable
    private YeomanGeneratorInfo getSelectedValue() {
        YeomanGeneratorInfo[] descriptors = this.myGeneratorTable.getSelectedObjects();
        return descriptors != null && descriptors.length == 1 ? descriptors[0] : null;
    }

    private static String getTextPrefix() {
        int fontSize = JBUI.scale((int)13);
        int m1 = JBUI.scale((int)1);
        int m2 = JBUI.scale((int)5);
        return String.format("<html><head>    <style type=\"text/css\">        p {            font-family: Arial,serif; font-size: %dpt; margin: %dpx %dpx        }    </style></head><body style=\"font-family: Arial,serif; font-size: %dpt; margin: %dpx %dpx;\">", fontSize, m1, m1, fontSize, m2, m2);
    }

    public static void setTextValue(@Nullable StringBuilder text, @Nullable String filter, JEditorPane pane) {
        if (text != null) {
            text.insert(0, YeomanGeneratorsMain.getTextPrefix());
            text.append(TEXT_SUFFIX);
            pane.setText(SearchUtil.markup((String)text.toString(), (String)filter).trim());
            pane.setCaretPosition(0);
        } else {
            pane.setText(YeomanGeneratorsMain.getTextPrefix() + TEXT_SUFFIX);
        }
    }

    @NotNull
    public JPanel getMainPanel() {
        JPanel jPanel = this.main;
        if (jPanel == null) {
            YeomanGeneratorsMain.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myHeader = new JPanel(new BorderLayout()){

            @Override
            public Color getBackground() {
                return UIUtil.getTextFieldBackground();
            }
        };
    }

    @Nullable
    public YeomanGeneratorInfo getSelectedObject() {
        return (YeomanGeneratorInfo)ArrayUtil.getFirstElement((Object[])this.myGeneratorTable.getSelectedObjects());
    }

    public void handleUpdate() {
    }

    public void select(@Nullable YeomanGeneratorInfo info) {
        this.myGeneratorTable.select(info);
    }

    @Nullable
    public YeomanInstalledGeneratorInfo getInstalledGeneratorInfo(YeomanGeneratorInfo info) {
        return info instanceof YeomanInstalledGeneratorInfo ? (YeomanInstalledGeneratorInfo)info : null;
    }

    @Nullable
    public YeomanGeneratorFullInfo getFullGeneratorInfo(@Nullable YeomanGeneratorInfo info) {
        return YeomanGeneratorFullInfo.getFullInfo(info);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/projectGenerator/ui/list/YeomanGeneratorsMain", "getMainPanel"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JEditorPane jEditorPane;
        JBScrollPane jBScrollPane;
        JPanel jPanel2;
        JSplitPane jSplitPane;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.main = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.setPreferredSize(new Dimension(550, 205));
        jPanel4.setRequestFocusEnabled(true);
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myToolbarPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 1, 1, 2, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        this.mySplitPane = jSplitPane = new JSplitPane();
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerSize(2);
        ((Component)jSplitPane).setEnabled(false);
        jSplitPane.setOneTouchExpandable(false);
        jPanel5.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myInfoPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.setMinimumSize(new Dimension(50, 50));
        jPanel2.setPreferredSize(new Dimension(300, 200));
        jSplitPane.setRightComponent(jPanel2);
        this.myDescriptionScrollPane = jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, "Center");
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myDescriptionTextArea = jEditorPane = new JEditorPane();
        jEditorPane.setContentType("text/html");
        jEditorPane.setEditable(false);
        jEditorPane.setMargin(new Insets(0, 0, 0, 0));
        jEditorPane.setMaximumSize(new Dimension(-1, -1));
        jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jBScrollPane.setViewportView(jEditorPane);
        JPanel jPanel6 = this.myHeader;
        jPanel2.add((Component)jPanel6, "North");
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 10, 0, 6), null, 0, 0, null, null));
        this.myTablePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setMinimumSize(new Dimension(50, 50));
        jPanel.setPreferredSize(new Dimension(300, 200));
        jSplitPane.setLeftComponent(jPanel);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.main;
    }

    public class MyPluginsFilter
    extends FilterComponent {
        public MyPluginsFilter() {
            super("PLUGIN_FILTER", 5);
        }

        public void filter() {
            YeomanGeneratorsMain.this.myGeneratorTable.putClientProperty("SEARCH_QUERY", this.getFilter());
            YeomanGeneratorsMain.this.myModel.filter(this.getFilterLowerCase());
            TableUtil.ensureSelectionExists((JTable)((Object)YeomanGeneratorsMain.this.myGeneratorTable));
        }

        public String getFilterLowerCase() {
            return StringUtil.toLowerCase((String)this.getFilter());
        }
    }
}

