/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javascript.debugger.GlobalVariablesHolder;
import com.intellij.javascript.debugger.JavaScriptDebuggerConsoleExecuteActionHandler;
import com.intellij.javascript.debugger.VariablesHolder;
import com.intellij.javascript.debugger.VariablesHolderKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.util.Function;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncValueLoader;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/javascript/debugger/GlobalVariablesHolder;", "Lcom/intellij/javascript/debugger/VariablesHolder;", "viewSupport", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "(Lorg/jetbrains/debugger/DebuggerViewSupport;)V", "variablesLoader", "Lorg/jetbrains/concurrency/AsyncValueLoader;", "", "getVariablesLoader", "()Lorg/jetbrains/concurrency/AsyncValueLoader;", "intellij.javascript.debugger"})
public final class GlobalVariablesHolder
extends VariablesHolder {
    @NotNull
    private final AsyncValueLoader<Boolean> variablesLoader;

    @NotNull
    protected AsyncValueLoader<Boolean> getVariablesLoader() {
        return this.variablesLoader;
    }

    public GlobalVariablesHolder(@NotNull DebuggerViewSupport viewSupport) {
        Intrinsics.checkParameterIsNotNull((Object)viewSupport, (String)"viewSupport");
        super(viewSupport);
        this.variablesLoader = (AsyncValueLoader)new AsyncValueLoader<Boolean>(this, viewSupport){
            final /* synthetic */ GlobalVariablesHolder this$0;
            final /* synthetic */ DebuggerViewSupport $viewSupport;

            protected boolean isCancelOnReject() {
                return true;
            }

            @NotNull
            protected Promise<Boolean> load(@NotNull AsyncPromise<Boolean> promise2) {
                Intrinsics.checkParameterIsNotNull(promise2, (String)"promise");
                Vm vm = this.$viewSupport.getVm();
                if (vm == null) {
                    promise2.setError("vm disconnected");
                    return (Promise)promise2;
                }
                EvaluateContext globalEvaluateContext = vm.getEvaluateContext();
                if (globalEvaluateContext == null) {
                    promise2.setError("vm global evaluate unsupported");
                    return (Promise)promise2;
                }
                String string = JavaScriptDebuggerConsoleExecuteActionHandler.class.getSimpleName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JavaScriptDebuggerConsol\u2026er::class.java.simpleName");
                EvaluateContext evaluateContext = globalEvaluateContext.withValueManager(string);
                Promise promise3 = EvaluateContext.DefaultImpls.evaluate$default((EvaluateContext)evaluateContext, (String)"this", null, (boolean)false, null, (int)14, null).thenAsync((Function)new Function<T, Promise<SUB_RESULT>>(this){
                    final /* synthetic */ variablesLoader.1 this$0;

                    @NotNull
                    public final Promise<Boolean> fun(EvaluateResult it) {
                        Value value = it.getValue();
                        if (!(value instanceof ObjectValue)) {
                            return Promises.resolvedPromise((Object)true);
                        }
                        return ((ObjectValue)value).getProperties().then((Function)new Function<T, SUB_RESULT>(this){
                            final /* synthetic */ variablesLoader.load.1 this$0;

                            public final boolean fun(List<? extends Variable> variables) {
                                if (this.this$0.this$0.$viewSupport.getVm() == null || variables.isEmpty()) {
                                    return true;
                                }
                                ApplicationManager.getApplication().runReadAction((Computable)new Computable<T>(this, variables){
                                    final /* synthetic */ variablesLoader.load.1 this$0;
                                    final /* synthetic */ List $variables$inlined;
                                    {
                                        this.this$0 = var1_1;
                                        this.$variables$inlined = list;
                                    }

                                    public final T compute() {
                                        for (Variable variable : this.$variables$inlined) {
                                            String name = variable.getName();
                                            String psiTypeName = VariablesHolderKt.backendTypeNameToPsiTypeName(variable.getValue());
                                            if (this.this$0.this$0.this$0.this$0.getNameToPsiTypeName().put((Object)name, (Object)psiTypeName) != null) continue;
                                            LookupElementBuilder lookupItem = LookupElementBuilder.create((String)name);
                                            if (variable.getValue() != null) {
                                                Value value;
                                                Value it;
                                                Value value2 = it = value;
                                                Intrinsics.checkExpressionValueIsNotNull((Object)value2, (String)"it");
                                                lookupItem.withIcon(VariableView.Companion.getIcon(value2));
                                            }
                                            LookupElementBuilder lookupElementBuilder = lookupItem;
                                            if (lookupElementBuilder == null) {
                                                throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInsight.lookup.LookupElement");
                                            }
                                            this.this$0.this$0.this$0.this$0.getLookupElements().add((LookupElement)lookupElementBuilder);
                                        }
                                        return (T)Unit.INSTANCE;
                                    }
                                });
                                return true;
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).onProcessed((Consumer)new Consumer<Boolean>(evaluateContext){
                    final /* synthetic */ EvaluateContext $evaluateContext;

                    public final void accept(Boolean it) {
                        this.$evaluateContext.releaseObjects();
                    }
                    {
                        this.$evaluateContext = evaluateContext;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)promise3, (String)"evaluateContext.evaluate\u2026ontext.releaseObjects() }");
                return promise3;
            }
            {
                this.this$0 = $outer;
                this.$viewSupport = $captured_local_variable$1;
            }
        };
    }
}

