/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.JSFileFinderBase;
import com.intellij.javascript.debugger.LocalFileSystemFileFinderKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/javascript/debugger/LocalFileSystemFileFinder;", "Lcom/intellij/javascript/debugger/JSFileFinderBase;", "useFileScheme", "", "(Z)V", "doFindFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "findByName", "sourceContent", "", "script", "Lorg/jetbrains/debugger/Script;", "doFindUrls", "", "file", "intellij.javascript.debugger"})
public class LocalFileSystemFileFinder
extends JSFileFinderBase {
    private final boolean useFileScheme;

    @Override
    @Nullable
    protected VirtualFile doFindFile(@NotNull Url url, @NotNull Project project, boolean findByName2, @Nullable String sourceContent, @Nullable Script script) {
        VirtualFile virtualFile;
        String projectBasePath;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String path = url.getPath();
        if (!FileUtil.isAbsolutePlatformIndependent((String)path)) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null && (projectBasePath = project.getBasePath()) != null && FileUtil.isAncestor((String)projectBasePath, (String)path, (boolean)true)) {
            file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        }
        if ((virtualFile = file) == null) {
            String string = path;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
            virtualFile = LocalFileSystemFileFinderKt.findByRelativePath(string, project);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public List<Url> doFindUrls(@NotNull VirtualFile file) {
        Url url;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (this.useFileScheme) {
            String string = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
            url = (Url)Urls.newUri((String)"file", (String)string);
        } else {
            String string = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
            url = Urls.newLocalFileUrl((String)string);
        }
        return CollectionsKt.listOf((Object)url);
    }

    public LocalFileSystemFileFinder(boolean useFileScheme) {
        this.useFileScheme = useFileScheme;
    }

    public /* synthetic */ LocalFileSystemFileFinder(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public LocalFileSystemFileFinder() {
        this(false, 1, null);
    }
}

