/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.scripts.FileInfo;
import com.intellij.javascript.debugger.scripts.ScriptsKt;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebugSession;
import java.awt.event.InputEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0014\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0006\u0010 \u001a\u00020\u0019J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006$"}, d2={"Lcom/intellij/javascript/debugger/scripts/FileNode;", "Lcom/intellij/ui/treeStructure/CachingSimpleNode;", "_name", "", "fileInfo", "Lcom/intellij/javascript/debugger/scripts/FileInfo;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "parent", "Lcom/intellij/ide/util/treeView/NodeDescriptor;", "", "(Ljava/lang/String;Lcom/intellij/javascript/debugger/scripts/FileInfo;Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lcom/intellij/ide/util/treeView/NodeDescriptor;)V", "getDebugProcess", "()Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "getFileInfo", "()Lcom/intellij/javascript/debugger/scripts/FileInfo;", "buildChildren", "", "Lcom/intellij/ui/treeStructure/SimpleNode;", "()[Lcom/intellij/ui/treeStructure/SimpleNode;", "getEqualityObjects", "()[Ljava/lang/Object;", "getWeight", "", "handleDoubleClickOrEnter", "", "tree", "Lcom/intellij/ui/treeStructure/SimpleTree;", "inputEvent", "Ljava/awt/event/InputEvent;", "isAlwaysLeaf", "", "navigateToSource", "update", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.javascript.debugger"})
public class FileNode
extends CachingSimpleNode {
    private final String _name;
    @NotNull
    private final FileInfo fileInfo;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;

    protected void update(@NotNull PresentationData presentation) {
        List<Script> scripts;
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        presentation.addText(this._name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.fileInfo.isFile() && ((scripts = this.fileInfo.getScripts()).size() > 1 || scripts.get(0).getUrl() != this.fileInfo.getUrl())) {
            presentation.addText(" (", SimpleTextAttributes.GRAY_ATTRIBUTES);
            for (Script script : scripts) {
                presentation.addText(StringUtil.trimMiddle((String)script.getUrl().toDecodedForm(), (int)60), SimpleTextAttributes.GRAY_ATTRIBUTES);
                presentation.addText(script == scripts.get(scripts.size() - 1) ? ")" : ", ", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }
        presentation.setIcon(this.fileInfo.getIcon());
    }

    public boolean isAlwaysLeaf() {
        return this.fileInfo.isFile();
    }

    public int getWeight() {
        return this.fileInfo.getWeight();
    }

    @NotNull
    public Object[] getEqualityObjects() {
        return new Object[]{this.fileInfo.getUrl()};
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected SimpleNode[] buildChildren() {
        List<FileInfo> children2 = this.fileInfo.getChildren$intellij_javascript_debugger();
        if (children2.isEmpty()) {
            SimpleNode[] simpleNodeArray = FileNode.access$getNO_CHILDREN$p$s561710836();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleNodeArray, (String)"SimpleNode.NO_CHILDREN");
            return simpleNodeArray;
        }
        int size$iv = children2.size();
        SimpleNode[] result$iv = new SimpleNode[size$iv];
        int n = 0;
        int n2 = result$iv.length;
        while (n < n2) {
            FileInfo next;
            void it;
            void i$iv;
            void var7_6 = i$iv;
            void var14_11 = i$iv;
            SimpleNode[] simpleNodeArray = result$iv;
            FileInfo child = children2.get((int)it);
            StringBuilder nameBuilder = new StringBuilder();
            nameBuilder.append(child.getName());
            while ((next = child.getSingleChild()) != null && !next.isFile()) {
                nameBuilder.append('/').append(next.getName());
                child = next;
            }
            String string = nameBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"nameBuilder.toString()");
            FileNode r = new FileNode(string, child, this.debugProcess, (NodeDescriptor<Object>)((NodeDescriptor)this));
            nameBuilder.setLength(0);
            FileNode fileNode = r;
            simpleNodeArray[var14_11] = fileNode;
            ++i$iv;
        }
        SimpleNode[] result2 = result$iv;
        return result2;
    }

    public void handleDoubleClickOrEnter(@NotNull SimpleTree tree, @NotNull InputEvent inputEvent) {
        Intrinsics.checkParameterIsNotNull((Object)tree, (String)"tree");
        Intrinsics.checkParameterIsNotNull((Object)inputEvent, (String)"inputEvent");
        if (this.fileInfo.isFile()) {
            this.navigateToSource();
        }
    }

    public final void navigateToSource() {
        block7: {
            Navigatable navigatable;
            block6: {
                Script script = this.fileInfo.getFirstScript();
                Url url = this.fileInfo.getUrl();
                XDebugSession xDebugSession = this.debugProcess.getSession();
                Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
                Project project = xDebugSession.getProject();
                DebuggableFileFinder debuggableFileFinder = this.debugProcess.getFinder();
                Project project2 = project;
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                Navigatable navigatable2 = debuggableFileFinder.findNavigatable(url, project2);
                if (navigatable2 == null) {
                    OpenFileDescriptor openFileDescriptor;
                    VirtualFile it;
                    VirtualFile virtualFile;
                    FileNode fileNode;
                    FileNode $receiver = fileNode = this;
                    VirtualFile file = ScriptsKt.findRemoteFile(script, url);
                    if (file == null && url != script.getUrl()) {
                        SourceMap sourceMap = script.getSourceMap();
                        if (sourceMap != null) {
                            it = virtualFile = sourceMap;
                            int sourceIndex = it.getSourceResolver().getSourceIndex(url);
                            String string = it.getSourceResolver().getSourceContent(sourceIndex);
                            if (string != null) {
                                String string2;
                                String it2 = string2 = string;
                                file = ScriptsKt.createVmFile(url, (UserDataHolder)script, it2, sourceIndex);
                            }
                        }
                    }
                    VirtualFile virtualFile2 = file;
                    if (virtualFile2 != null) {
                        it = virtualFile = virtualFile2;
                        openFileDescriptor = new OpenFileDescriptor(project, it);
                    } else {
                        openFileDescriptor = null;
                    }
                    navigatable2 = navigatable = (Navigatable)openFileDescriptor;
                }
                if (!(navigatable instanceof OpenFileDescriptor)) break block6;
                ((OpenFileDescriptor)navigatable).navigateInEditor(project, true);
                break block7;
            }
            Navigatable navigatable3 = navigatable;
            if (navigatable3 == null) break block7;
            navigatable3.navigate(true);
        }
    }

    @NotNull
    public final FileInfo getFileInfo() {
        return this.fileInfo;
    }

    @NotNull
    protected final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    public FileNode(@NotNull String _name, @NotNull FileInfo fileInfo, @NotNull JavaScriptDebugProcess<?> debugProcess, @Nullable NodeDescriptor<Object> parent) {
        Intrinsics.checkParameterIsNotNull((Object)_name, (String)"_name");
        Intrinsics.checkParameterIsNotNull((Object)fileInfo, (String)"fileInfo");
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        XDebugSession xDebugSession = debugProcess.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
        super(xDebugSession.getProject(), parent);
        this._name = _name;
        this.fileInfo = fileInfo;
        this.debugProcess = debugProcess;
    }

    public static final /* synthetic */ SimpleNode[] access$getNO_CHILDREN$p$s561710836() {
        return SimpleNode.NO_CHILDREN;
    }
}

