/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.annotationprocessor;

import android.databinding.annotationprocessor.ProcessDataBinding;
import android.databinding.tool.CompilerChef;
import android.databinding.tool.DataBindingCompilerArgs;
import android.databinding.tool.LayoutXmlProcessor;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.ScopedException;
import android.databinding.tool.store.GenClassInfoLog;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.util.GenerationalClassUtil;
import android.databinding.tool.util.L;
import android.databinding.tool.util.LoggedErrorException;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.util.StringUtils;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ProcessExpressions
extends ProcessDataBinding.ProcessingStep {
    @Override
    public boolean onHandleStep(RoundEnvironment roundEnvironment, ProcessingEnvironment processingEnvironment, DataBindingCompilerArgs args) throws JAXBException {
        try {
            List<IntermediateV2> intermediateList;
            ResourceBundle resourceBundle = new ResourceBundle(args.getModulePackage());
            if (args.isEnableV2()) {
                Object infoLog;
                try {
                    infoLog = ResourceBundle.loadClassInfoFromFolder(new File(args.getClassLogDir()));
                }
                catch (IOException iOException) {
                    infoLog = new GenClassInfoLog();
                    Scope.defer(new ScopedException("cannot load the info log from %s", args.getClassLogDir()));
                }
                resourceBundle.addDependencyLayouts((GenClassInfoLog)infoLog);
                intermediateList = Collections.emptyList();
            } else {
                intermediateList = this.loadDependencyIntermediates();
                for (Intermediate intermediate : intermediateList) {
                    try {
                        try {
                            intermediate.appendTo(resourceBundle, false);
                        }
                        catch (Throwable throwable) {
                            L.e(throwable, "unable to prepare resource bundle", new Object[0]);
                        }
                    }
                    catch (LoggedErrorException loggedErrorException) {}
                }
            }
            IntermediateV2 mine = this.createIntermediateFromLayouts(args.getXmlOutDir(), intermediateList);
            if (mine != null) {
                if (!args.isEnableV2()) {
                    mine.updateOverridden(resourceBundle);
                    intermediateList.add(mine);
                    this.saveIntermediate(processingEnvironment, args, mine);
                }
                mine.appendTo(resourceBundle, true);
            }
            try {
                this.writeResourceBundle(resourceBundle, args);
            }
            catch (Throwable throwable) {
                L.e(throwable, "cannot generate view binders", new Object[0]);
            }
        }
        catch (LoggedErrorException loggedErrorException) {
            // empty catch block
        }
        return true;
    }

    private List<IntermediateV2> loadDependencyIntermediates() {
        List original = GenerationalClassUtil.get().loadObjects(GenerationalClassUtil.ExtensionFilter.LAYOUT);
        ArrayList<IntermediateV2> upgraded = new ArrayList<IntermediateV2>(original.size());
        for (Intermediate intermediate : original) {
            Intermediate updatedIntermediate = intermediate.upgrade();
            Preconditions.check(updatedIntermediate instanceof IntermediateV2, "Incompatible data binding dependency. Please update your dependencies or recompile them with application module's data binding version.", new Object[0]);
            upgraded.add((IntermediateV2)updatedIntermediate);
        }
        return upgraded;
    }

    private void saveIntermediate(ProcessingEnvironment processingEnvironment, DataBindingCompilerArgs args, IntermediateV2 intermediate) {
        GenerationalClassUtil.get().writeIntermediateFile(args.getModulePackage(), args.getModulePackage() + GenerationalClassUtil.ExtensionFilter.LAYOUT.getExtension(), intermediate);
    }

    @Override
    public void onProcessingOver(RoundEnvironment roundEnvironment, ProcessingEnvironment processingEnvironment, DataBindingCompilerArgs args) {
    }

    private IntermediateV2 createIntermediateFromLayouts(String layoutInfoFolderPath, List<IntermediateV2> intermediateList) {
        final HashSet<String> excludeList = new HashSet<String>();
        for (IntermediateV2 lib : intermediateList) {
            excludeList.addAll(lib.mLayoutInfoMap.keySet());
        }
        File layoutInfoFolder = new File(layoutInfoFolderPath);
        if (!layoutInfoFolder.isDirectory()) {
            L.d("layout info folder does not exist, skipping for %s", layoutInfoFolderPath);
            return null;
        }
        IntermediateV2 result = new IntermediateV2();
        for (File layoutFile : layoutInfoFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml") && !excludeList.contains(name);
            }
        })) {
            try {
                result.addEntry(layoutFile.getName(), FileUtils.readFileToString((File)layoutFile));
            }
            catch (IOException e) {
                L.e(e, "cannot load layout file information. Try a clean build", new Object[0]);
            }
        }
        for (File zipFile : layoutInfoFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".zip");
            }
        })) {
            try {
                this.loadLayoutInfoFromZipFile(zipFile, result, excludeList);
            }
            catch (IOException e) {
                L.e(e, "error while reading layout zip file %s", zipFile);
            }
        }
        return result;
    }

    private void loadLayoutInfoFromZipFile(File zipFile, IntermediateV2 result, Set<String> excludeList) throws IOException {
        ZipFile zf = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (excludeList.contains(entry.getName())) continue;
            try {
                result.addEntry(entry.getName(), IOUtils.toString((InputStream)zf.getInputStream(entry), (Charset)Charsets.UTF_16));
            }
            catch (IOException e) {
                L.e(e, "cannot load layout file information. Try a clean build", new Object[0]);
            }
        }
    }

    private void writeResourceBundle(ResourceBundle resourceBundle, DataBindingCompilerArgs compilerArgs) throws JAXBException {
        CompilerChef compilerChef = CompilerChef.createChef(resourceBundle, this.getWriter(), compilerArgs);
        compilerChef.sealModels();
        if (compilerArgs.isLibrary() || !compilerArgs.isTestVariant()) {
            compilerChef.writeComponent();
        }
        if (compilerChef.hasAnythingToGenerate()) {
            if (!compilerArgs.isEnableV2()) {
                compilerChef.writeViewBinderInterfaces(compilerArgs.isLibrary() && !compilerArgs.isTestVariant());
            }
            if (compilerArgs.isApp() != compilerArgs.isTestVariant() || compilerArgs.isEnabledForTests() && !compilerArgs.isLibrary() || compilerArgs.isEnableV2()) {
                compilerChef.writeViewBinders(compilerArgs.getMinApi());
            }
        }
        if (compilerArgs.isLibrary() && !compilerArgs.isTestVariant() && compilerArgs.getExportClassListTo() == null) {
            L.e("When compiling a library module, build info must include exportClassListTo path", new Object[0]);
        }
        if (compilerArgs.isLibrary() && !compilerArgs.isTestVariant()) {
            Set<String> classNames = compilerChef.getClassesToBeStripped();
            String out = Joiner.on((String)StringUtils.LINE_SEPARATOR).join(classNames);
            L.d("Writing list of classes to %s . \nList:%s", compilerArgs.getExportClassListTo(), out);
            try {
                FileUtils.write((File)new File(compilerArgs.getExportClassListTo()), (CharSequence)out);
            }
            catch (IOException e) {
                L.e(e, "Cannot create list of written classes", new Object[0]);
            }
        }
        this.mCallback.onChefReady(compilerChef);
    }

    public static class IntermediateV2
    extends IntermediateV1 {
        private static final long serialVersionUID = 2L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void appendTo(ResourceBundle resourceBundle, boolean fromSource) throws JAXBException {
            for (Map.Entry entry : this.mLayoutInfoMap.entrySet()) {
                InputStream is = IOUtils.toInputStream((String)((String)entry.getValue()));
                try {
                    ResourceBundle.LayoutFileBundle bundle = ResourceBundle.LayoutFileBundle.fromXML(is);
                    resourceBundle.addLayoutBundle(bundle, fromSource);
                    L.d("loaded layout info file %s", bundle);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
        }

        public void updateOverridden(ResourceBundle bundle) throws JAXBException {
            HashMap<String, List<ResourceBundle.LayoutFileBundle>> bundles = bundle.getLayoutBundles();
            for (Map.Entry info : this.mLayoutInfoMap.entrySet()) {
                String key = LayoutXmlProcessor.exportLayoutNameFromInfoFileName((String)info.getKey());
                List<ResourceBundle.LayoutFileBundle> existingList = bundles.get(key);
                if (existingList == null || existingList.isEmpty()) continue;
                ResourceBundle.LayoutFileBundle myBundle = ResourceBundle.LayoutFileBundle.fromXML(IOUtils.toInputStream((String)((String)info.getValue())));
                ResourceBundle.LayoutFileBundle inheritFrom = existingList.get(0);
                myBundle.inheritConfigurationFrom(inheritFrom);
                L.d("inheriting data for %s (%s) from %s", info.getKey(), key, inheritFrom);
                this.mLayoutInfoMap.put(info.getKey(), myBundle.toXML());
            }
        }
    }

    public static class IntermediateV1
    implements Intermediate {
        transient Unmarshaller mUnmarshaller;
        Map<String, String> mLayoutInfoMap = new HashMap<String, String>();

        @Override
        public Intermediate upgrade() {
            IntermediateV2 updated = new IntermediateV2();
            updated.mLayoutInfoMap = this.mLayoutInfoMap;
            updated.mUnmarshaller = this.mUnmarshaller;
            return updated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void appendTo(ResourceBundle resourceBundle, boolean fromSource) throws JAXBException {
            if (this.mUnmarshaller == null) {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ResourceBundle.LayoutFileBundle.class});
                this.mUnmarshaller = context.createUnmarshaller();
            }
            for (String content : this.mLayoutInfoMap.values()) {
                InputStream is = IOUtils.toInputStream((String)content);
                try {
                    ResourceBundle.LayoutFileBundle bundle = (ResourceBundle.LayoutFileBundle)this.mUnmarshaller.unmarshal(is);
                    resourceBundle.addLayoutBundle(bundle, fromSource);
                    L.d("loaded layout info file %s", bundle);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
        }

        public void addEntry(String name, String contents) {
            this.mLayoutInfoMap.put(name, contents);
        }

        public void removeOverridden(List<Intermediate> existing) {
        }
    }

    public static interface Intermediate
    extends Serializable {
        public Intermediate upgrade();

        public void appendTo(ResourceBundle var1, boolean var2) throws Throwable;
    }
}

