/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection;

import android.databinding.tool.ext.ExtKt;
import android.databinding.tool.reflection.InjectedField;
import android.databinding.tool.reflection.InjectedMethod;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelField;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.reflection.TypeUtil;
import android.databinding.tool.util.StringUtils;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class InjectedClass
extends ModelClass {
    private final String mClassName;
    private final String mSuperClass;
    private final List<InjectedMethod> mMethods = new ArrayList<InjectedMethod>();
    private final List<InjectedField> mFields = new ArrayList<InjectedField>();

    public InjectedClass(String className, String superClass) {
        this.mClassName = className;
        this.mSuperClass = superClass;
    }

    public void addVariable(String name, String type, Map<String, String> imports) {
        String capName = StringUtils.capitalize(name);
        String setName = "set" + capName;
        String getName = "get" + capName;
        this.addMethod(new InjectedMethod(this, false, getName, imports, type, new String[0]));
        this.addMethod(new InjectedMethod(this, false, setName, imports, "void", type));
    }

    public void addField(String name, String type) {
        this.addField(new InjectedField(name, type));
    }

    public void addField(InjectedField field) {
        this.mFields.add(field);
    }

    public void addMethod(InjectedMethod method) {
        this.mMethods.add(method);
    }

    @Override
    public String toJavaCode() {
        return this.mClassName;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public ModelClass getComponentType() {
        return null;
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isChar() {
        return false;
    }

    @Override
    public boolean isByte() {
        return false;
    }

    @Override
    public boolean isShort() {
        return false;
    }

    @Override
    public boolean isInt() {
        return false;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public List<ModelClass> getTypeArguments() {
        return null;
    }

    @Override
    public boolean isTypeVar() {
        return false;
    }

    @Override
    public boolean isWildcard() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isVoid() {
        return false;
    }

    @Override
    public ModelClass unbox() {
        return this;
    }

    @Override
    public ModelClass box() {
        return this;
    }

    @Override
    public boolean isObservable() {
        return this.getSuperclass().isObservable();
    }

    @Override
    public boolean isAssignableFrom(ModelClass that) {
        ModelClass superClass = that;
        while (superClass != null && !superClass.isObject()) {
            if (!superClass.toJavaCode().equals(this.mClassName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ModelClass getSuperclass() {
        return ModelAnalyzer.getInstance().findClass(this.mSuperClass, null);
    }

    @Override
    public ModelClass erasure() {
        return this;
    }

    @Override
    public String getJniDescription() {
        return TypeUtil.getInstance().getDescription(this);
    }

    @Override
    protected ModelField[] getDeclaredFields() {
        ModelClass superClass = this.getSuperclass();
        ModelField[] superFields = superClass.getDeclaredFields();
        int initialCount = superFields.length;
        int fieldCount = initialCount + this.mFields.size();
        ModelField[] fields = Arrays.copyOf(superFields, fieldCount);
        for (int i = 0; i < this.mFields.size(); ++i) {
            fields[i + initialCount] = this.mFields.get(i);
        }
        return fields;
    }

    @Override
    protected ModelMethod[] getDeclaredMethods() {
        ModelClass superClass = this.getSuperclass();
        ModelMethod[] superMethods = superClass.getDeclaredMethods();
        int initialCount = superMethods.length;
        int methodCount = initialCount + this.mMethods.size();
        ModelMethod[] methods = Arrays.copyOf(superMethods, methodCount);
        for (int i = 0; i < this.mMethods.size(); ++i) {
            methods[i + initialCount] = this.mMethods.get(i);
        }
        return methods;
    }

    @Override
    public TypeName getTypeName() {
        return ExtKt.toTypeName(this.mClassName);
    }

    public String toString() {
        return "Injected Class: " + this.mClassName;
    }
}

