/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptStepDefinitionCreator;

public class CucumberJavaScript2StepDefinitionCreator
extends CucumberJavaScriptStepDefinitionCreator {
    private static final List<String> STEP_KEYWORDS = Arrays.asList("And", "But", "Given", "Then", "When");

    @Override
    @NotNull
    protected String getStepDefinitionTemplate() {
        if ("%s(/^%s$/, function (%scallback) {\n  callback.pending();\n});" == null) {
            CucumberJavaScript2StepDefinitionCreator.$$$reportNull$$$0(0);
        }
        return "%s(/^%s$/, function (%scallback) {\n  callback.pending();\n});";
    }

    @Override
    @NotNull
    protected JSBlockStatement createStepDefsWrapper(@NotNull PsiFile file) {
        if (file == null) {
            CucumberJavaScript2StepDefinitionCreator.$$$reportNull$$$0(1);
        }
        String text = "var {defineSupportCode} = require('cucumber');\ndefineSupportCode(function({And, But, Given, Then, When}) {\n});";
        ASTNode firstNode = JSChangeUtil.createStatementFromText((Project)file.getProject(), (String)"var {defineSupportCode} = require('cucumber');\ndefineSupportCode(function({And, But, Given, Then, When}) {\n});", (JSLanguageDialect)DialectDetector.languageDialectOfElement((PsiElement)file));
        assert (firstNode != null);
        PsiElement element = firstNode.getPsi();
        PsiElement defineSupportCodeCall = element.getContainingFile().getLastChild();
        file.add(firstNode.getPsi());
        defineSupportCodeCall = file.add(defineSupportCodeCall);
        JSChangeUtil.addWs((ASTNode)file.getNode(), (ASTNode)defineSupportCodeCall.getNode(), (String)"\n\n");
        JSBlockStatement jSBlockStatement = (JSBlockStatement)PsiTreeUtil.findChildOfType((PsiElement)defineSupportCodeCall, JSBlockStatement.class);
        if (jSBlockStatement == null) {
            CucumberJavaScript2StepDefinitionCreator.$$$reportNull$$$0(2);
        }
        return jSBlockStatement;
    }

    @Override
    @Nullable
    protected JSBlockStatement findWrapper(JSFile jsFile) {
        Collection calls = PsiTreeUtil.findChildrenOfType((PsiElement)jsFile, JSCallExpression.class);
        for (JSCallExpression call : calls) {
            if (!STEP_KEYWORDS.contains(call.getMethodExpression().getText())) continue;
            return (JSBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)call, JSBlockStatement.class);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScript2StepDefinitionCreator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepDefinitionTemplate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScript2StepDefinitionCreator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepDefsWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefsWrapper";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

