/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript;

import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.StepDefinitionCreator;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptStepDefinitionCreator;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptUtil;
import org.jetbrains.plugins.cucumber.javascript.JavaScriptStepDefinition;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.PlainGherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.NotIndexedCucumberExtension;

public class CucumberJavaScriptExtension
extends NotIndexedCucumberExtension {
    protected void loadStepDefinitionRootsFromLibraries(Module module, List<PsiDirectory> roots, Set<String> directories) {
    }

    protected Collection<AbstractStepDefinition> getStepDefinitions(@NotNull PsiFile file) {
        if (file == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(0);
        }
        PlainGherkinKeywordProvider keywordProvider = new PlainGherkinKeywordProvider();
        final Collection stepKeywords = keywordProvider.getKeywordsTable("en").getStepKeywords();
        final ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        file.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

            public void visitJSCallExpression(JSCallExpression node) {
                JSExpression argument;
                String calledMethodName = node.getMethodExpression().getText();
                if (stepKeywords.contains(calledMethodName = StringUtil.trimStart((String)calledMethodName, (String)"this.")) && node.getArguments().length >= 2 && ((argument = node.getArguments()[0]) instanceof JSLiteralExpression && ((JSLiteralExpression)argument).isRegExpLiteral() || argument instanceof JSStringTemplateExpression)) {
                    result.add(new JavaScriptStepDefinition((PsiElement)argument));
                    return;
                }
                super.visitJSCallExpression(node);
            }
        });
        return result;
    }

    protected void collectAllStepDefsProviders(@NotNull List<VirtualFile> providers, @NotNull Project project) {
        if (providers == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(1);
        }
        if (project == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(2);
        }
    }

    public void findRelatedStepDefsRoots(@NotNull Module module, @NotNull PsiFile featureFile, @NotNull List<PsiDirectory> newStepDefinitionsRoots, @NotNull Set<String> processedStepDirectories) {
        VirtualFile file;
        if (module == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(3);
        }
        if (featureFile == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(4);
        }
        if (newStepDefinitionsRoots == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(5);
        }
        if (processedStepDirectories == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(6);
        }
        if ((file = featureFile.getVirtualFile()) == null) {
            return;
        }
        VirtualFile contentRoot = CucumberJavaScriptExtension.findContentRoot((Module)module, (VirtualFile)file);
        if (contentRoot == null) {
            return;
        }
        ProjectRootManager.getInstance((Project)featureFile.getProject()).getFileIndex().iterateContentUnderDirectory(contentRoot, stepDefsRoot -> {
            if (newStepDefinitionsRoots == null) {
                CucumberJavaScriptExtension.$$$reportNull$$$0(15);
            }
            if (processedStepDirectories == null) {
                CucumberJavaScriptExtension.$$$reportNull$$$0(16);
            }
            if (module == null) {
                CucumberJavaScriptExtension.$$$reportNull$$$0(17);
            }
            if (CucumberJavaScriptUtil.isStepDefinitionsRoot(stepDefsRoot)) {
                CucumberJavaScriptExtension.addStepDefsRootIfNecessary((VirtualFile)stepDefsRoot, (List)newStepDefinitionsRoots, (Set)processedStepDirectories, (Project)module.getProject());
            }
            return true;
        });
    }

    public boolean isStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        if (child == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(7);
        }
        if (parent == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(8);
        }
        return parent instanceof PsiDirectory && child instanceof JSFileImpl && !CucumberJavaScriptUtil.isV2StepDefinitionFile((JSFile)child);
    }

    public boolean isWritableStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        if (child == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(9);
        }
        if (parent == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(10);
        }
        return this.isStepLikeFile(child, parent);
    }

    @NotNull
    public BDDFrameworkType getStepFileType() {
        BDDFrameworkType bDDFrameworkType = new BDDFrameworkType((FileType)JavaScriptFileType.INSTANCE, "Cucumber 1.x");
        if (bDDFrameworkType == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(11);
        }
        return bDDFrameworkType;
    }

    @NotNull
    public StepDefinitionCreator getStepDefinitionCreator() {
        CucumberJavaScriptStepDefinitionCreator cucumberJavaScriptStepDefinitionCreator = new CucumberJavaScriptStepDefinitionCreator();
        if (cucumberJavaScriptStepDefinitionCreator == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(12);
        }
        return cucumberJavaScriptStepDefinitionCreator;
    }

    @NotNull
    public Collection<String> getGlues(@NotNull GherkinFile file, Set<String> gluesFromOtherFiles) {
        if (file == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(13);
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            CucumberJavaScriptExtension.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureFile";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStepDefinitionsRoots";
                break;
            }
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedStepDirectories";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptExtension";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepFileType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepDefinitionCreator";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStepDefinitions";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectAllStepDefsProviders";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findRelatedStepDefsRoots";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isStepLikeFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isWritableStepLikeFile";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getGlues";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findRelatedStepDefsRoots$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

