/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.javascript.run.CucumberJavaScriptRunningState;
import org.jetbrains.plugins.cucumber.javascript.run.ui.CucumberJavaScriptConfigurationEditorForm;

public class CucumberJavaScriptRunConfiguration
extends LocatableConfigurationBase
implements NodeDebugRunConfiguration {
    public String myFilePath = null;
    public String myNameFilter = null;
    public String cucumberJsArguments = "";
    private NodeJsInterpreterRef myInterpreterRef = NodeJsInterpreterRef.createProjectRef();

    protected CucumberJavaScriptRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            CucumberJavaScriptRunConfiguration.$$$reportNull$$$0(0);
        }
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            CucumberJavaScriptRunConfiguration.$$$reportNull$$$0(1);
        }
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        CucumberJavaScriptConfigurationEditorForm cucumberJavaScriptConfigurationEditorForm = new CucumberJavaScriptConfigurationEditorForm(this.getProject());
        if (cucumberJavaScriptConfigurationEditorForm == null) {
            CucumberJavaScriptRunConfiguration.$$$reportNull$$$0(2);
        }
        return cucumberJavaScriptConfigurationEditorForm;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            CucumberJavaScriptRunConfiguration.$$$reportNull$$$0(3);
        }
        if (env == null) {
            CucumberJavaScriptRunConfiguration.$$$reportNull$$$0(4);
        }
        Project project = env.getProject();
        String path = this.getFilePath();
        if (path == null || VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path)) == null) {
            throw new ExecutionException("Can't find file: " + path);
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path));
        assert (virtualFile != null);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module == null) {
            throw new ExecutionException("Can't find module for file");
        }
        return new CucumberJavaScriptRunningState(env, this);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.myFilePath == null || VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)this.myFilePath)) == null) {
            throw new RuntimeConfigurationException("Can't find file: " + this.myFilePath);
        }
    }

    public String getFilePath() {
        return this.myFilePath;
    }

    public void setFilePath(String filePath) {
        this.myFilePath = PathUtil.toSystemIndependentName((String)filePath);
    }

    public String getNameFilter() {
        return this.myNameFilter;
    }

    public void setNameFilter(String nameFilter) {
        this.myNameFilter = nameFilter;
    }

    public String getCucumberJsArguments() {
        return this.cucumberJsArguments;
    }

    public void setCucumberJsArguments(String cucumberJsArguments) {
        this.cucumberJsArguments = cucumberJsArguments;
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            CucumberJavaScriptRunConfiguration.$$$reportNull$$$0(5);
        }
        return nodeJsInterpreterRef;
    }

    public void setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
        if (interpreterRef == null) {
            CucumberJavaScriptRunConfiguration.$$$reportNull$$$0(6);
        }
        this.myInterpreterRef = interpreterRef;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/javascript/run/CucumberJavaScriptRunConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/javascript/run/CucumberJavaScriptRunConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreterRef";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

