/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptUtil;
import org.jetbrains.plugins.cucumber.javascript.run.CucumberJavaScriptRunConfiguration;
import org.jetbrains.plugins.cucumber.javascript.run.CucumberPackage;

public class CucumberJavaScriptRunningState
implements RunProfileState,
NodeLocalDebugRunProfileState {
    private final CucumberJavaScriptRunConfiguration myRunConfiguration;
    private final ExecutionEnvironment myExecutionEnvironment;

    public CucumberJavaScriptRunningState(ExecutionEnvironment env, CucumberJavaScriptRunConfiguration runConfiguration) {
        this.myExecutionEnvironment = env;
        this.myRunConfiguration = runConfiguration;
    }

    private GeneralCommandLine getCommand(int debugPort) throws ExecutionException {
        String workingDirectory;
        GeneralCommandLine commandLine = new GeneralCommandLine();
        if (this.myRunConfiguration.getFilePath() == null) {
            throw new ExecutionException("Can't find feature to run");
        }
        NodeJsLocalInterpreter interpreter = this.myRunConfiguration.getInterpreterRef().resolveAsLocal(this.myRunConfiguration.getProject());
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        NodeCommandLineUtil.addNodeOptionsForDebugging((GeneralCommandLine)commandLine, Collections.emptyList(), (int)debugPort, (boolean)true, (NodeJsInterpreter)interpreter, (boolean)true);
        NodePackage cucumberNodePackage = CucumberJavaScriptUtil.getCucumberPackage(this.myRunConfiguration.getProject(), (NodeJsInterpreter)interpreter);
        String cucumberExecutablePath = FileUtil.toSystemDependentName((String)(cucumberNodePackage.getSystemDependentPath() + "/bin/cucumber"));
        commandLine.addParameter(cucumberExecutablePath);
        VirtualFile fileToRun = CucumberJavaScriptRunningState.virtualFileFromPath(this.myRunConfiguration.getFilePath());
        String string = workingDirectory = fileToRun != null ? fileToRun.getParent().getPath() : null;
        if (fileToRun != null) {
            if (fileToRun.getExtension() != null && fileToRun.getExtension().equals("feature")) {
                commandLine.addParameter(FileUtil.toSystemDependentName((String)fileToRun.getPath()));
            }
            if (!fileToRun.isDirectory()) {
                fileToRun = fileToRun.getParent();
            }
        } else {
            throw new ExecutionException("Can't find feature to run");
        }
        commandLine.withWorkDirectory(workingDirectory);
        if (StringUtil.isNotEmpty((String)this.myRunConfiguration.getNameFilter())) {
            commandLine.addParameter("--name");
            commandLine.addParameter(this.myRunConfiguration.getNameFilter());
        }
        if (this.myRunConfiguration.getCucumberJsArguments().length() > 0) {
            commandLine.addParameters(this.myRunConfiguration.getCucumberJsArguments().split(" "));
        }
        CucumberPackage cucumberPackage = CucumberPackage.fromNodePackage(cucumberNodePackage);
        if (cucumberPackage.version != null && cucumberPackage.version.isGreaterOrEqualThan(2, 0, 0)) {
            commandLine.addParameter("--format");
            String formatterPath = CucumberJavaScriptUtil.getV2FormatterPath();
            String path = FileUtil.getRelativePath((String)workingDirectory, (String)formatterPath, (char)'/');
            if (path == null) {
                String message = String.format("Could not get relative path to formatter [%s] from [%s]", formatterPath, workingDirectory);
                throw new ExecutionException(message);
            }
            commandLine.addParameter(FileUtil.toSystemDependentName((String)path));
            commandLine.addParameter("--format-options");
            commandLine.addParameter(String.format("{\"cucumberLibPath\": \"%s\"}", cucumberPackage.libPath));
        } else {
            commandLine.addParameter("--format");
            commandLine.addParameter("summary");
            commandLine.addParameter("--require");
            commandLine.addParameter(CucumberJavaScriptUtil.getFormatterPath());
        }
        commandLine.addParameter("--require");
        commandLine.addParameter(fileToRun.getPath());
        return commandLine;
    }

    @Nullable
    private static VirtualFile virtualFileFromPath(@NotNull String path) {
        if (path == null) {
            CucumberJavaScriptRunningState.$$$reportNull$$$0(0);
        }
        return VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path));
    }

    private ConsoleView createSMTRunnerConsoleView() {
        SMTRunnerConsoleProperties testConsoleProperties = new SMTRunnerConsoleProperties((RunConfiguration)this.myRunConfiguration, "cucumber", this.myExecutionEnvironment.getExecutor());
        BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createConsole((String)"cucumber", (TestConsoleProperties)testConsoleProperties);
        consoleView.addMessageFilter((Filter)new UrlFilter());
        Disposer.register((Disposable)this.myRunConfiguration.getProject(), (Disposable)consoleView);
        return consoleView;
    }

    @NotNull
    public ExecutionResult execute(int debugPort) throws ExecutionException {
        GeneralCommandLine commandLine = this.getCommand(debugPort);
        OSProcessHandler processHandler = NodeCommandLineUtil.createProcessHandler((GeneralCommandLine)commandLine, (boolean)false);
        ConsoleView consoleView = this.createSMTRunnerConsoleView();
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        consoleView.attachToProcess((ProcessHandler)processHandler);
        DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)processHandler);
        if (defaultExecutionResult == null) {
            CucumberJavaScriptRunningState.$$$reportNull$$$0(1);
        }
        return defaultExecutionResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/javascript/run/CucumberJavaScriptRunningState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/javascript/run/CucumberJavaScriptRunningState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "virtualFileFromPath";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

