/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript.run;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SemVer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CucumberPackage {
    @NotNull
    public final String cliPath;
    @Nullable
    public final String libPath;
    @Nullable
    public final SemVer version;

    public CucumberPackage(@NotNull String cliPath, @Nullable String libPath, @Nullable SemVer version) {
        if (cliPath == null) {
            CucumberPackage.$$$reportNull$$$0(0);
        }
        this.cliPath = cliPath;
        this.libPath = libPath;
        this.version = version;
    }

    @NotNull
    public static CucumberPackage fromNodePackage(@NotNull NodePackage pkg) throws ExecutionException {
        VirtualFile cli;
        String path;
        if (pkg == null) {
            CucumberPackage.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((String)(path = pkg.getSystemIndependentPath()))) {
            throw new ExecutionException("Please specify non-empty path to Cucumber package");
        }
        VirtualFile packageDir = LocalFileSystem.getInstance().findFileByPath(path);
        if (packageDir == null || !packageDir.isValid() || !packageDir.isDirectory()) {
            throw new ExecutionException("Please specify valid path to Cucumber package");
        }
        VirtualFile packageJson = packageDir.findChild("package.json");
        if (packageJson == null || !packageJson.isValid() || packageJson.isDirectory()) {
            throw new ExecutionException("Please specify Cucumber package correctly: \".../package.json\" file not found");
        }
        PackageJsonData packageJsonData = PackageJsonUtil.getOrCreateData((VirtualFile)packageJson);
        SemVer version = packageJsonData.getVersion();
        String binPath = packageJsonData.getBinPath();
        VirtualFile virtualFile = cli = binPath != null ? packageDir.findFileByRelativePath(binPath) : null;
        if (cli == null || !cli.isValid() || cli.isDirectory()) {
            throw new ExecutionException("Please specify Cucumber package correctly: \".../" + binPath + "\" file not found");
        }
        VirtualFile lib = packageDir.findFileByRelativePath("lib");
        CucumberPackage cucumberPackage = new CucumberPackage(cli.getPath(), lib != null ? lib.getPath() : null, version);
        if (cucumberPackage == null) {
            CucumberPackage.$$$reportNull$$$0(2);
        }
        return cucumberPackage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cliPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/javascript/run/CucumberPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/javascript/run/CucumberPackage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fromNodePackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fromNodePackage";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

