/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.android;

import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.impl.invalid.InvalidFacetManager;
import com.intellij.facet.impl.invalid.InvalidFacetManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.VetoableProjectManagerListener;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Consumer;
import com.jetbrains.rdclient.util.idea.LifetimedApplicationComponent;
import com.jetbrains.rider.android.RiderAndroidFacetsManager;
import com.jetbrains.rider.android.RiderAndroidSdksManager;
import com.jetbrains.rider.android.XamarinAndroidModuleUtilKt;
import com.jetbrains.rider.android.XamarinAndroidRunnableProjectsUtilKt;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.model.RunnableProjectKind;
import com.jetbrains.rider.model.RunnableProjectsModel_GeneratedKt;
import com.jetbrains.rider.model.Solution;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.run.configurations.project.RunnableProjectExKt;
import com.jetbrains.rider.run.xamarin.android.AndroidCustomProjectManager;
import com.jetbrains.rider.util.idea.ApplicationKt;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.reactive.ISource;
import com.jetbrains.rider.util.reactive.SourceExKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0002J&\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rJ\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/android/RiderAndroidFacetsManager;", "Lcom/jetbrains/rdclient/util/idea/LifetimedApplicationComponent;", "riderAndroidSdksManager", "Lcom/jetbrains/rider/android/RiderAndroidSdksManager;", "(Lcom/jetbrains/rider/android/RiderAndroidSdksManager;)V", "projectManager", "Lcom/intellij/openapi/project/ProjectManager;", "kotlin.jvm.PlatformType", "addFacetToIgnoredFacets", "", "project", "Lcom/intellij/openapi/project/Project;", "moduleName", "", "facetName", "cleanUpMainModuleAndroidData", "createXamarinAndroidFacetConfiguration", "Lorg/jetbrains/android/facet/AndroidFacetConfiguration;", "androidFacetType", "Lorg/jetbrains/android/facet/AndroidFacetType;", "androidManifestRelativePath", "androidResourcesRelativePath", "androidAssetsRelativePath", "trySetAndroidFacetForModule", "module", "Lcom/intellij/openapi/module/Module;", "verifyHasDummyAndroidFacet", "verifyMainModuleDontHaveSdkReferences", "Companion", "rider-android"})
public final class RiderAndroidFacetsManager
extends LifetimedApplicationComponent {
    private final ProjectManager projectManager;
    private final RiderAndroidSdksManager riderAndroidSdksManager;
    private static final Logger logger;
    @NotNull
    private static final Key<Integer> apiLevelKey;
    private static final String androidManifestDefaultRelativePath = "Properties/AndroidManifest.xml";
    private static final String androidResourcesDefaultRelativePath = "Resources";
    private static final String androidAssetsDefaultRelativePath = "Assets";
    private static final String defaultAndroidFacetName = "Default Android Facet";
    public static final Companion Companion;

    private final void verifyMainModuleDontHaveSdkReferences(Project project) {
        Module module = XamarinAndroidModuleUtilKt.getMainModule(project);
        if (module == null) {
            return;
        }
        Module mainModule = module;
        ModuleRootModificationUtil.updateModel((Module)mainModule, (Consumer)verifyMainModuleDontHaveSdkReferences.1.INSTANCE);
    }

    private final void cleanUpMainModuleAndroidData(Project project) {
        Module module = XamarinAndroidModuleUtilKt.getMainModule(project);
        if (module == null) {
            return;
        }
        Module mainModule = module;
        AndroidFacetType androidFacetType = (AndroidFacetType)AndroidFacetType.findInstance(AndroidFacetType.class);
        FacetManager facetManager = FacetManager.getInstance((Module)mainModule);
        ModifiableFacetModel modifiableModel = facetManager.createModifiableModel();
        ApplicationKt.getApplication().runWriteAction(new Runnable(facetManager, androidFacetType, modifiableModel){
            final /* synthetic */ FacetManager $facetManager;
            final /* synthetic */ AndroidFacetType $androidFacetType;
            final /* synthetic */ ModifiableFacetModel $modifiableModel;

            public final void run() {
                AndroidFacetType androidFacetType = this.$androidFacetType;
                Intrinsics.checkExpressionValueIsNotNull((Object)androidFacetType, (String)"androidFacetType");
                Collection collection = this.$facetManager.getFacetsByType(androidFacetType.getId());
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"facetManager.getFacetsByType(androidFacetType.id)");
                Iterable $receiver$iv = collection;
                for (T element$iv : $receiver$iv) {
                    AndroidFacet it = (AndroidFacet)element$iv;
                    this.$modifiableModel.removeFacet((Facet)it);
                }
                this.$modifiableModel.commit();
            }
            {
                this.$facetManager = facetManager;
                this.$androidFacetType = androidFacetType;
                this.$modifiableModel = modifiableFacetModel;
            }
        });
    }

    private final void verifyHasDummyAndroidFacet(Project project) {
        Module module = XamarinAndroidModuleUtilKt.getMainModule(project);
        if (module == null) {
            return;
        }
        Module mainModule = module;
        AndroidFacetType androidFacetType = (AndroidFacetType)FacetType.findInstance(AndroidFacetType.class);
        FacetManager facetManager = FacetManager.getInstance((Module)mainModule);
        AndroidFacetType androidFacetType2 = androidFacetType;
        Intrinsics.checkExpressionValueIsNotNull((Object)androidFacetType2, (String)"androidFacetType");
        if (facetManager.findFacet(androidFacetType2.getId(), defaultAndroidFacetName) != null) {
            return;
        }
        ApplicationKt.getApplication().runWriteAction(new Runnable(this, facetManager, project, mainModule){
            final /* synthetic */ RiderAndroidFacetsManager this$0;
            final /* synthetic */ FacetManager $facetManager;
            final /* synthetic */ Project $project;
            final /* synthetic */ Module $mainModule;

            public final void run() {
                ModifiableFacetModel modifiableModel = this.$facetManager.createModifiableModel();
                AndroidFacet facet = (AndroidFacet)this.$facetManager.createFacet(FacetType.findInstance(AndroidFacetType.class), "Default Android Facet", null);
                modifiableModel.addFacet((Facet)facet);
                modifiableModel.commit();
                String string = this.$mainModule.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mainModule.name");
                RiderAndroidFacetsManager.access$addFacetToIgnoredFacets(this.this$0, this.$project, string, "Default Android Facet");
            }
            {
                this.this$0 = riderAndroidFacetsManager;
                this.$facetManager = facetManager;
                this.$project = project;
                this.$mainModule = module;
            }
        });
    }

    public final void trySetAndroidFacetForModule(@NotNull Module module, @NotNull String androidManifestRelativePath, @NotNull String androidResourcesRelativePath, @NotNull String androidAssetsRelativePath) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)androidManifestRelativePath, (String)"androidManifestRelativePath");
        Intrinsics.checkParameterIsNotNull((Object)androidResourcesRelativePath, (String)"androidResourcesRelativePath");
        Intrinsics.checkParameterIsNotNull((Object)androidAssetsRelativePath, (String)"androidAssetsRelativePath");
        logger.info("Trying to set android facet for module '" + module.getName());
        AndroidFacetType androidFacetType = (AndroidFacetType)FacetType.findInstance(AndroidFacetType.class);
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        AndroidFacetType androidFacetType2 = androidFacetType;
        Intrinsics.checkExpressionValueIsNotNull((Object)androidFacetType2, (String)"androidFacetType");
        if (facetManager.getFacetByType(androidFacetType2.getId()) == null) {
            logger.info("Creating android facet for module '" + module.getName() + "', manifest path: '" + androidAssetsRelativePath + "'," + "resources path: '" + androidResourcesRelativePath + "', assets path: '" + androidAssetsRelativePath + '\'');
            AndroidFacetConfiguration configuration = this.createXamarinAndroidFacetConfiguration(androidFacetType, androidManifestRelativePath, androidResourcesRelativePath, androidAssetsRelativePath);
            ApplicationKt.getApplication().runWriteAction(new Runnable(this, facetManager, module, androidFacetType, configuration){
                final /* synthetic */ RiderAndroidFacetsManager this$0;
                final /* synthetic */ FacetManager $facetManager;
                final /* synthetic */ Module $module;
                final /* synthetic */ AndroidFacetType $androidFacetType;
                final /* synthetic */ AndroidFacetConfiguration $configuration;

                public final void run() {
                    ModifiableFacetModel modifiableModel = this.$facetManager.createModifiableModel();
                    String facetName = "Android Facet - " + this.$module.getName();
                    AndroidFacet facet = (AndroidFacet)this.$facetManager.createFacet((FacetType)this.$androidFacetType, facetName, (FacetConfiguration)this.$configuration, null);
                    modifiableModel.addFacet((Facet)facet);
                    modifiableModel.commit();
                    Project project = this.$module.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
                    String string = this.$module.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"module.name");
                    RiderAndroidFacetsManager.access$addFacetToIgnoredFacets(this.this$0, project, string, facetName);
                }
                {
                    this.this$0 = riderAndroidFacetsManager;
                    this.$facetManager = facetManager;
                    this.$module = module;
                    this.$androidFacetType = androidFacetType;
                    this.$configuration = androidFacetConfiguration;
                }
            });
        } else {
            logger.info("Found existing android facet, ignore creation of new");
        }
    }

    private final AndroidFacetConfiguration createXamarinAndroidFacetConfiguration(AndroidFacetType androidFacetType, String androidManifestRelativePath, String androidResourcesRelativePath, String androidAssetsRelativePath) {
        AndroidFacetConfiguration configuration;
        AndroidFacetConfiguration androidFacetConfiguration = configuration = androidFacetType.createDefaultConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)androidFacetConfiguration, (String)"configuration");
        JpsAndroidModuleProperties jpsAndroidModuleProperties = androidFacetConfiguration.getState();
        if (jpsAndroidModuleProperties != null) {
            jpsAndroidModuleProperties.MANIFEST_FILE_RELATIVE_PATH = '/' + StringsKt.trimStart((String)androidManifestRelativePath, (char[])new char[]{'/'});
            jpsAndroidModuleProperties.RES_FOLDER_RELATIVE_PATH = '/' + StringsKt.trimStart((String)androidResourcesRelativePath, (char[])new char[]{'/'});
            jpsAndroidModuleProperties.ASSETS_FOLDER_RELATIVE_PATH = '/' + StringsKt.trimStart((String)androidAssetsRelativePath, (char[])new char[]{'/'});
        }
        return configuration;
    }

    private final void addFacetToIgnoredFacets(Project project, String moduleName, String facetName) {
        block1: {
            Object object;
            InvalidFacetManager invalidFacetManager = InvalidFacetManager.getInstance((Project)project);
            if (!(invalidFacetManager instanceof InvalidFacetManagerImpl)) {
                invalidFacetManager = null;
            }
            if ((object = (InvalidFacetManagerImpl)invalidFacetManager) == null || (object = object.getState()) == null || (object = object.getIgnoredFacets()) == null) break block1;
            object.add(moduleName + "/invalid/" + facetName);
        }
    }

    public RiderAndroidFacetsManager(@NotNull RiderAndroidSdksManager riderAndroidSdksManager) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)riderAndroidSdksManager), (String)"riderAndroidSdksManager");
        this.riderAndroidSdksManager = riderAndroidSdksManager;
        this.projectManager = ProjectManager.getInstance();
        this.projectManager.addProjectManagerListener(new VetoableProjectManagerListener(){

            public boolean canClose(@NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                return true;
            }

            public void projectOpened(@NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                SourceExKt.adviseNotNull((ISource)((ISource)RunnableProjectsModel_GeneratedKt.getRunnableProjectsModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getProjects()), (Lifetime)ApplicationKt.getLifetime((UserDataHolder)((UserDataHolder)project)), (Function1)((Function1)new Function1<List<? extends RunnableProject>, Unit>(this, project){
                    final /* synthetic */ 1 this$0;
                    final /* synthetic */ Project $project;

                    public final void invoke(@NotNull List<RunnableProject> projectModels) {
                        ModuleManager moduleManager;
                        Object element$iv$iv;
                        Iterator<E> $receiver$iv$iv;
                        Iterable $receiver$iv;
                        Intrinsics.checkParameterIsNotNull(projectModels, (String)"projectModels");
                        Iterable iterable = $receiver$iv = (Iterable)projectModels;
                        Collection destination$iv$iv = new ArrayList<E>();
                        Module[] moduleArray = $receiver$iv$iv.iterator();
                        while (moduleArray.hasNext()) {
                            element$iv$iv = moduleArray.next();
                            RunnableProject it = (RunnableProject)element$iv$iv;
                            if (!(it.getKind() == RunnableProjectKind.XamarinAndroid)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List xamarinProjects = (List)destination$iv$iv;
                        RiderAndroidFacetsManager.access$getLogger$cp().info("Received " + xamarinProjects.size() + " xamarin.android projects from backend");
                        for (RunnableProject xamarinProject : xamarinProjects) {
                            try {
                                String string;
                                String androidResourcesRelativePath;
                                String string2;
                                String androidManifestRelativePath;
                                RiderAndroidFacetsManager.access$getLogger$cp().info("Processing " + xamarinProject + "...");
                                Module module = XamarinAndroidModuleUtilKt.getOrCreateModule(XamarinAndroidRunnableProjectsUtilKt.getModuleName(xamarinProject), xamarinProject.getProjectFilePath(), this.$project);
                                int preferredApiLevel = RunnableProjectExKt.getCustomAttribute((RunnableProject)xamarinProject, (com.jetbrains.rider.model.Key)com.jetbrains.rider.model.Key.AndroidTargetApiLevel) != null ? Integer.parseInt(element$iv$iv) : Integer.MAX_VALUE;
                                RiderAndroidFacetsManager.access$getRiderAndroidSdksManager$p(this.this$0.this).trySetSdkForModule$rider_android(module, preferredApiLevel);
                                module.putUserData(RiderAndroidFacetsManager.Companion.getApiLevelKey(), (Object)preferredApiLevel);
                                String string3 = RunnableProjectExKt.getCustomAttribute((RunnableProject)xamarinProject, (com.jetbrains.rider.model.Key)com.jetbrains.rider.model.Key.AndroidManifestRelativePath);
                                if (string3 == null) {
                                    string3 = androidManifestRelativePath = "Properties/AndroidManifest.xml";
                                }
                                if ((string2 = RunnableProjectExKt.getCustomAttribute((RunnableProject)xamarinProject, (com.jetbrains.rider.model.Key)com.jetbrains.rider.model.Key.AndroidResourcesRelativePath)) == null) {
                                    string2 = androidResourcesRelativePath = "Resources";
                                }
                                if ((string = RunnableProjectExKt.getCustomAttribute((RunnableProject)xamarinProject, (com.jetbrains.rider.model.Key)com.jetbrains.rider.model.Key.AndroidAssetsRelativePath)) == null) {
                                    string = "Assets";
                                }
                                String androidAssetsRelativePath = string;
                                this.this$0.this.trySetAndroidFacetForModule(module, androidManifestRelativePath, androidResourcesRelativePath, androidAssetsRelativePath);
                            }
                            catch (Exception e) {
                                RiderAndroidFacetsManager.access$getLogger$cp().error("Failed to initialize Android module", (Throwable)e);
                            }
                        }
                        ModuleManager moduleManager2 = moduleManager = ModuleManager.getInstance((Project)this.$project);
                        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager2, (String)"moduleManager");
                        moduleArray = moduleManager2.getModules();
                        int n = moduleArray.length;
                        for (int i = 0; i < n; ++i) {
                            boolean bl;
                            Module module;
                            block13: {
                                Module module2 = module = moduleArray[i];
                                Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
                                if (Intrinsics.areEqual((Object)module2.getModuleTypeName(), (Object)"RIDER_MODULE_ANDROID") ^ true) continue;
                                Iterable $receiver$iv2 = xamarinProjects;
                                if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                                    bl = false;
                                } else {
                                    for (T element$iv : $receiver$iv2) {
                                        RunnableProject it = (RunnableProject)element$iv;
                                        if (!Intrinsics.areEqual((Object)XamarinAndroidRunnableProjectsUtilKt.getModuleName(it), (Object)module.getName())) continue;
                                        bl = true;
                                        break block13;
                                    }
                                    bl = false;
                                }
                            }
                            if (bl) continue;
                            RiderAndroidFacetsManager.access$getLogger$cp().warn("Removing android module '" + module.getName() + "' because list of Xamarin.Android runnable projects doesn't contain it.");
                            ApplicationKt.getApplication().runWriteAction(new Runnable(moduleManager, module){
                                final /* synthetic */ ModuleManager $moduleManager;
                                final /* synthetic */ Module $module;

                                public final void run() {
                                    this.$moduleManager.disposeModule(this.$module);
                                }
                                {
                                    this.$moduleManager = moduleManager;
                                    this.$module = module;
                                }
                            });
                        }
                        if (AndroidCustomProjectManager.Companion.getInstance().isAndroidProject(this.$project) || CollectionsKt.any((Iterable)xamarinProjects)) {
                            RiderAndroidFacetsManager.access$getLogger$cp().info("Project has Android support");
                            RiderAndroidFacetsManager.access$verifyHasDummyAndroidFacet(this.this$0.this, this.$project);
                        } else {
                            RiderAndroidFacetsManager.access$getLogger$cp().info("Project doesn't have custom Android support");
                            RiderAndroidFacetsManager.access$cleanUpMainModuleAndroidData(this.this$0.this, this.$project);
                        }
                        RiderAndroidFacetsManager.access$verifyMainModuleDontHaveSdkReferences(this.this$0.this, this.$project);
                        ProjectSystemUtil.getSyncManager((Project)this.$project).syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_LOADED, true);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$project = project;
                        super(1);
                    }
                }));
            }
        });
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(RiderAndroidSdksManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        RiderAndroidFacetsManager.logger = logger;
        apiLevelKey = new Key("AndroidModuleTargetFrameworkApiLevel");
    }

    public static final /* synthetic */ void access$addFacetToIgnoredFacets(RiderAndroidFacetsManager $this, @NotNull Project project, @NotNull String moduleName, @NotNull String facetName) {
        $this.addFacetToIgnoredFacets(project, moduleName, facetName);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    @NotNull
    public static final /* synthetic */ RiderAndroidSdksManager access$getRiderAndroidSdksManager$p(RiderAndroidFacetsManager $this) {
        return $this.riderAndroidSdksManager;
    }

    public static final /* synthetic */ void access$verifyHasDummyAndroidFacet(RiderAndroidFacetsManager $this, @NotNull Project project) {
        $this.verifyHasDummyAndroidFacet(project);
    }

    public static final /* synthetic */ void access$cleanUpMainModuleAndroidData(RiderAndroidFacetsManager $this, @NotNull Project project) {
        $this.cleanUpMainModuleAndroidData(project);
    }

    public static final /* synthetic */ void access$verifyMainModuleDontHaveSdkReferences(RiderAndroidFacetsManager $this, @NotNull Project project) {
        $this.verifyMainModuleDontHaveSdkReferences(project);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/android/RiderAndroidFacetsManager$Companion;", "", "()V", "androidAssetsDefaultRelativePath", "", "androidManifestDefaultRelativePath", "androidResourcesDefaultRelativePath", "apiLevelKey", "Lcom/intellij/openapi/util/Key;", "", "getApiLevelKey", "()Lcom/intellij/openapi/util/Key;", "defaultAndroidFacetName", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "rider-android"})
    public static final class Companion {
        @NotNull
        public final Key<Integer> getApiLevelKey() {
            return apiLevelKey;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

