/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.android.run;

import com.jetbrains.rider.android.run.AaptDumpTreeNode;
import com.jetbrains.rider.android.run.XamarinAndroidAaptUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u00a8\u0006\t"}, d2={"buildTree", "Lcom/jetbrains/rider/android/run/AaptDumpTreeNode;", "dumpLines", "", "", "getActivitiesFromDumpOutput", "isMainActivity", "", "activity", "rider-android"})
public final class XamarinAndroidAaptUtilsKt {
    @NotNull
    public static final AaptDumpTreeNode buildTree(@NotNull List<String> dumpLines) {
        AaptDumpTreeNode root;
        Intrinsics.checkParameterIsNotNull(dumpLines, (String)"dumpLines");
        AaptDumpTreeNode currentNode = root = new AaptDumpTreeNode("", 'R', -1);
        for (String line : dumpLines) {
            char type;
            String prefix;
            String trimmed = StringsKt.trimStart((String)line, (char[])new char[]{' '});
            int depth = line.length() - trimmed.length();
            CharSequence charSequence = trimmed;
            if (charSequence.length() == 0 || !StringsKt.startsWith$default((String)trimmed, (String)(prefix = (type = trimmed.charAt(0)) + ": "), (boolean)false, (int)2, null)) continue;
            String value = StringsKt.removePrefix((String)trimmed, (CharSequence)prefix);
            AaptDumpTreeNode newNode = new AaptDumpTreeNode(value, type, depth);
            while (currentNode != null && currentNode.getDepth() >= depth) {
                currentNode = currentNode.getParent();
            }
            if (currentNode == null) {
                throw (Throwable)new IllegalStateException("Depth cannot be less then zero");
            }
            switch (type) {
                case 'A': {
                    currentNode.addAttribute(newNode);
                    break;
                }
                default: {
                    currentNode.addChild(newNode);
                }
            }
            currentNode = newNode;
        }
        return root;
    }

    @NotNull
    public static final List<String> getActivitiesFromDumpOutput(@NotNull List<String> dumpLines) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(dumpLines, (String)"dumpLines");
        List activitiesList = new ArrayList();
        AaptDumpTreeNode treeRoot = XamarinAndroidAaptUtilsKt.buildTree(dumpLines);
        AaptDumpTreeNode aaptDumpTreeNode = (AaptDumpTreeNode)CollectionsKt.firstOrNull(treeRoot.getChildren("android"));
        if (aaptDumpTreeNode == null) {
            return activitiesList;
        }
        AaptDumpTreeNode androidNamespaceNode = aaptDumpTreeNode;
        AaptDumpTreeNode aaptDumpTreeNode2 = (AaptDumpTreeNode)CollectionsKt.firstOrNull(androidNamespaceNode.getChildren("manifest"));
        if (aaptDumpTreeNode2 == null) {
            return activitiesList;
        }
        AaptDumpTreeNode manifestNode = aaptDumpTreeNode2;
        AaptDumpTreeNode aaptDumpTreeNode3 = (AaptDumpTreeNode)CollectionsKt.firstOrNull(manifestNode.getChildren("application"));
        if (aaptDumpTreeNode3 == null) {
            return activitiesList;
        }
        AaptDumpTreeNode applicationNode = aaptDumpTreeNode3;
        Pattern pattern = Pattern.compile("android:name\\([\\w\\d]+\\)=\"([\\w\\d_.]+)\"");
        Iterable iterable = $receiver$iv = (Iterable)applicationNode.getChildren("activity");
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            AaptDumpTreeNode it = (AaptDumpTreeNode)element$iv$iv;
            if (!XamarinAndroidAaptUtilsKt.isMainActivity(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            AaptDumpTreeNode it = (AaptDumpTreeNode)element$iv$iv;
            Pattern pattern2 = pattern;
            Intrinsics.checkExpressionValueIsNotNull((Object)pattern2, (String)"pattern");
            if (it.fetchMatchesFromAttributes(pattern2, (Function1<? super Matcher, String>)((Function1)getActivitiesFromDumpOutput.2.1.INSTANCE)) == null) continue;
            String it$iv$iv = string;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean isMainActivity(AaptDumpTreeNode activity) {
        AaptDumpTreeNode aaptDumpTreeNode = (AaptDumpTreeNode)CollectionsKt.firstOrNull(activity.getChildren("intent-filter"));
        if (aaptDumpTreeNode == null) {
            return false;
        }
        AaptDumpTreeNode intentFilterNode = aaptDumpTreeNode;
        AaptDumpTreeNode aaptDumpTreeNode2 = (AaptDumpTreeNode)CollectionsKt.firstOrNull(intentFilterNode.getChildren("action"));
        if (aaptDumpTreeNode2 == null) {
            return false;
        }
        AaptDumpTreeNode actionNode = aaptDumpTreeNode2;
        if ((AaptDumpTreeNode)CollectionsKt.firstOrNull(actionNode.getAttributres("android.intent.action.MAIN")) == null) {
            return false;
        }
        AaptDumpTreeNode aaptDumpTreeNode3 = (AaptDumpTreeNode)CollectionsKt.firstOrNull(intentFilterNode.getChildren("category"));
        if (aaptDumpTreeNode3 == null) {
            return false;
        }
        AaptDumpTreeNode categoryNode = aaptDumpTreeNode3;
        return (AaptDumpTreeNode)CollectionsKt.firstOrNull(categoryNode.getAttributres("android.intent.category.LAUNCHER")) != null;
        {
        }
    }
}

