/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.android.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandResult;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.android.run.XamarinAndroidProcessHandler;
import com.jetbrains.rider.android.run.XamarinAndroidRunEntity;
import com.jetbrains.rider.android.run.XamarinAndroidRunManager;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.RLifetimeKt;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.TimersKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0014J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J/\u0010\u001d\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00190!H\u0002\u00a2\u0006\u0002\u0010#R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/rider/android/run/XamarinAndroidProcessHandler;", "Lcom/intellij/execution/process/ProcessHandler;", "project", "Lcom/intellij/openapi/project/Project;", "entity", "Lcom/jetbrains/rider/android/run/XamarinAndroidRunEntity;", "outputProcessHandler", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/android/run/XamarinAndroidRunEntity;Lcom/intellij/execution/process/ProcessHandler;)V", "attemptsCount", "", "device", "Lcom/android/ddmlib/IDevice;", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "packageName", "", "port", "timer", "Ljava/util/Timer;", "xamarinAndroidRunManager", "Lcom/jetbrains/rider/android/run/XamarinAndroidRunManager;", "checkConnection", "", "destroyProcessImpl", "detachIsDefault", "", "detachProcessImpl", "getProcessInput", "Ljava/io/OutputStream;", "runCommandAndCheckCondition", "commandParts", "", "condition", "Lkotlin/Function1;", "Lcom/android/tools/idea/explorer/adbimpl/AdbShellCommandResult;", "([Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "Companion", "rider-android"})
public final class XamarinAndroidProcessHandler
extends ProcessHandler {
    private final IDevice device;
    private final String packageName;
    private final int port;
    private final Lifetime lifetime;
    private int attemptsCount;
    private final Timer timer;
    private final XamarinAndroidRunManager xamarinAndroidRunManager;
    private final ProcessHandler outputProcessHandler;
    private static final int MAX_ATTEMPT_COUNT = 4;
    public static final Companion Companion = new Companion(null);

    private final void checkConnection() {
        AndroidVersion androidVersion = this.device.getVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"device.version");
        if (androidVersion.getApiLevel() >= 25) {
            this.runCommandAndCheckCondition(new String[]{"pidof", this.packageName}, (Function1<? super AdbShellCommandResult, Boolean>)((Function1)checkConnection.1.INSTANCE));
        } else {
            this.runCommandAndCheckCondition(new String[]{"ps"}, (Function1<? super AdbShellCommandResult, Boolean>)((Function1)new Function1<AdbShellCommandResult, Boolean>(this){
                final /* synthetic */ XamarinAndroidProcessHandler this$0;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean invoke(@NotNull AdbShellCommandResult result) {
                    String string;
                    Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                    if (result.isError()) return false;
                    List list = result.getOutput();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"result.output");
                    Iterable $receiver$iv = list;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        return false;
                    }
                    Iterator<T> iterator = $receiver$iv.iterator();
                    do {
                        String it;
                        if (!iterator.hasNext()) return false;
                        T element$iv = iterator.next();
                        string = it = (String)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                    } while (!StringsKt.contains$default((CharSequence)string, (CharSequence)XamarinAndroidProcessHandler.access$getPackageName$p(this.this$0), (boolean)false, (int)2, null));
                    return true;
                }
                {
                    this.this$0 = xamarinAndroidProcessHandler;
                    super(1);
                }
            }));
        }
    }

    private final void runCommandAndCheckCondition(String[] commandParts, Function1<? super AdbShellCommandResult, Boolean> condition) {
        try {
            AdbShellCommandResult output = this.xamarinAndroidRunManager.executeShellCommand(this.device, commandParts);
            if (output.isError() || !((Boolean)condition.invoke((Object)output)).booleanValue()) {
                int n = this.attemptsCount;
                this.attemptsCount = n + 1;
                if (this.attemptsCount > 4) {
                    this.timer.cancel();
                    this.notifyProcessTerminated(0);
                }
            } else {
                this.attemptsCount = 0;
            }
        }
        catch (Exception e) {
            int n = this.attemptsCount;
            this.attemptsCount = n + 1;
        }
    }

    protected void destroyProcessImpl() {
        this.xamarinAndroidRunManager.executeShellCommand(this.device, new String[]{"am", "force-stop", this.packageName});
        if (this.port > 0) {
            try {
                this.device.removeForward(this.port, this.port);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.xamarinAndroidRunManager.executeShellCommand(this.device, new String[]{"setprop", "\"debug.mono.extra\"", "\"\""});
        if (!this.outputProcessHandler.isProcessTerminating() && !this.outputProcessHandler.isProcessTerminated()) {
            this.outputProcessHandler.destroyProcess();
        }
    }

    protected void detachProcessImpl() {
        if (this.port > 0) {
            try {
                this.device.removeForward(this.port, this.port);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.xamarinAndroidRunManager.executeShellCommand(this.device, new String[]{"setprop", "\"debug.mono.extra\"", "\"\""});
        if (!this.outputProcessHandler.isProcessTerminating() && !this.outputProcessHandler.isProcessTerminated()) {
            this.outputProcessHandler.destroyProcess();
        }
    }

    public boolean detachIsDefault() {
        return false;
    }

    @Nullable
    public OutputStream getProcessInput() {
        return null;
    }

    public XamarinAndroidProcessHandler(@NotNull Project project, @NotNull XamarinAndroidRunEntity entity, @NotNull ProcessHandler outputProcessHandler) {
        Timer timer2;
        Timer timer3;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)outputProcessHandler, (String)"outputProcessHandler");
        this.outputProcessHandler = outputProcessHandler;
        this.device = entity.getDevice();
        this.packageName = entity.getPackageName();
        this.port = entity.getPort();
        this.lifetime = entity.getLifetime();
        String string = "Check activity of " + this.packageName + " on device " + this.device.getSerialNumber();
        boolean bl = false;
        long l = 0L;
        long l2 = 500L;
        XamarinAndroidProcessHandler xamarinAndroidProcessHandler = this;
        Timer timer4 = timer3 = TimersKt.timer((String)string, (boolean)bl);
        TimerTask timerTask = new TimerTask(this){
            final /* synthetic */ XamarinAndroidProcessHandler this$0;
            {
                this.this$0 = xamarinAndroidProcessHandler;
            }

            public void run() {
                TimerTask $receiver = this;
                XamarinAndroidProcessHandler.access$checkConnection(this.this$0);
            }
        };
        timer4.schedule(timerTask, l, l2);
        xamarinAndroidProcessHandler.timer = timer2 = timer3;
        this.xamarinAndroidRunManager = XamarinAndroidRunManager.Companion.getInstance(project);
        RLifetimeKt.onTermination((Lifetime)this.lifetime, (Function0)((Function0)new Function0<Unit>(){

            public final void invoke() {
                timer.cancel();
            }
        }));
    }

    @NotNull
    public static final /* synthetic */ String access$getPackageName$p(XamarinAndroidProcessHandler $this) {
        return $this.packageName;
    }

    public static final /* synthetic */ void access$checkConnection(XamarinAndroidProcessHandler $this) {
        $this.checkConnection();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/android/run/XamarinAndroidProcessHandler$Companion;", "", "()V", "MAX_ATTEMPT_COUNT", "", "rider-android"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

