/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.android.run.runners;

import com.android.ddmlib.IDevice;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.DefaultProgramRunnerKt;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.util.Consumer;
import com.jetbrains.rider.android.run.AndroidManifestFileDescriptor;
import com.jetbrains.rider.android.run.XamarinAndroidRunEntity;
import com.jetbrains.rider.android.run.XamarinAndroidRunProfileState;
import com.jetbrains.rider.android.run.configuration.XamarinAndroidConfiguration;
import com.jetbrains.rider.util.lifetime.Lifetime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0007H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/android/run/runners/XamarinAndroidProgramRunner;", "Lcom/intellij/execution/runners/AsyncProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "getRunnerId", "rider-android"})
public final class XamarinAndroidProgramRunner
extends AsyncProgramRunner<RunnerSettings> {
    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        AsyncPromise asyncPromise = new AsyncPromise();
        try {
            RunProfileState runProfileState = state;
            if (!(runProfileState instanceof XamarinAndroidRunProfileState)) {
                runProfileState = null;
            }
            XamarinAndroidRunProfileState xamarinAndroidRunProfileState = (XamarinAndroidRunProfileState)runProfileState;
            if (xamarinAndroidRunProfileState == null) {
                throw (Throwable)new CantRunException("This run profile is not supported: " + state.getClass());
            }
            XamarinAndroidRunProfileState runProfileState2 = xamarinAndroidRunProfileState;
            runProfileState2.checkBeforeExecution();
            Lifetime lifetime = Lifetime.Companion.create(Lifetime.Companion.getEternal()).getLifetime();
            AndroidManifestFileDescriptor manifestFileDescriptor = runProfileState2.getManifestFileDescriptor();
            Executor executor = environment.getExecutor();
            Intrinsics.checkExpressionValueIsNotNull((Object)executor, (String)"environment.executor");
            ListenableFuture<IDevice> item = runProfileState2.getAndroidItemToLaunch(executor, environment, true);
            if (item == null) {
                asyncPromise.cancel();
                return (Promise)asyncPromise;
            }
            Promise<XamarinAndroidRunEntity> deployPromise = runProfileState2.deployItem(item, lifetime, manifestFileDescriptor);
            deployPromise.done((Consumer)new Consumer<XamarinAndroidRunEntity>(runProfileState2, asyncPromise, environment){
                final /* synthetic */ XamarinAndroidRunProfileState $runProfileState;
                final /* synthetic */ AsyncPromise $asyncPromise;
                final /* synthetic */ ExecutionEnvironment $environment;

                public final void consume(XamarinAndroidRunEntity runtimeEntity) {
                    try {
                        XamarinAndroidRunEntity xamarinAndroidRunEntity = runtimeEntity;
                        Intrinsics.checkExpressionValueIsNotNull((Object)xamarinAndroidRunEntity, (String)"runtimeEntity");
                        ExecutionResult descriptor = this.$runProfileState.execute(xamarinAndroidRunEntity);
                        this.$asyncPromise.setResult((Object)DefaultProgramRunnerKt.showRunContent((ExecutionResult)descriptor, (ExecutionEnvironment)this.$environment));
                    }
                    catch (Exception e) {
                        this.$asyncPromise.setError((Throwable)e);
                    }
                }
                {
                    this.$runProfileState = xamarinAndroidRunProfileState;
                    this.$asyncPromise = asyncPromise;
                    this.$environment = executionEnvironment;
                }
            });
            deployPromise.rejected((Consumer)new Consumer<Throwable>(asyncPromise){
                final /* synthetic */ AsyncPromise $asyncPromise;

                public final void consume(Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Intrinsics.checkExpressionValueIsNotNull((Object)throwable2, (String)"throwable");
                    this.$asyncPromise.setError(throwable2);
                }
                {
                    this.$asyncPromise = asyncPromise;
                }
            });
        }
        catch (Throwable t) {
            asyncPromise.setError(t);
        }
        return (Promise)asyncPromise;
    }

    @NotNull
    public String getRunnerId() {
        return "XamarinAndroidRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)executorId, (String)"executorId");
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        return Intrinsics.areEqual((Object)executorId, (Object)DefaultRunExecutor.EXECUTOR_ID) && profile instanceof XamarinAndroidConfiguration;
    }
}

