/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.actions;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.editorconfig.language.psi.EditorConfigElementTypes;
import org.editorconfig.language.psi.EditorConfigPsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/editorconfig/language/codeinsight/actions/EnterInEditorConfigFileHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegateAdapter;", "()V", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffsetRef", "Lcom/intellij/openapi/util/Ref;", "", "caretAdvance", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "Companion", "intellij.editorconfig"})
public final class EnterInEditorConfigFileHandler
extends EnterHandlerDelegateAdapter {
    private static final Regex WHITE_SPACE;
    @Deprecated
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        void text;
        Integer caretOffset;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull(caretOffsetRef, (String)"caretOffsetRef");
        Intrinsics.checkParameterIsNotNull(caretAdvance, (String)"caretAdvance");
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        if (!(file instanceof EditorConfigPsiFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor.getDocument();
        Project project = ((EditorConfigPsiFile)file).getProject();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitDocument(document);
        Integer n = caretOffset = (Integer)caretOffsetRef.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"caretOffset");
        PsiElement psiUnderCaret = file.findElementAt(n.intValue());
        PsiElement psiElement = psiUnderCaret;
        IElementType elementType = psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null;
        Object object = psiUnderCaret;
        Character psiElementStart = object != null && (object = object.getText()) != null ? StringsKt.firstOrNull((CharSequence)((CharSequence)object)) : null;
        Document document2 = document;
        Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
        String string = document2.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"document.text");
        CharSequence charSequence = string;
        int n2 = caretOffset;
        Character charUnderCaret = StringsKt.getOrNull((CharSequence)charSequence, (int)n2);
        if (Intrinsics.areEqual((Object)elementType, (Object)EditorConfigElementTypes.LINE_COMMENT) ^ true || EnterInEditorConfigFileHandler.Companion.isCommentStart(charUnderCaret)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Pair pair = EnterInEditorConfigFileHandler.Companion.isWhitespace(charUnderCaret) ? TuplesKt.to((Object)("" + '\n' + psiElementStart), (Object)3) : TuplesKt.to((Object)("" + '\n' + psiElementStart + ' '), (Object)3);
        charSequence = (String)pair.component1();
        int offset = ((Number)pair.component2()).intValue();
        document.insertString(caretOffset.intValue(), (CharSequence)text);
        editor.getCaretModel().moveToOffset(caretOffset + offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
        return EnterHandlerDelegate.Result.Stop;
    }

    static {
        Companion = new Companion(null);
        String string = "\\s";
        WHITE_SPACE = new Regex(string);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010\tJ\u0017\u0010\n\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/editorconfig/language/codeinsight/actions/EnterInEditorConfigFileHandler$Companion;", "", "()V", "WHITE_SPACE", "Lkotlin/text/Regex;", "isCommentStart", "", "char", "", "(Ljava/lang/Character;)Z", "isWhitespace", "intellij.editorconfig"})
    private static final class Companion {
        private final boolean isWhitespace(Character c) {
            return c != null && WHITE_SPACE.matches((CharSequence)String.valueOf(c.charValue()));
        }

        private final boolean isCommentStart(Character c) {
            return c != null && StringsKt.contains$default((CharSequence)"#;", (char)c.charValue(), (boolean)false, (int)2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

