/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.quickfixes;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigOption;
import org.editorconfig.language.psi.EditorConfigSection;
import org.editorconfig.language.psi.interfaces.EditorConfigDescribableElement;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigDeclarationDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigQualifiedKeyDescriptor;
import org.editorconfig.language.util.EditorConfigDescriptorUtil;
import org.editorconfig.language.util.EditorConfigTemplateUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/editorconfig/language/codeinsight/quickfixes/EditorConfigAddRequiredDeclarationsQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "missingDescriptors", "", "Lorg/editorconfig/language/schema/descriptors/impl/EditorConfigDeclarationDescriptor;", "id", "", "(Ljava/util/List;Ljava/lang/String;)V", "missingKeys", "Lorg/editorconfig/language/schema/descriptors/impl/EditorConfigQualifiedKeyDescriptor;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "problemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "intellij.editorconfig"})
public final class EditorConfigAddRequiredDeclarationsQuickFix
implements LocalQuickFix {
    private final List<EditorConfigQualifiedKeyDescriptor> missingKeys;
    private final String id;

    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("quickfix.declaration.add-required.description");
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)problemDescriptor, (String)"problemDescriptor");
        PsiElement psiElement = problemDescriptor.getPsiElement();
        if (!(psiElement instanceof EditorConfigDescribableElement)) {
            psiElement = null;
        }
        EditorConfigDescribableElement editorConfigDescribableElement = (EditorConfigDescribableElement)psiElement;
        if (editorConfigDescribableElement == null) {
            return;
        }
        EditorConfigDescribableElement element = editorConfigDescribableElement;
        EditorConfigSection section = element.getSection();
        EditorConfigOption option = element.getOption();
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
        Editor editor = fileEditorManager.getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        TemplateImpl template = EditorConfigTemplateUtil.buildFullTemplate$default(EditorConfigTemplateUtil.INSTANCE, this.id, this.missingKeys, section, MapsKt.mapOf((Pair)TuplesKt.to((Object)this.id, (Object)element.getText())), false, 16, null);
        Editor editor3 = editor2;
        Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"editor");
        editor3.getCaretModel().moveToOffset(option.getTextOffset() + option.getTextLength());
        editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor2.getSelectionModel().removeSelection();
        TemplateManager.getInstance((Project)project).startTemplate(editor2, (Template)template);
    }

    /*
     * WARNING - void declaration
     */
    public EditorConfigAddRequiredDeclarationsQuickFix(@NotNull List<EditorConfigDeclarationDescriptor> missingDescriptors, @NotNull String id) {
        List list;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(missingDescriptors, (String)"missingDescriptors");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.id = id;
        Iterable iterable = missingDescriptors;
        EditorConfigAddRequiredDeclarationsQuickFix editorConfigAddRequiredDeclarationsQuickFix = this;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            EditorConfigQualifiedKeyDescriptor editorConfigQualifiedKeyDescriptor;
            EditorConfigDescriptorUtil this_$iv = EditorConfigDescriptorUtil.INSTANCE;
            Object element$iv$iv$iv = iterator.next();
            Object element$iv$iv = element$iv$iv$iv;
            EditorConfigDeclarationDescriptor it = (EditorConfigDeclarationDescriptor)element$iv$iv;
            if ((EditorConfigQualifiedKeyDescriptor)this_$iv.getParentOfType(it, Reflection.getOrCreateKotlinClass(EditorConfigQualifiedKeyDescriptor.class)) == null) continue;
            EditorConfigQualifiedKeyDescriptor it$iv$iv = editorConfigQualifiedKeyDescriptor;
            destination$iv$iv.add(it$iv$iv);
        }
        editorConfigAddRequiredDeclarationsQuickFix.missingKeys = list = (List)destination$iv$iv;
    }
}

