/*
 * Decompiled with CFR 0.152.
 */
package io.nettyjarjar.handler.ipfilter;

import io.nettyjarjar.channel.ChannelFuture;
import io.nettyjarjar.channel.ChannelFutureListener;
import io.nettyjarjar.channel.ChannelHandler;
import io.nettyjarjar.channel.ChannelHandlerContext;
import io.nettyjarjar.handler.ipfilter.AbstractRemoteAddressFilter;
import io.nettyjarjar.util.internal.ConcurrentSet;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Set;

@ChannelHandler.Sharable
public class UniqueIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final Set<InetAddress> connected = new ConcurrentSet<InetAddress>();

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        final InetAddress remoteIp = remoteAddress.getAddress();
        if (this.connected.contains(remoteIp)) {
            return false;
        }
        this.connected.add(remoteIp);
        ctx.channel().closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                UniqueIpFilter.this.connected.remove(remoteIp);
            }
        });
        return true;
    }
}

