/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.pages;

import com.dmarcotte.handlebars.HbBundle;
import com.dmarcotte.handlebars.HbLanguage;
import com.dmarcotte.handlebars.config.HbConfig;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class HbConfigurationPage
implements SearchableConfigurable {
    private JCheckBox myAutoGenerateClosingTagCheckBox;
    private JPanel myWholePanel;
    private JCheckBox myFormattingCheckBox;
    private JComboBox myCommenterLanguage;
    private JCheckBox myAutocompleteMustaches;
    private JCheckBox htmlAsHb;
    private final Project myProject;

    public HbConfigurationPage(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
    }

    @NotNull
    public String getId() {
        if ("editor.preferences.handlebarsOptions" == null) {
            HbConfigurationPage.$$$reportNull$$$0(0);
        }
        return "editor.preferences.handlebarsOptions";
    }

    @Nls
    public String getDisplayName() {
        return HbBundle.message("hb.pages.options.title", new Object[0]);
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return "reference.settings.ide.settings.handlebars.mustache";
    }

    public JComponent createComponent() {
        return this.myWholePanel;
    }

    public boolean isModified() {
        return this.myAutoGenerateClosingTagCheckBox.isSelected() != HbConfig.isAutoGenerateCloseTagEnabled() || this.myAutocompleteMustaches.isSelected() != HbConfig.isAutocompleteMustachesEnabled() || this.myFormattingCheckBox.isSelected() != HbConfig.isFormattingEnabled() || this.htmlAsHb.isSelected() != HbConfig.shouldOpenHtmlAsHandlebars(this.myProject) || !HbConfig.getCommenterLanguage().getID().equals(this.getSelectedLanguageId());
    }

    private String getSelectedLanguageId() {
        Object item = this.myCommenterLanguage.getSelectedItem();
        return item == null ? null : ((Language)item).getID();
    }

    public void apply() throws ConfigurationException {
        HbConfig.setAutoGenerateCloseTagEnabled(this.myAutoGenerateClosingTagCheckBox.isSelected());
        HbConfig.setAutocompleteMustachesEnabled(this.myAutocompleteMustaches.isSelected());
        HbConfig.setFormattingEnabled(this.myFormattingCheckBox.isSelected());
        HbConfig.setCommenterLanguage((Language)this.myCommenterLanguage.getSelectedItem());
        if (HbConfig.setShouldOpenHtmlAsHandlebars(this.htmlAsHb.isSelected(), this.myProject)) {
            ApplicationManager.getApplication().runWriteAction(() -> FileTypeManagerEx.getInstanceEx().fireFileTypesChanged());
        }
    }

    public void reset() {
        this.myAutoGenerateClosingTagCheckBox.setSelected(HbConfig.isAutoGenerateCloseTagEnabled());
        this.myAutocompleteMustaches.setSelected(HbConfig.isAutocompleteMustachesEnabled());
        this.myFormattingCheckBox.setSelected(HbConfig.isFormattingEnabled());
        this.htmlAsHb.setSelected(HbConfig.shouldOpenHtmlAsHandlebars(this.myProject));
        this.resetCommentLanguageCombo(HbConfig.getCommenterLanguage());
    }

    private void resetCommentLanguageCombo(@NotNull Language commentLanguage) {
        if (commentLanguage == null) {
            HbConfigurationPage.$$$reportNull$$$0(1);
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.myCommenterLanguage.getModel();
        List languages = TemplateDataLanguageMappings.getTemplateableLanguages();
        languages.add(HbLanguage.INSTANCE);
        Collections.sort(languages, (o1, o2) -> o1.getID().compareTo(o2.getID()));
        for (Language language : languages) {
            model.addElement(language);
        }
        this.myCommenterLanguage.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                LanguageFileType type;
                this.setText(value == null ? "" : ((Language)value).getDisplayName());
                if (value != null && (type = ((Language)value).getAssociatedFileType()) != null) {
                    this.setIcon(type.getIcon());
                }
            }
        });
        this.myCommenterLanguage.setSelectedItem(commentLanguage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/dmarcotte/handlebars/pages/HbConfigurationPage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/dmarcotte/handlebars/pages/HbConfigurationPage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetCommentLanguageCombo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JComboBox jComboBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel;
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        this.myAutoGenerateClosingTagCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/HbBundle").getString("hb.pages.options.generate.closing.tag"));
        jPanel.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myFormattingCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/HbBundle").getString("hb.pages.options.formatter"));
        jPanel.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/HbBundle").getString("hb.page.options.commenter.language"));
        jLabel.setToolTipText(ResourceBundle.getBundle("messages/HbBundle").getString("hb.page.options.commenter.language.tooltip"));
        jPanel.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAutocompleteMustaches = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/HbBundle").getString("hb.pages.options.complete.close.mustache"));
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("messages/HbBundle").getString("hb.pages.options.complete.close.tooltip"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCommenterLanguage = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(137, 28), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.htmlAsHb = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/HbBundle").getString("hb.pages.options.html.as.hb"));
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

