/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.plugins.jade.JadeLanguage;
import com.jetbrains.plugins.jade.lexer.IndentUtil;
import com.jetbrains.plugins.jade.psi.JadeFileImpl;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;
import com.jetbrains.plugins.jade.psi.impl.JadePipedTextImpl;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadeCopyPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        return null;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        if (!(file instanceof JadeFileImpl)) {
            String string = text;
            if (string == null) {
                JadeCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyleSettingsManager.getSettings((Project)editor.getProject()).getCommonSettings((Language)JadeLanguage.INSTANCE).getIndentOptions();
        if (indentOptions == null && (indentOptions = CodeStyleSettingsManager.getSettings((Project)editor.getProject()).getIndentOptions()) == null) {
            Logger.getInstance(JadeCopyPasteProcessor.class).error("indent options are null");
            String string = text;
            if (string == null) {
                JadeCopyPasteProcessor.$$$reportNull$$$0(1);
            }
            return string;
        }
        String normalizedText = Character.isWhitespace(text.charAt(0)) || JadeCopyPasteProcessor.someLineExceptFirstOneDoesntStartWithWhiteSpace(text) ? this.processTextWithLeadingWhitespace(text, indentOptions) : text;
        CaretModel caretModel = editor.getCaretModel();
        SelectionModel selectionModel = editor.getSelectionModel();
        Document document = editor.getDocument();
        int caretOffset = selectionModel.getSelectionStart() != selectionModel.getSelectionEnd() ? selectionModel.getSelectionStart() : caretModel.getOffset();
        PsiElement containingElement = file.findElementAt(Math.max(0, caretOffset - 1));
        if (containingElement == null) {
            String string = normalizedText;
            if (string == null) {
                JadeCopyPasteProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }
        String firstLineIndent = JadeCopyPasteProcessor.getIndentBefore(document, caretOffset);
        IElementType containingElementType = containingElement.getNode().getElementType();
        if (JadeTokenTypes.TEXT_SET.contains(containingElementType) || PsiTreeUtil.getParentOfType((PsiElement)containingElement, JadePipedTextImpl.class) != null) {
            String string = JadeCopyPasteProcessor.appendToLines(normalizedText, firstLineIndent + " | ");
            if (string == null) {
                JadeCopyPasteProcessor.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = JadeCopyPasteProcessor.appendToLines(normalizedText, firstLineIndent);
        if (string == null) {
            JadeCopyPasteProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String appendToLines(@NotNull String text, @NotNull String toAppend) {
        if (text == null) {
            JadeCopyPasteProcessor.$$$reportNull$$$0(5);
        }
        if (toAppend == null) {
            JadeCopyPasteProcessor.$$$reportNull$$$0(6);
        }
        String string = StringUtil.join((Collection)StringUtil.split((String)text, (String)"\n", (boolean)true, (boolean)false), (String)("\n" + toAppend));
        if (string == null) {
            JadeCopyPasteProcessor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String getIndentBefore(@NotNull Document document, int offset) {
        if (document == null) {
            JadeCopyPasteProcessor.$$$reportNull$$$0(8);
        }
        CharSequence s = document.getCharsSequence();
        int lastEol = StringUtil.lastIndexOf((CharSequence)s, (char)'\n', (int)0, (int)offset);
        StringBuilder result = new StringBuilder();
        for (int i = lastEol + 1; i < offset && Character.isWhitespace(s.charAt(i)); ++i) {
            result.append(s.charAt(i));
        }
        String string = result.toString();
        if (string == null) {
            JadeCopyPasteProcessor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String processTextWithLeadingWhitespace(@NotNull String text, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (text == null) {
            JadeCopyPasteProcessor.$$$reportNull$$$0(10);
        }
        if (indentOptions == null) {
            JadeCopyPasteProcessor.$$$reportNull$$$0(11);
        }
        List lines = StringUtil.split((String)text, (String)"\n", (boolean)true, (boolean)false);
        int minIndent = Integer.MAX_VALUE;
        for (String line : lines) {
            if (line.isEmpty()) continue;
            minIndent = Math.min(minIndent, IndentUtil.calcIndent(line, 0, indentOptions.TAB_SIZE));
        }
        StringBuilder result = new StringBuilder();
        for (String line : lines) {
            if (result.length() > 0) {
                result.append("\n");
            }
            int curIndent = IndentUtil.calcIndent(line, 0, indentOptions.TAB_SIZE);
            result.append(StringUtil.repeat((String)" ", (int)Math.max(0, curIndent - minIndent))).append(StringUtil.trimLeading((String)line));
        }
        String string = result.toString();
        if (string == null) {
            JadeCopyPasteProcessor.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static boolean someLineExceptFirstOneDoesntStartWithWhiteSpace(String text) {
        List lines = StringUtil.split((String)text, (String)"\n");
        for (int i = 1; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            if (Character.isWhitespace(line.charAt(0))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/jade/JadeCopyPasteProcessor";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAppend";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/jade/JadeCopyPasteProcessor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "appendToLines";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentBefore";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "processTextWithLeadingWhitespace";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendToLines";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIndentBefore";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processTextWithLeadingWhitespace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

