/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.js;

import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Range;
import com.jetbrains.plugins.jade.js.JavaScriptInJadeLanguageDialect;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptInJadeLexer
extends LayeredLexer {
    public JavaScriptInJadeLexer() {
        super((Lexer)new JSFlexAdapter(JavaScriptInJadeLanguageDialect.DIALECT_OPTION_HOLDER));
        this.registerLayer((Lexer)new JavaScriptInJadeStringLexer(), new IElementType[]{JSTokenTypes.STRING_LITERAL});
    }

    private static class JavaScriptInJadeStringLexer
    extends LexerBase {
        private final JSFlexAdapter myExpressionLexer = new JSFlexAdapter(JavaScriptInJadeLanguageDialect.DIALECT_OPTION_HOLDER);
        private CharSequence myBuffer;
        private int myStartOffset;
        private int myEndOffset;
        private int myState;
        private int myStringPartStart;
        private Range<Integer> myNextInterpolatedPart;

        private JavaScriptInJadeStringLexer() {
        }

        public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
            if (buffer == null) {
                JavaScriptInJadeStringLexer.$$$reportNull$$$0(0);
            }
            this.myBuffer = buffer;
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
            this.myState = initialState;
            if (this.myState > 0) {
                this.myExpressionLexer.start(buffer, startOffset, endOffset, this.myState - 1);
            }
            this.myStringPartStart = 0;
            this.findNextInterpolatedPart();
        }

        public int getState() {
            return this.myState;
        }

        @Nullable
        public IElementType getTokenType() {
            if (this.myStringPartStart == -1) {
                return null;
            }
            return this.myState == 0 ? this.getStringElementType() : this.myExpressionLexer.getTokenType();
        }

        public int getTokenStart() {
            return this.myState == 0 ? this.myStartOffset + this.myStringPartStart : this.myExpressionLexer.getTokenStart();
        }

        public int getTokenEnd() {
            if (this.myState == 0) {
                return this.myNextInterpolatedPart == null ? this.myEndOffset : (Integer)this.myNextInterpolatedPart.getFrom();
            }
            return this.myExpressionLexer.getTokenEnd();
        }

        public void advance() {
            if (this.myState == 0) {
                if (this.myNextInterpolatedPart == null) {
                    this.myStringPartStart = -1;
                } else {
                    this.myExpressionLexer.start(this.myBuffer, ((Integer)this.myNextInterpolatedPart.getFrom()).intValue(), ((Integer)this.myNextInterpolatedPart.getTo()).intValue(), 0);
                    this.myState = 1 + this.myExpressionLexer.getState();
                    this.myStringPartStart = (Integer)this.myNextInterpolatedPart.getTo() - this.myStartOffset;
                    this.findNextInterpolatedPart();
                }
            } else {
                this.myExpressionLexer.advance();
                if (this.myExpressionLexer.getTokenType() == null) {
                    this.myState = 0;
                }
            }
        }

        @NotNull
        public CharSequence getBufferSequence() {
            CharSequence charSequence = this.myBuffer;
            if (charSequence == null) {
                JavaScriptInJadeStringLexer.$$$reportNull$$$0(1);
            }
            return charSequence;
        }

        public int getBufferEnd() {
            return this.myEndOffset;
        }

        private void findNextInterpolatedPart() {
            int absolutePosStart = this.myStartOffset + this.myStringPartStart;
            int interpolationStart = this.findInterpolationStartPos(absolutePosStart);
            if (interpolationStart == -1) {
                this.myNextInterpolatedPart = null;
                return;
            }
            int absolutePosEnd = (interpolationStart += 2) + 1;
            int interpolationEnd = this.findClosingBraceWithRespectToOpeningOnes(absolutePosEnd);
            this.myNextInterpolatedPart = interpolationEnd == -1 ? null : new Range((Comparable)Integer.valueOf(interpolationStart), (Comparable)Integer.valueOf(interpolationEnd));
        }

        private int findInterpolationStartPos(int absolutePosStart) {
            int i = absolutePosStart;
            while (i + 2 < this.myEndOffset) {
                if (this.myBuffer.charAt(i) == '#' && this.myBuffer.charAt(i + 1) == '{' && (i == absolutePosStart || this.myBuffer.charAt(i - 1) != '\\')) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private int findClosingBraceWithRespectToOpeningOnes(int startPos) {
            int balance = 1;
            int pos = startPos;
            while (balance > 0 && pos < this.myEndOffset) {
                char c;
                if ((c = this.myBuffer.charAt(pos++)) == '{') {
                    ++balance;
                    continue;
                }
                if (c != '}') continue;
                --balance;
            }
            if (balance == 0) {
                return pos - 1;
            }
            return -1;
        }

        private IElementType getStringElementType() {
            if (this.myStringPartStart == 0 && this.myNextInterpolatedPart == null) {
                return JSTokenTypes.STRING_LITERAL;
            }
            if (this.myStringPartStart == 0) {
                return JadeTokenTypes.INTERPOLATED_STRING_START;
            }
            if (this.myNextInterpolatedPart == null) {
                return JadeTokenTypes.INTERPOLATED_STRING_END;
            }
            return JadeTokenTypes.INTERPOLATED_STRING_PART;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/jade/js/JavaScriptInJadeLexer$JavaScriptInJadeStringLexer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/jade/js/JavaScriptInJadeLexer$JavaScriptInJadeStringLexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBufferSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "start";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

