/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.jetbrains.plugins.jade.JadeLanguage;
import com.jetbrains.plugins.jade.lexer.IndentUtil;
import com.jetbrains.plugins.jade.parser.TagParsing;
import com.jetbrains.plugins.jade.psi.JadeElementTypes;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class JadeParser
implements PsiParser {
    private static final Logger LOG = Logger.getInstance(JadeParser.class);
    private final int myTabSize;
    private PsiBuilder myBuilder;

    public JadeParser(CodeStyleSettings settings) {
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getCommonSettings((Language)JadeLanguage.INSTANCE).getIndentOptions();
        this.myTabSize = indentOptions != null ? indentOptions.TAB_SIZE : new CommonCodeStyleSettings.IndentOptions().TAB_SIZE;
    }

    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder) {
        if (root == null) {
            JadeParser.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            JadeParser.$$$reportNull$$$0(1);
        }
        this.myBuilder = builder;
        PsiBuilder.Marker fileMarker = builder.mark();
        PsiBuilder.Marker document = builder.mark();
        while (!builder.eof()) {
            this.parseTopLevel(-1);
        }
        document.done(JadeElementTypes.DOCUMENT);
        fileMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            JadeParser.$$$reportNull$$$0(2);
        }
        return aSTNode;
    }

    private void parseTopLevel(int parentIndent) {
        if (this.myBuilder.getTokenType() == null) {
            return;
        }
        this.passExcessEOLsAndIndents();
        int blockIndent = this.getCurrentIndent();
        while (!this.myBuilder.eof()) {
            this.passExcessEOLsAndIndents();
            int currentIndent = this.getCurrentIndent();
            if (currentIndent <= parentIndent || currentIndent < blockIndent) break;
            this.passEOLsAndIndents();
            this.parseNode(currentIndent);
        }
    }

    public void parseNode(int nodeIndent) {
        IElementType tokenType = this.myBuilder.getTokenType();
        if (tokenType == null) {
            return;
        }
        if (tokenType == JadeTokenTypes.JS_CODE_BLOCK_PATCHED) {
            this.myBuilder.advanceLexer();
        } else if (tokenType == JadeTokenTypes.TAG_NAME || tokenType == JadeTokenTypes.DOT || tokenType == JadeTokenTypes.TAG_ID) {
            this.parseTag(nodeIndent);
        } else if (tokenType != JadeTokenTypes.TEXT || !this.parseTag(nodeIndent)) {
            if (tokenType == JadeTokenTypes.COLON) {
                this.parseFilter(nodeIndent);
            } else if (tokenType == JadeTokenTypes.PLUS) {
                this.parseMixinInvocation(nodeIndent);
            } else if (tokenType == JadeTokenTypes.JS_META_CODE) {
                this.myBuilder.advanceLexer();
            } else if (tokenType == JadeTokenTypes.EQ || tokenType == JadeTokenTypes.NEQ) {
                this.parseJSTextLine();
            } else if (tokenType == JadeTokenTypes.PIPE) {
                this.parsePipedLine();
            } else if (tokenType == JadeTokenTypes.TEXT) {
                JadeParser.parsePlainTextLine(this.myBuilder);
            } else if (JadeTokenTypes.COMMENTS.contains(tokenType)) {
                this.parseComment(nodeIndent);
            } else if (tokenType == JadeTokenTypes.COND_KEYWORD) {
                this.parseConditionalStatement(nodeIndent);
            } else if (tokenType == JadeTokenTypes.JS_EACH_EXPR) {
                this.parseForStatement(nodeIndent);
            } else if (tokenType == JadeTokenTypes.CASE) {
                this.parseCaseStatement();
            } else if (tokenType == JadeTokenTypes.INCLUDE_KEYWORD || tokenType == JadeTokenTypes.EXTENDS_KEYWORD) {
                this.parseIncludeStatement(nodeIndent);
            } else if (tokenType == JadeTokenTypes.MIXIN_KEYWORD) {
                this.parseMixinDeclaration(nodeIndent);
            } else if (tokenType == JadeTokenTypes.DOCTYPE_KEYWORD) {
                this.parseDoctypeValue(nodeIndent);
            } else if (tokenType == JadeTokenTypes.YIELD_KEYWORD) {
                this.parseYieldStatement(nodeIndent);
            } else {
                this.error("Unknown token");
                this.myBuilder.advanceLexer();
            }
        }
    }

    private boolean parseTag(int nodeIndent) {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (this.parseTagOrMixinInternals(nodeIndent)) {
            marker.done(JadeElementTypes.TAG);
            return true;
        }
        marker.rollbackTo();
        return false;
    }

    private boolean parseTagOrMixinInternals(int nodeIndent) {
        IElementType tokenType;
        boolean isStyleTag = false;
        if (this.myBuilder.getTokenType() == JadeTokenTypes.TEXT && !this.parseInterpolatedTagName()) {
            return false;
        }
        while (!(this.myBuilder.eof() || (tokenType = this.myBuilder.getTokenType()) == JadeTokenTypes.EOL || tokenType == JadeTokenTypes.INDENT || tokenType == JadeTokenTypes.COLON || tokenType == JadeTokenTypes.DOT && this.myBuilder.lookAhead(1) != JadeTokenTypes.TAG_CLASS || tokenType == JadeTokenTypes.EQ || tokenType == JadeTokenTypes.NEQ)) {
            if (tokenType == JadeTokenTypes.LPAREN) {
                TagParsing.parseAttributeList(this.myBuilder);
                continue;
            }
            if (tokenType == JadeTokenTypes.DOT || tokenType == JadeTokenTypes.TAG_ID) {
                this.parseTagIdOrClassName(tokenType);
                continue;
            }
            if (tokenType == JadeTokenTypes.TAG_NAME) {
                isStyleTag = "style".equals(this.myBuilder.getTokenText());
            }
            if (tokenType == JadeTokenTypes.TEXT) {
                JadeParser.parsePlainTextLine(this.myBuilder);
                continue;
            }
            this.myBuilder.advanceLexer();
        }
        if (this.myBuilder.eof()) {
            return true;
        }
        tokenType = this.myBuilder.getTokenType();
        if (tokenType == JadeTokenTypes.COLON) {
            this.myBuilder.advanceLexer();
            this.parseNode(nodeIndent);
        } else if (tokenType == JadeTokenTypes.DOT) {
            this.myBuilder.advanceLexer();
            this.parseBlock(nodeIndent, isStyleTag);
        } else if (tokenType == JadeTokenTypes.EQ || tokenType == JadeTokenTypes.NEQ) {
            this.myBuilder.advanceLexer();
            this.expectToken(JadeTokenTypes.JS_EXPR, "expression");
            this.myBuilder.advanceLexer();
        } else {
            this.parseTopLevel(nodeIndent);
        }
        return true;
    }

    private boolean parseInterpolatedTagName() {
        PsiBuilder.Marker interpolatedName = this.myBuilder.mark();
        this.parseOneTextElement();
        if (!this.expectToken(JadeTokenTypes.JS_EXPR, "expression")) {
            interpolatedName.drop();
            return false;
        }
        this.myBuilder.advanceLexer();
        if (!this.expectToken(JadeTokenTypes.TEXT, "interpolation closing brace")) {
            interpolatedName.drop();
            return false;
        }
        this.parseOneTextElement();
        interpolatedName.done(JadeElementTypes.TAG_INTERP_NAME);
        return true;
    }

    private void parseTagIdOrClassName(IElementType tokenType) {
        PsiBuilder.Marker attrMarker = this.myBuilder.mark();
        this.myBuilder.mark().done(JadeElementTypes.FAKE_ATTR_NAME);
        PsiBuilder.Marker valueMarker = this.myBuilder.mark();
        if (tokenType == JadeTokenTypes.TAG_ID) {
            this.myBuilder.advanceLexer();
        } else {
            PsiBuilder.Marker m = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            LOG.assertTrue(this.myBuilder.getTokenType() == JadeTokenTypes.TAG_CLASS);
            this.myBuilder.advanceLexer();
            m.done(JadeElementTypes.CLASS);
        }
        valueMarker.done(JadeElementTypes.ATTRIBUTE_VALUE);
        attrMarker.done(JadeElementTypes.ATTRIBUTE);
    }

    private void parseFilter(int nodeIndent) {
        IElementType tokenType;
        LOG.assertTrue(this.myBuilder.getTokenType() == JadeTokenTypes.COLON);
        PsiBuilder.Marker marker = this.myBuilder.mark();
        while (!this.myBuilder.eof() && (tokenType = this.myBuilder.getTokenType()) != JadeTokenTypes.EOL && tokenType != JadeTokenTypes.INDENT) {
            this.myBuilder.advanceLexer();
        }
        this.parseBlock(nodeIndent, false);
        marker.done(JadeElementTypes.FILTER);
    }

    private void parseMixinInvocation(int nodeIndent) {
        LOG.assertTrue(this.myBuilder.getTokenType() == JadeTokenTypes.PLUS);
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (this.myBuilder.getTokenType() != JadeTokenTypes.TEXT) {
            this.expectToken(JadeTokenTypes.TAG_NAME, "mixin name");
        }
        this.parseTagOrMixinInternals(nodeIndent);
        marker.done(JadeElementTypes.MIXIN);
    }

    private void parseJSTextLine() {
        LOG.assertTrue(this.myBuilder.getTokenType() == JadeTokenTypes.EQ || this.myBuilder.getTokenType() == JadeTokenTypes.NEQ);
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (this.expectToken(JadeTokenTypes.JS_EXPR, "expression")) {
            this.myBuilder.advanceLexer();
        }
        marker.done(JadeElementTypes.JS_EXPR);
    }

    private void parsePipedLine() {
        LOG.assertTrue(this.myBuilder.getTokenType() == JadeTokenTypes.PIPE);
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        while (this.notEolOrEof()) {
            IElementType type = this.myBuilder.getTokenType();
            if (type == JadeTokenTypes.TEXT) {
                JadeParser.parsePlainTextLine(this.myBuilder);
                continue;
            }
            if (this.myBuilder.getTokenType() != JadeTokenTypes.JS_EXPR) {
                this.expectToken(JadeTokenTypes.JS_EXPR, "text or interpolation");
            }
            this.myBuilder.advanceLexer();
        }
        marker.done(JadeElementTypes.PIPED_TEXT);
    }

    public static void parsePlainTextLine(@NotNull PsiBuilder myBuilder) {
        if (myBuilder == null) {
            JadeParser.$$$reportNull$$$0(3);
        }
        LOG.assertTrue(myBuilder.getTokenType() == JadeTokenTypes.TEXT);
        PsiBuilder.Marker marker = myBuilder.mark();
        marker.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        while (myBuilder.getTokenType() == JadeTokenTypes.TEXT) {
            JadeParser.markTextPart(myBuilder);
        }
        marker.done(XmlElementType.XML_TEXT);
    }

    private void parseOneTextElement() {
        LOG.assertTrue(this.myBuilder.getTokenType() == JadeTokenTypes.TEXT);
        PsiBuilder.Marker marker = this.myBuilder.mark();
        marker.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        JadeParser.markTextPart(this.myBuilder);
        marker.done(XmlElementType.XML_TEXT);
    }

    private static void markTextPart(@NotNull PsiBuilder myBuilder) {
        if (myBuilder == null) {
            JadeParser.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(myBuilder.getTokenType() == JadeTokenTypes.TEXT);
        IElementType tokenType = Character.isWhitespace(Objects.requireNonNull(myBuilder.getTokenText()).charAt(0)) ? XmlTokenType.XML_REAL_WHITE_SPACE : XmlTokenType.XML_DATA_CHARACTERS;
        PsiBuilder.Marker mark = myBuilder.mark();
        myBuilder.advanceLexer();
        mark.collapse(tokenType);
    }

    private boolean notEolOrEof() {
        return !this.myBuilder.eof() && !JadeParser.isEol(this.myBuilder.getTokenType());
    }

    private void parseComment(int nodeIndent) {
        LOG.assertTrue(JadeTokenTypes.COMMENTS.contains(this.myBuilder.getTokenType()));
        PsiBuilder.Marker marker = this.myBuilder.mark();
        int secondLineIndent = IndentUtil.calcSecondLineIndent(this.myBuilder.getTokenText(), this.myTabSize);
        this.myBuilder.advanceLexer();
        while (!this.myBuilder.eof()) {
            this.passExcessEOLsAndIndents();
            int currentIndent = this.getCurrentIndent();
            if (secondLineIndent != -1 && currentIndent >= secondLineIndent) {
                LOG.warn("should not be here");
                this.myBuilder.advanceLexer();
                continue;
            }
            if (currentIndent <= nodeIndent) break;
            this.myBuilder.advanceLexer();
            this.pipelessText(nodeIndent);
            marker.done(JadeElementTypes.COMMENT);
            return;
        }
        marker.done(JadeElementTypes.COMMENT);
    }

    private void parseConditionalStatement(int nodeIndent) {
        LOG.assertTrue(this.myBuilder.getTokenType() == JadeTokenTypes.COND_KEYWORD);
        PsiBuilder.Marker marker = this.myBuilder.mark();
        PsiBuilder.Marker headerMarker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (!this.expectToken(JadeTokenTypes.JS_EXPR, "expression")) {
            headerMarker.drop();
            marker.done(JadeElementTypes.CONDITIONAL_STATEMENT);
            return;
        }
        this.myBuilder.advanceLexer();
        headerMarker.done(JadeElementTypes.CONDITIONAL_HEADER);
        if (!JadeParser.isEol(this.myBuilder.getTokenType())) {
            this.expectToken(JadeTokenTypes.INDENT, "indent");
            marker.done(JadeElementTypes.CONDITIONAL_STATEMENT);
            return;
        }
        this.parseSmthWithElse(nodeIndent, JadeElementTypes.CONDITIONAL_BODY, JadeElementTypes.CONDITIONAL_ELSE);
        marker.done(JadeElementTypes.CONDITIONAL_STATEMENT);
    }

    private void parseSmthWithElse(int nodeIndent, @NotNull IElementType bodyType, @NotNull IElementType elseType) {
        if (bodyType == null) {
            JadeParser.$$$reportNull$$$0(5);
        }
        if (elseType == null) {
            JadeParser.$$$reportNull$$$0(6);
        }
        this.passExcessEOLsAndIndents();
        int blockIndent = this.getCurrentIndent();
        PsiBuilder.Marker bodyMarker = null;
        if (blockIndent > nodeIndent) {
            bodyMarker = this.myBuilder.mark();
        } else if (blockIndent == nodeIndent) {
            ++blockIndent;
        }
        while (!this.myBuilder.eof()) {
            this.passExcessEOLsAndIndents();
            int currentIndent = this.getCurrentIndent();
            if (currentIndent < nodeIndent) {
                if (bodyMarker == null) break;
                bodyMarker.done(bodyType);
                bodyMarker = null;
                break;
            }
            if (currentIndent < blockIndent) {
                if (bodyMarker != null) {
                    bodyMarker.done(bodyType);
                    bodyMarker = null;
                }
                if (this.myBuilder.lookAhead(1) != JadeTokenTypes.ELSE_KEYWORD) break;
                this.myBuilder.advanceLexer();
                PsiBuilder.Marker elseBody = this.myBuilder.mark();
                this.myBuilder.advanceLexer();
                this.passExcessEOLsAndIndents();
                this.parseTopLevel(currentIndent);
                elseBody.done(elseType);
                break;
            }
            this.passExcessEOLsAndIndents();
            this.parseTopLevel(nodeIndent);
        }
        if (bodyMarker != null) {
            bodyMarker.done(bodyType);
        }
    }

    private void parseForStatement(int nodeIndent) {
        LOG.assertTrue(this.myBuilder.getTokenType() == JadeTokenTypes.JS_EACH_EXPR);
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (!JadeParser.isEol(this.myBuilder.getTokenType())) {
            this.expectToken(JadeTokenTypes.INDENT, "indent");
            marker.done(JadeElementTypes.FOR_STATEMENT);
            return;
        }
        this.parseSmthWithElse(nodeIndent, JadeElementTypes.FOR_BODY, JadeElementTypes.FOR_ELSE);
        marker.done(JadeElementTypes.FOR_STATEMENT);
    }

    private void parseCaseStatement() {
        LOG.assertTrue(this.myBuilder.getTokenType() == JadeTokenTypes.CASE);
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        this.expectToken(JadeTokenTypes.JS_EXPR, "expression");
        this.myBuilder.advanceLexer();
        this.passExcessEOLsAndIndents();
        this.expectToken(JadeTokenTypes.INDENT, "indent");
        int blockIndent = this.getCurrentIndent();
        while (!this.myBuilder.eof()) {
            this.passExcessEOLsAndIndents();
            int currentIndent = this.getCurrentIndent();
            if (currentIndent < blockIndent) break;
            this.passEOLsAndIndents();
            this.parseCaseWhen(blockIndent);
        }
        marker.done(JadeElementTypes.CASE_STATEMENT);
    }

    private void parseCaseWhen(int nodeIndent) {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        IElementType tokenType = this.myBuilder.getTokenType();
        if (tokenType != JadeTokenTypes.WHEN && tokenType != JadeTokenTypes.DEFAULT_KEYWORD) {
            marker.drop();
            this.expectToken(JadeTokenTypes.WHEN, "when or default");
            this.myBuilder.advanceLexer();
            return;
        }
        this.myBuilder.advanceLexer();
        if (tokenType == JadeTokenTypes.WHEN) {
            this.expectToken(JadeTokenTypes.JS_EXPR, "expression");
            this.myBuilder.advanceLexer();
        }
        if (this.myBuilder.getTokenType() == JadeTokenTypes.COLON) {
            this.myBuilder.advanceLexer();
            this.parseNode(nodeIndent);
        } else {
            this.parseTopLevel(nodeIndent);
        }
        marker.done(JadeElementTypes.WHEN_STATEMENT);
    }

    private void parseIncludeStatement(int nodeIndent) {
        LOG.assertTrue(this.myBuilder.getTokenType() == JadeTokenTypes.EXTENDS_KEYWORD || this.myBuilder.getTokenType() == JadeTokenTypes.INCLUDE_KEYWORD);
        boolean isIncludeStatement = this.myBuilder.getTokenType() == JadeTokenTypes.INCLUDE_KEYWORD;
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (isIncludeStatement && this.myBuilder.getTokenType() == JadeTokenTypes.COLON) {
            this.myBuilder.advanceLexer();
            this.expectToken(JadeTokenTypes.FILTER_NAME, "filter name");
            this.myBuilder.advanceLexer();
            if (this.myBuilder.getTokenType() == JadeTokenTypes.LPAREN) {
                PsiBuilder.Marker tagMarker = this.myBuilder.mark();
                TagParsing.parseAttributeList(this.myBuilder);
                tagMarker.done(JadeElementTypes.TAG);
            }
        }
        this.expectToken(JadeTokenTypes.FILE_PATH, "file path");
        PsiBuilder.Marker pathMark = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        pathMark.done(JadeElementTypes.FILE_PATH);
        if (isIncludeStatement) {
            this.parseTopLevel(nodeIndent);
        }
        marker.done(JadeElementTypes.INCLUDE_STATEMENT);
    }

    private void parseMixinDeclaration(int nodeIndent) {
        LOG.assertTrue(this.myBuilder.getTokenType() == JadeTokenTypes.MIXIN_KEYWORD);
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        this.expectToken(JadeTokenTypes.IDENTIFIER, "mixin name");
        this.myBuilder.advanceLexer();
        if (this.myBuilder.getTokenType() == JadeTokenTypes.JS_MIXIN_PARAMS) {
            this.myBuilder.advanceLexer();
        }
        this.passExcessEOLsAndIndents();
        if (this.notEolOrEof()) {
            this.expectToken(JadeTokenTypes.INDENT, "indent");
        } else if (this.getCurrentIndent() <= nodeIndent) {
            marker.rollbackTo();
            this.parseMixinDeclarationLikeInvocation(nodeIndent);
            return;
        }
        this.parseTopLevel(nodeIndent);
        marker.done(JadeElementTypes.MIXIN_DECLARATION);
    }

    private void parseMixinDeclarationLikeInvocation(int nodeIndent) {
        LOG.assertTrue(this.myBuilder.getTokenType() == JadeTokenTypes.MIXIN_KEYWORD);
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        this.expectToken(JadeTokenTypes.IDENTIFIER, "mixin name");
        this.myBuilder.advanceLexer();
        if (this.myBuilder.getTokenType() == JadeTokenTypes.JS_MIXIN_PARAMS) {
            this.myBuilder.remapCurrentToken(JadeTokenTypes.JS_MIXIN_PARAMS_VALUES);
            this.myBuilder.advanceLexer();
        }
        this.passExcessEOLsAndIndents();
        LOG.assertTrue(this.getCurrentIndent() <= nodeIndent);
        marker.done(JadeElementTypes.MIXIN);
    }

    private void parseBlock(int parentIndent, boolean doNotMakeNode) {
        this.passExcessEOLsAndIndents();
        int blockIndent = this.getCurrentIndent();
        if (blockIndent <= parentIndent) {
            return;
        }
        this.passEOLsAndIndents();
        PsiBuilder.Marker marker = this.myBuilder.mark();
        while (!this.myBuilder.eof()) {
            IElementType tokenType = this.myBuilder.getTokenType();
            if (!JadeParser.isEol(tokenType)) {
                if (tokenType == JadeTokenTypes.TEXT) {
                    JadeParser.parsePlainTextLine(this.myBuilder);
                    continue;
                }
                this.myBuilder.advanceLexer();
                continue;
            }
            this.passExcessEOLsAndIndents();
            int currentIndent = this.getCurrentIndent();
            if (currentIndent <= parentIndent) break;
            if (tokenType == JadeTokenTypes.TEXT) {
                this.pipelessText(parentIndent);
            }
            if (currentIndent < blockIndent) {
                JadeParser.closeMarker(marker, JadeElementTypes.BLOCK, !doNotMakeNode);
                return;
            }
            this.myBuilder.advanceLexer();
        }
        JadeParser.closeMarker(marker, JadeElementTypes.BLOCK, !doNotMakeNode);
    }

    private void parseDoctypeValue(int nodeIndent) {
        LOG.assertTrue(this.myBuilder.getTokenType() == JadeTokenTypes.DOCTYPE_KEYWORD);
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        while (this.notEolOrEof()) {
            if (this.myBuilder.getTokenType() == JadeTokenTypes.TEXT) {
                JadeParser.parsePlainTextLine(this.myBuilder);
                continue;
            }
            this.myBuilder.advanceLexer();
        }
        this.passExcessEOLsAndIndents();
        if (this.getCurrentIndent() > nodeIndent) {
            this.expectToken(JadeTokenTypes.EOL, "eol");
        }
        marker.done(JadeElementTypes.DOCTYPE);
    }

    private void parseYieldStatement(int nodeIndent) {
        LOG.assertTrue(this.myBuilder.getTokenType() == JadeTokenTypes.YIELD_KEYWORD);
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        while (this.notEolOrEof()) {
            this.expectToken(JadeTokenTypes.EOL, "eol");
            this.myBuilder.advanceLexer();
        }
        this.passExcessEOLsAndIndents();
        if (this.getCurrentIndent() > nodeIndent) {
            this.expectToken(JadeTokenTypes.EOL, "eol");
        }
        marker.done(JadeElementTypes.YIELD_STATEMENT);
    }

    private void passEOLsAndIndents() {
        IElementType tokenType = this.myBuilder.getTokenType();
        while (JadeParser.isEol(tokenType)) {
            this.myBuilder.advanceLexer();
            tokenType = this.myBuilder.getTokenType();
        }
    }

    private void passExcessEOLsAndIndents() {
        IElementType tokenType = this.myBuilder.getTokenType();
        IElementType nextTokenType = this.myBuilder.lookAhead(1);
        while (JadeParser.isEol(tokenType) && JadeParser.isEol(nextTokenType)) {
            this.myBuilder.advanceLexer();
            tokenType = nextTokenType;
            nextTokenType = this.myBuilder.lookAhead(1);
        }
    }

    private int getCurrentIndent() {
        if (this.myBuilder.eof()) {
            return 0;
        }
        return IndentUtil.calcIndent(this.myBuilder.getTokenText(), 0, this.myTabSize);
    }

    private boolean expectToken(IElementType tokenType, String nameForError) {
        if (this.myBuilder.getTokenType() != tokenType) {
            this.error(StringUtil.capitalize((String)nameForError) + " expected, " + this.myBuilder.getTokenType() + " found");
            return false;
        }
        return true;
    }

    private void error(@NotNull String message) {
        if (message == null) {
            JadeParser.$$$reportNull$$$0(7);
        }
        this.myBuilder.mark().error(StringUtil.capitalize((String)message));
    }

    private void pipelessText(int indent) {
        boolean seenNonWhitespace = false;
        PsiBuilder.Marker marker = this.myBuilder.mark();
        while (!this.myBuilder.eof()) {
            if (!JadeParser.isEol(this.myBuilder.getTokenType())) {
                seenNonWhitespace = true;
                if (this.myBuilder.getTokenType() == JadeTokenTypes.TEXT) {
                    JadeParser.parsePlainTextLine(this.myBuilder);
                    continue;
                }
                this.myBuilder.advanceLexer();
                continue;
            }
            this.passExcessEOLsAndIndents();
            if (this.getCurrentIndent() <= indent) break;
            this.myBuilder.advanceLexer();
        }
        if (!seenNonWhitespace) {
            marker.drop();
        } else {
            marker.error("Pipeless text");
        }
    }

    private static boolean isEol(IElementType tokenType) {
        return tokenType == JadeTokenTypes.EOL || tokenType == JadeTokenTypes.INDENT;
    }

    private static void closeMarker(PsiBuilder.Marker marker, IElementType type, boolean isDone) {
        if (isDone) {
            marker.done(type);
        } else {
            marker.drop();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/jade/parser/JadeParser";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodyType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elseType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/jade/parser/JadeParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parsePlainTextLine";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "markTextPart";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseSmthWithElse";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

