/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.oauth2.useragent;

import com.microsoft.alm.oauth2.useragent.AuthorizationException;
import com.microsoft.alm.oauth2.useragent.AuthorizationResponse;
import com.microsoft.alm.oauth2.useragent.RunnableFactory;
import com.microsoft.alm.oauth2.useragent.SwtInterceptingBrowser;
import com.microsoft.alm.oauth2.useragent.UserAgent;
import com.microsoft.alm.oauth2.useragent.UserAgentImpl;
import java.awt.Dimension;
import java.net.URI;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class StandardWidgetToolkit
implements UserAgent,
RunnableFactory<StandardWidgetToolkit>,
Runnable {
    static RunnableFactory<StandardWidgetToolkit> RUNNABLE_FACTORY_OVERRIDE = null;
    private RunnableFactory<StandardWidgetToolkit> swtRunnableFactory = RUNNABLE_FACTORY_OVERRIDE != null ? RUNNABLE_FACTORY_OVERRIDE : this;
    private String[] commandLineArgs;
    private Shell shell;
    private Display display;
    private SwtInterceptingBrowser swtInterceptingBrowser;

    public StandardWidgetToolkit(String ... commandLineArgs) {
        this.commandLineArgs = commandLineArgs;
        this.display = new Display();
        this.shell = new Shell(this.display);
        this.shell.setText("OAuth 2.0 Authorization Request");
        this.shell.setLayout((Layout)new FillLayout());
        Monitor monitor = this.display.getPrimaryMonitor();
        Rectangle bounds = monitor.getBounds();
        Dimension size = new Dimension((int)((double)bounds.width * 0.25), (int)((double)bounds.height * 0.55));
        this.shell.setSize(size.width, size.height);
        this.shell.setLocation((bounds.width - size.width) / 2, (bounds.height - size.height) / 2);
        Browser browser = new Browser((Composite)this.shell, 16384);
        this.swtInterceptingBrowser = new SwtInterceptingBrowser(browser, this.display, this.shell);
    }

    public static void main(String[] args) {
        StandardWidgetToolkit swt = new StandardWidgetToolkit(args);
        Runnable runnable = swt.swtRunnableFactory.create(swt);
        Thread thread = new Thread(runnable);
        thread.start();
        swt.showSwtWindow();
    }

    @Override
    public AuthorizationResponse requestAuthorizationCode(URI authorizationEndpoint, URI redirectUri) throws AuthorizationException {
        this.swtInterceptingBrowser.sendRequest(authorizationEndpoint, redirectUri);
        return this.swtInterceptingBrowser.waitForResponse();
    }

    @Override
    public Runnable create(StandardWidgetToolkit standardWidgetToolkit) {
        return this;
    }

    @Override
    public void run() {
        UserAgentImpl.decode(this, this.commandLineArgs, System.in, System.out);
        System.exit(0);
    }

    private void showSwtWindow() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
    }

    void dispose() {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                StandardWidgetToolkit.this.shell.dispose();
            }
        });
    }
}

