/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.jaxrs.ApiResourceEntityProvider;
import com.microsoft.alm.client.model.ApiResourceLocation;
import com.microsoft.alm.client.model.ApiResourceLocationCollection;
import com.microsoft.alm.client.model.ApiResourceVersion;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.client.model.ProxyAuthenticationRequiredException;
import com.microsoft.alm.client.model.VssException;
import com.microsoft.alm.client.model.VssResourceNotFoundException;
import com.microsoft.alm.client.model.VssServiceException;
import com.microsoft.alm.client.model.VssServiceResponseException;
import com.microsoft.alm.client.model.WrappedException;
import com.microsoft.alm.client.utils.JsonHelper;
import com.microsoft.alm.client.utils.StringUtil;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public abstract class AlmHttpClientBase {
    protected static final MediaType APPLICATION_JSON_TYPE = MediaType.APPLICATION_JSON_TYPE;
    protected static final MediaType APPLICATION_OCTET_STREAM_TYPE = MediaType.APPLICATION_OCTET_STREAM_TYPE;
    protected static final MediaType APPLICATION_ZIP_TYPE = new MediaType("application", "zip");
    protected static final MediaType TEXT_PLAIN_TYPE = MediaType.TEXT_PLAIN_TYPE;
    protected static final MediaType APPLICATION_JSON_PATCH_TYPE = new MediaType("application", "json-patch+json");
    protected static final MediaType APPLICATION_GIT_MEDIA_TYPE = new MediaType("application", "vnd.git-media");
    protected static final MediaType IMAGE_SVG_XML_MEDIA_TYPE = new MediaType("image", "svg+xml");
    protected static final MediaType IMAGE_PNG_MEDIA_TYPE = new MediaType("image", "png");
    protected static final MediaType APPLICATION_GZIP = new MediaType("application", "gzip");
    private static final String OPTIONS_RELATIVE_PATH = "_apis";
    private static final String AREA_PARAMETER_NAME = "area";
    private static final String RESOURCE_PARAMETER_NAME = "resource";
    private static final String ROUTE_TEMPLATE_SEPARATOR = "/";
    private static final ApiResourceVersion DEFAULT_API_VERSION = new ApiResourceVersion();
    private static final String API_VERSION_PARAMETER_NAME = "api-version";
    private static final String CHARSET_PARAMETER_NAME = "charset";
    private static final String VSS_HTTP_METHOD_OVERRIDE_PROPERTY = "VSS_HTTP_METHOD_OVERRIDE";
    private final Client rsClient;
    private final URI baseUrl;
    private final WebTarget baseTarget;
    private static final Properties clientProperties = new Properties();
    private final boolean overrideEnabled;
    private ApiResourceLocationCollection resourceLocations;
    private Exception lastException;

    protected AlmHttpClientBase(Object tfsConnection) {
        this.rsClient = null;
        this.baseUrl = null;
        this.baseTarget = null;
        this.overrideEnabled = this.getOverrideSetting();
    }

    protected AlmHttpClientBase(Object rsClient, URI baseUrl) {
        this.rsClient = (Client)rsClient;
        this.baseUrl = baseUrl;
        this.baseTarget = (WebTarget)this.rsClient.target(baseUrl).register(ApiResourceEntityProvider.class);
        this.overrideEnabled = this.getOverrideSetting();
    }

    protected boolean getOverrideSetting() {
        String overrideEnabledEnvVar = System.getProperty(VSS_HTTP_METHOD_OVERRIDE_PROPERTY);
        if (!StringUtil.isNullOrEmpty(overrideEnabledEnvVar)) {
            return Boolean.valueOf(overrideEnabledEnvVar);
        }
        return true;
    }

    protected boolean isOverrideEnabled() {
        return this.overrideEnabled;
    }

    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return null;
    }

    public URI getBaseUrl() {
        return this.baseUrl;
    }

    public Exception getLastExecutionException() {
        return this.lastException;
    }

    private ApiResourceLocation getLocation(UUID locationId) {
        if (this.resourceLocations == null) {
            WebTarget optionsTarget = this.baseTarget.path(OPTIONS_RELATIVE_PATH);
            Invocation.Builder builder = optionsTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
            try {
                this.resourceLocations = (ApiResourceLocationCollection)builder.async().options(ApiResourceLocationCollection.class).get();
            }
            catch (InterruptedException e) {
                return null;
            }
            catch (ExecutionException e) {
                this.lastException = (Exception)e.getCause();
                return null;
            }
        }
        return this.resourceLocations.getLocationById(locationId);
    }

    private WebTarget createTarget(UUID locationId, Map<String, Object> routeValues, Map<String, String> queryParameters) {
        ApiResourceLocation location = this.getLocation(locationId);
        if (location == null) {
            throw new VssResourceNotFoundException(locationId, this.baseUrl, this.lastException);
        }
        Map<String, Object> dictionary = this.toRouteDictionary(routeValues, location.getArea(), location.getResourceName());
        String routeTemplate = location.getRouteTemplate();
        String actualTemplate = this.removeUndefinedOptionalParameters(routeTemplate, dictionary);
        WebTarget targetTemplate = this.baseTarget.path(actualTemplate);
        WebTarget target = targetTemplate.resolveTemplates(dictionary);
        if (queryParameters != null) {
            for (Map.Entry<String, String> queryParameter : queryParameters.entrySet()) {
                target = target.queryParam(queryParameter.getKey(), new Object[]{queryParameter.getValue()});
            }
        }
        return target;
    }

    private String removeUndefinedOptionalParameters(String template, Map<String, Object> routeValues) {
        String[] templateParameters = template.split(ROUTE_TEMPLATE_SEPARATOR);
        ArrayList<String> actualParameters = new ArrayList<String>();
        for (int i = 0; i < templateParameters.length; ++i) {
            String parameter = templateParameters[i];
            if (parameter.startsWith("{")) {
                String name = parameter.startsWith("{*") ? parameter.substring(2, parameter.length() - 1) : parameter.substring(1, parameter.length() - 1);
                if (routeValues.get(name) == null) continue;
                actualParameters.add("{" + name + "}");
                continue;
            }
            actualParameters.add(parameter);
        }
        return StringUtil.join(ROUTE_TEMPLATE_SEPARATOR, actualParameters);
    }

    private Map<String, Object> toRouteDictionary(Map<String, Object> routeValues, String areaName, String resourceName) {
        HashMap<String, Object> dictionary = new HashMap<String, Object>();
        if (routeValues != null) {
            for (Map.Entry<String, Object> e : routeValues.entrySet()) {
                if (e.getValue() == null) continue;
                dictionary.put(e.getKey(), e.getValue());
            }
        }
        if (!dictionary.containsKey(AREA_PARAMETER_NAME)) {
            dictionary.put(AREA_PARAMETER_NAME, areaName);
        }
        if (!dictionary.containsKey(RESOURCE_PARAMETER_NAME)) {
            dictionary.put(RESOURCE_PARAMETER_NAME, resourceName);
        }
        return dictionary;
    }

    private MediaType getMediaTypeWithQualityHeaderValue(MediaType baseMediaType, ApiResourceVersion version) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(API_VERSION_PARAMETER_NAME, version.toString());
        parameters.put(CHARSET_PARAMETER_NAME, "UTF-8");
        MediaType mediaType = new MediaType(baseMediaType.getType(), baseMediaType.getSubtype(), parameters);
        return mediaType;
    }

    private MediaType getMediaTypeWithQualityHeaderValue(MediaType baseMediaType) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(CHARSET_PARAMETER_NAME, "UTF-8");
        MediaType mediaType = new MediaType(baseMediaType.getType(), baseMediaType.getSubtype(), parameters);
        return mediaType;
    }

    private boolean isJsonResponse(Response response) {
        if (response != null && response.getMediaType() != null) {
            return response.getMediaType().getType().equalsIgnoreCase("application") && response.getMediaType().getSubtype().equalsIgnoreCase("json");
        }
        return false;
    }

    protected ApiResourceVersion negotiateRequestVersion(ApiResourceLocation location, ApiResourceVersion version) {
        if (version == null) {
            return DEFAULT_API_VERSION;
        }
        if (location.getMinVersion().compareTo(version.getApiVersion()) > 0) {
            return null;
        }
        if (location.getMaxVersion().compareTo(version.getApiVersion()) < 0) {
            ApiResourceVersion negotiatedVersion = new ApiResourceVersion(location.getMaxVersion());
            boolean isPreview = location.getReleasedVersion().compareTo(location.getMaxVersion()) < 0;
            negotiatedVersion.setPreview(isPreview);
            return negotiatedVersion;
        }
        int resourceVersion = Math.min(version.getResourceVersion(), location.getResourceVersion());
        ApiResourceVersion negotiatedVersion = new ApiResourceVersion(version.getApiVersion(), resourceVersion);
        if (location.getReleasedVersion().compareTo(version.getApiVersion()) < 0) {
            negotiatedVersion.setPreview(true);
        } else {
            negotiatedVersion.setPreview(version.isPreview());
        }
        return negotiatedVersion;
    }

    private ApiResourceVersion NegotiateRequestVersion(UUID locationId, ApiResourceVersion version) {
        return this.negotiateRequestVersion(this.getLocation(locationId), version);
    }

    protected Invocation createRequest(HttpMethod method, UUID locationId, Map<String, Object> routeValues, ApiResourceVersion version, Map<String, String> queryParameters) {
        return this.createRequest(method, locationId, routeValues, version, null, null, queryParameters, APPLICATION_JSON_TYPE);
    }

    protected Invocation createRequest(HttpMethod method, UUID locationId, ApiResourceVersion version, MediaType acceptMediaType) {
        return this.createRequest(method, locationId, null, version, null, null, null, acceptMediaType);
    }

    protected Invocation createRequest(HttpMethod method, UUID locationId, Map<String, Object> routeValues, ApiResourceVersion version, MediaType acceptMediaType) {
        return this.createRequest(method, locationId, routeValues, version, null, null, null, acceptMediaType);
    }

    protected Invocation createRequest(HttpMethod method, UUID locationId, Map<String, Object> routeValues, ApiResourceVersion version, Map<String, String> queryParameters, MediaType acceptMediaType) {
        return this.createRequest(method, locationId, routeValues, version, null, null, queryParameters, acceptMediaType);
    }

    protected Invocation createRequest(HttpMethod method, UUID locationId, ApiResourceVersion version, Map<String, String> queryParameters, MediaType acceptMediaType) {
        return this.createRequest(method, locationId, null, version, null, null, queryParameters, acceptMediaType);
    }

    protected <TEntity> Invocation createRequest(HttpMethod method, UUID locationId, ApiResourceVersion version, TEntity value, MediaType contentMediaType, MediaType acceptMediaType) {
        return this.createRequest(method, locationId, null, version, value, contentMediaType, null, acceptMediaType);
    }

    protected <TEntity> Invocation createRequest(HttpMethod method, UUID locationId, Map<String, Object> routeValues, ApiResourceVersion version, TEntity value, MediaType contentMediaType, MediaType acceptMediaType) {
        return this.createRequest(method, locationId, routeValues, version, value, contentMediaType, null, acceptMediaType);
    }

    protected <TEntity> Invocation createRequest(HttpMethod method, UUID locationId, ApiResourceVersion version, TEntity value, MediaType contentMediaType, Map<String, String> queryParameters, MediaType acceptMediaType) {
        return this.createRequest(method, locationId, null, version, value, contentMediaType, queryParameters, acceptMediaType);
    }

    protected <TEntity> Invocation createRequest(HttpMethod method, UUID locationId, Map<String, Object> routeValues, ApiResourceVersion version, TEntity value, Map<String, String> queryParameters) {
        return this.createRequest(method, locationId, routeValues, version, value, APPLICATION_JSON_TYPE, queryParameters, APPLICATION_JSON_TYPE);
    }

    protected <TEntity> Invocation createRequest(HttpMethod method, UUID locationId, Map<String, Object> routeValues, ApiResourceVersion version, TEntity value, MediaType contentMediaType, Map<String, String> queryParameters, MediaType acceptMediaType) {
        HttpMethod httpMethod;
        WebTarget target = this.createTarget(locationId, routeValues, queryParameters);
        MediaType acceptType = this.getMediaTypeWithQualityHeaderValue(acceptMediaType, this.NegotiateRequestVersion(locationId, version));
        Invocation.Builder requestBuilder = target.request(new MediaType[]{acceptType});
        if (this.shouldOverrideHttpMethod(method)) {
            httpMethod = HttpMethod.POST;
            requestBuilder.header("X-HTTP-Method-Override", (Object)method);
        } else {
            httpMethod = method;
        }
        requestBuilder.header("X-TFS-Version", (Object)clientProperties.getProperty("version"));
        if (value != null) {
            MediaType contentType = this.getMediaTypeWithQualityHeaderValue(contentMediaType);
            return requestBuilder.build(httpMethod.getVerb(), Entity.entity(value, (MediaType)contentType));
        }
        if (httpMethod == HttpMethod.POST) {
            MediaType contentType = this.getMediaTypeWithQualityHeaderValue(APPLICATION_JSON_TYPE);
            return requestBuilder.build(httpMethod.getVerb(), Entity.entity((Object)"", (MediaType)contentType));
        }
        return requestBuilder.build(httpMethod.getVerb());
    }

    private Response sendRequest(Invocation request) {
        Response response;
        try {
            response = (Response)request.submit().get();
        }
        catch (ExecutionException e) {
            throw new VssServiceException(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new VssServiceException(e.getMessage(), e);
        }
        this.handleResponse(response);
        return response;
    }

    protected void sendRequest(Object request) {
        this.sendRequest((Invocation)request);
    }

    protected <TResult> TResult sendRequest(Object request, Class<TResult> resultClass) {
        Response response = this.sendRequest((Invocation)request);
        return (TResult)response.readEntity(resultClass);
    }

    protected <TResult> TResult sendRequest(Object request, TypeReference<TResult> resultClass) {
        Response response = this.sendRequest((Invocation)request);
        return (TResult)response.readEntity(new GenericType(resultClass.getType()));
    }

    protected void handleResponse(Response response) {
        if (response.getStatusInfo() == Response.Status.PROXY_AUTHENTICATION_REQUIRED) {
            throw new ProxyAuthenticationRequiredException();
        }
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Throwable exceptionToThrow = null;
            if (this.isJsonResponse(response)) {
                WrappedException wrappedException = (WrappedException)response.readEntity(WrappedException.class);
                exceptionToThrow = wrappedException.Unwrap(this.getTranslatedExceptions());
            }
            if (exceptionToThrow == null || !(exceptionToThrow instanceof VssException)) {
                MultivaluedMap headers;
                String message = null;
                if (exceptionToThrow != null) {
                    message = exceptionToThrow.getMessage();
                }
                if ((headers = response.getStringHeaders()).containsKey((Object)"X-TFS-ServiceError")) {
                    try {
                        message = URLDecoder.decode((String)headers.getFirst((Object)"X-TFS-ServiceError"), "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                } else if (StringUtil.isNullOrEmpty(message) && !StringUtil.isNullOrEmpty(response.getStatusInfo().getReasonPhrase())) {
                    message = response.getStatusInfo().getReasonPhrase();
                }
                exceptionToThrow = new VssServiceResponseException(response.getStatusInfo(), message, (Exception)exceptionToThrow);
            }
            throw (VssException)exceptionToThrow;
        }
    }

    protected void addModelAsQueryParams(NameValueCollection queryParams, Object model) {
        if (model != null) {
            Map<String, String> jSearchCriteria = JsonHelper.toQueryParametersMap(model);
            for (Map.Entry<String, String> property : jSearchCriteria.entrySet()) {
                if (StringUtil.isNullOrEmpty(property.getValue())) continue;
                queryParams.addIfNotEmpty(property.getKey(), property.getValue());
            }
        }
    }

    private static void loadClientProperties() {
        try {
            InputStream in = AlmHttpClientBase.class.getResourceAsStream("client.properties");
            clientProperties.load(in);
            in.close();
        }
        catch (Exception ex) {
            throw new VssServiceException(ex.getMessage(), ex);
        }
    }

    private boolean shouldOverrideHttpMethod(HttpMethod method) {
        if (this.isOverrideEnabled()) {
            return method.isOverrideable();
        }
        return false;
    }

    static {
        AlmHttpClientBase.loadClientProperties();
    }

    protected static enum HttpMethod {
        PATCH("PATCH", true),
        GET("GET", false),
        POST("POST", false),
        PUT("PUT", true),
        DELETE("DELETE", true),
        HEAD("HEAD", false),
        OPTIONS("OPTIONS", true);

        private String verb;
        private boolean overrideable;

        private HttpMethod(String verb, boolean overrideable) {
            this.verb = verb;
            this.overrideable = overrideable;
        }

        public boolean isOverrideable() {
            return this.overrideable;
        }

        public String getVerb() {
            return this.verb;
        }
    }
}

