/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.client.utils;

import com.microsoft.alm.client.Messages;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;

public abstract class StringUtil {
    public static final String EMPTY = "";
    public static final String UTF8_CHARSET = "UTF-8";
    private static final String PASSWORD_TOKEN = "Password=";
    private static final String PWD_TOKEN = "Pwd=";
    private static final String ACCOUNT_KEY_TOKEN = "AccountKey=";
    private static final String PASSWORD_MASK = "******";
    private static final List<Character> VALID_PASSWORD_ENDING = Arrays.asList(Character.valueOf(';'), Character.valueOf('\''), Character.valueOf('\"'));
    private static String[] TOKENS_TO_SCRUB = new String[]{"Password=", "Pwd=", "AccountKey="};

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String join(String delimiter, List<?> values) {
        StringBuilder sb = new StringBuilder();
        for (Object v : values) {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(v);
        }
        return sb.toString();
    }

    public static String scrubPassword(String message) {
        return StringUtil.scrubPassword(message, true);
    }

    public static String scrubPassword(String message, boolean assertOnDetection) {
        if (StringUtil.isNullOrEmpty(message)) {
            return message;
        }
        String msg = message;
        for (String token : TOKENS_TO_SCRUB) {
            msg = StringUtil.scrubSecret(msg, token, PASSWORD_MASK, assertOnDetection);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String scrubSecret(String message, String token, String mask, boolean assertOnDetection) {
        int startIndex = 0;
        String msg = message;
        while ((startIndex = msg.toUpperCase().indexOf(token.toUpperCase(), startIndex)) >= 0) {
            if (msg.toUpperCase().indexOf(token.toUpperCase() + mask.toUpperCase()) == startIndex) {
                startIndex += token.length() + mask.length();
            } else {
                try {
                    int i;
                    int endIndex = msg.length() - 1;
                    if (msg.charAt(startIndex += token.length()) == '\"' || msg.charAt(startIndex) == '\'') {
                        for (i = startIndex + 1; i < msg.length() - 1; ++i) {
                            if (msg.charAt(startIndex) != msg.charAt(i)) continue;
                            if (msg.charAt(startIndex) == msg.charAt(i + 1)) {
                                ++i;
                                continue;
                            }
                            endIndex = i;
                            break;
                        }
                    } else {
                        for (i = startIndex + 1; i < msg.length(); ++i) {
                            if (!VALID_PASSWORD_ENDING.contains(Character.valueOf(msg.charAt(i)))) continue;
                            endIndex = i - 1;
                            break;
                        }
                    }
                    msg = msg.substring(0, startIndex) + mask + msg.substring(endIndex + 1);
                    if (assertOnDetection) assert (false) : MessageFormat.format(Messages.getString("StringUtil.UnmaskedPasswordFormat"), msg);
                }
                catch (Exception exception) {
                }
                finally {
                    startIndex += mask.length();
                }
            }
            if (startIndex < msg.length()) continue;
        }
        return msg;
    }

    public static String newString(char padChar, int width) {
        char[] buf = new char[width];
        for (int i = 0; i < width; ++i) {
            buf[i] = padChar;
        }
        return new String(buf);
    }

    public static String pad(String s, int width, boolean leftJustified, char padChar) {
        if (leftJustified) {
            return (s + StringUtil.newString(padChar, width)).substring(0, width);
        }
        return (StringUtil.newString(padChar, width) + s).substring(s.length());
    }

    public static String pad(String s, int width, boolean leftJustified) {
        return StringUtil.pad(s, width, leftJustified, ' ');
    }

    public static String pad(String s, int width) {
        return StringUtil.pad(s, width, true, ' ');
    }

    public static String pad(Number n, int width, char padChar) {
        return StringUtil.pad(n.toString(), width, false, padChar);
    }

    public static String pad(Number n, int width) {
        return StringUtil.pad(n, width, ' ');
    }
}

