/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.visualstudio.services.webapi.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.alm.client.Messages;
import com.microsoft.alm.client.utils.StringUtil;
import com.microsoft.visualstudio.services.webapi.model.ReferenceLink;
import com.microsoft.visualstudio.services.webapi.model.ReferenceLinks;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class ReferenceLinksDeserializer
extends JsonDeserializer<ReferenceLinks> {
    public ReferenceLinks deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        ReferenceLinks result = new ReferenceLinks();
        if (parser.getCurrentToken().equals((Object)JsonToken.START_OBJECT)) {
            HashMap<String, Object> links = new HashMap<String, Object>();
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                String name = parser.getCurrentName();
                if (StringUtil.isNullOrEmpty(name)) {
                    throw new IOException(Messages.getString("ReferenceLinksDeserializer.InvalidReferenceLink"));
                }
                parser.nextToken();
                if (parser.getCurrentToken().equals((Object)JsonToken.START_OBJECT)) {
                    links.put(name, parser.readValueAs(ReferenceLink.class));
                    continue;
                }
                if (parser.getCurrentToken().equals((Object)JsonToken.START_ARRAY)) {
                    List values = (List)parser.readValueAs((TypeReference)new TypeReference<List<ReferenceLink>>(){});
                    links.put(name, values);
                    continue;
                }
                throw new IOException(Messages.getString("ReferenceLinksDeserializer.InvalidReferenceLink"));
            }
            result.setLinks(links);
        } else {
            ObjectMapper mapper = (ObjectMapper)parser.getCodec();
            mapper.readTree(parser);
        }
        return result;
    }
}

