/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.PatternUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JavaProjectCodeInsightSettings", storages={@Storage(value="codeInsightSettings.xml")})
public class JavaProjectCodeInsightSettings
implements PersistentStateComponent<JavaProjectCodeInsightSettings> {
    private static final ConcurrentMap<String, Pattern> ourPatterns = ConcurrentFactoryMap.createWeakMap(PatternUtil::fromMask);
    @XCollection(propertyElementName="excluded-names", elementName="name", valueAttributeName="")
    public List<String> excludedNames = ContainerUtil.newArrayList();

    public static JavaProjectCodeInsightSettings getSettings(@NotNull Project project) {
        if (project == null) {
            JavaProjectCodeInsightSettings.$$$reportNull$$$0(0);
        }
        return (JavaProjectCodeInsightSettings)ServiceManager.getService((Project)project, JavaProjectCodeInsightSettings.class);
    }

    public boolean isExcluded(@NotNull String name2) {
        if (name2 == null) {
            JavaProjectCodeInsightSettings.$$$reportNull$$$0(1);
        }
        for (String excluded : this.excludedNames) {
            if (!JavaProjectCodeInsightSettings.nameMatches(name2, excluded)) continue;
            return true;
        }
        for (String excluded : CodeInsightSettings.getInstance().EXCLUDED_PACKAGES) {
            if (!JavaProjectCodeInsightSettings.nameMatches(name2, excluded)) continue;
            return true;
        }
        return false;
    }

    private static boolean nameMatches(@NotNull String name2, String excluded) {
        int length;
        if (name2 == null) {
            JavaProjectCodeInsightSettings.$$$reportNull$$$0(2);
        }
        return (length = JavaProjectCodeInsightSettings.getMatchingLength(name2, excluded)) > 0 && (name2.length() == length || name2.charAt(length) == '.');
    }

    private static int getMatchingLength(@NotNull String name2, String excluded) {
        Matcher matcher;
        if (name2 == null) {
            JavaProjectCodeInsightSettings.$$$reportNull$$$0(3);
        }
        if (name2.startsWith(excluded)) {
            return excluded.length();
        }
        if (excluded.indexOf(42) >= 0 && (matcher = ((Pattern)ourPatterns.get(excluded)).matcher(name2)).lookingAt()) {
            return matcher.end();
        }
        return -1;
    }

    @Nullable
    public JavaProjectCodeInsightSettings getState() {
        return this;
    }

    public void loadState(@NotNull JavaProjectCodeInsightSettings state) {
        if (state == null) {
            JavaProjectCodeInsightSettings.$$$reportNull$$$0(4);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public static void setExcludedNames(Project project, Disposable parentDisposable, String ... excludes) {
        final JavaProjectCodeInsightSettings instance = JavaProjectCodeInsightSettings.getSettings(project);
        assert (instance.excludedNames.isEmpty());
        instance.excludedNames = Arrays.asList(excludes);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                instance.excludedNames = ContainerUtil.newArrayList();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/JavaProjectCodeInsightSettings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isExcluded";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "nameMatches";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getMatchingLength";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

