/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiFieldPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.introduceField.InplaceIntroduceFieldPopup;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMemberNameCompletionContributor
extends CompletionContributor {
    public static final ElementPattern<PsiElement> INSIDE_TYPE_PARAMS_PATTERN = PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("?")).andOr(new ElementPattern[]{PlatformPatterns.psiElement().afterLeaf(new String[]{"<", ","}), PlatformPatterns.psiElement().afterSiblingSkipping((ElementPattern)PlatformPatterns.psiElement().whitespaceCommentEmptyOrError(), (ElementPattern)PlatformPatterns.psiElement(PsiAnnotation.class))}));
    static final int MAX_SCOPE_SIZE_TO_SEARCH_UNRESOLVED = 50000;

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result) {
        if (parameters2 == null) {
            JavaMemberNameCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            JavaMemberNameCompletionContributor.$$$reportNull$$$0(1);
        }
        if (parameters2.getCompletionType() != CompletionType.BASIC && parameters2.getCompletionType() != CompletionType.SMART) {
            return;
        }
        if (parameters2.getInvocationCount() == 0 && TemplateManagerImpl.getTemplateState((Editor)parameters2.getEditor()) != null) {
            return;
        }
        PsiElement position = parameters2.getPosition();
        THashSet lookupSet = new THashSet();
        if (((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiIdentifier.class).andNot(INSIDE_TYPE_PARAMS_PATTERN)).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(PsiLocalVariable.class), PlatformPatterns.psiElement(PsiParameter.class)}))).accepts((Object)position)) {
            JavaMemberNameCompletionContributor.completeLocalVariableName((Set<LookupElement>)lookupSet, result.getPrefixMatcher(), (PsiVariable)parameters2.getPosition().getParent(), parameters2.getInvocationCount() >= 1);
            for (LookupElement item : lookupSet) {
                if (!(item instanceof LookupItem)) continue;
                ((LookupItem)item).setAutoCompletionPolicy(AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE);
            }
        }
        if (((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiIdentifier.class).withParent(PsiField.class)).andNot(INSIDE_TYPE_PARAMS_PATTERN)).accepts((Object)position)) {
            PsiField variable = (PsiField)parameters2.getPosition().getParent();
            JavaMemberNameCompletionContributor.completeMethodName((Set<LookupElement>)lookupSet, (PsiElement)variable, result.getPrefixMatcher());
            JavaMemberNameCompletionContributor.completeFieldName((Set<LookupElement>)lookupSet, variable, result.getPrefixMatcher(), parameters2.getInvocationCount() >= 1);
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().nameIdentifierOf((ElementPattern)PsiJavaPatterns.psiMethod().withParent(PsiClass.class))).accepts((Object)position)) {
            JavaMemberNameCompletionContributor.completeMethodName((Set<LookupElement>)lookupSet, parameters2.getPosition().getParent(), result.getPrefixMatcher());
        }
        for (LookupElement item : lookupSet) {
            result.addElement(item);
        }
    }

    private static void completeLocalVariableName(Set<LookupElement> set, PrefixMatcher matcher, PsiVariable var, boolean includeOverlapped) {
        PsiExpression initializer;
        PsiElement parent;
        FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.variable.name");
        Project project = var.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        VariableKind variableKind = codeStyleManager.getVariableKind(var);
        String propertyName = null;
        if (variableKind == VariableKind.PARAMETER) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)var, PsiMethod.class);
            if (method != null) {
                propertyName = PropertyUtilBase.getPropertyName((PsiMethod)method);
            }
            if (method != null && method.getName().startsWith("with")) {
                propertyName = StringUtil.decapitalize((String)method.getName().substring(4));
            }
        }
        PsiType type2 = var.getType();
        SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(variableKind, propertyName, null, type2, StringUtil.isEmpty((String)matcher.getPrefix()));
        suggestedNameInfo = codeStyleManager.suggestUniqueVariableName(suggestedNameInfo, (PsiElement)var, false);
        String[] suggestedNames = suggestedNameInfo.names;
        JavaMemberNameCompletionContributor.addLookupItems(set, suggestedNameInfo, matcher, project, suggestedNames);
        if (!JavaMemberNameCompletionContributor.hasStartMatches(set, matcher)) {
            if (type2.equalsToText("java.lang.Object") && matcher.prefixMatches("object")) {
                set.add((LookupElement)JavaMemberNameCompletionContributor.withInsertHandler(suggestedNameInfo, (LookupElement)LookupElementBuilder.create((String)"object")));
            }
            if (type2.equalsToText("java.lang.String") && matcher.prefixMatches("string")) {
                set.add((LookupElement)JavaMemberNameCompletionContributor.withInsertHandler(suggestedNameInfo, (LookupElement)LookupElementBuilder.create((String)"string")));
            }
        }
        if (!JavaMemberNameCompletionContributor.hasStartMatches(set, matcher) && includeOverlapped) {
            JavaMemberNameCompletionContributor.addLookupItems(set, null, matcher, project, JavaMemberNameCompletionContributor.getOverlappedNameVersions(matcher.getPrefix(), suggestedNames, ""));
        }
        if ((parent = PsiTreeUtil.getParentOfType((PsiElement)var, PsiCodeBlock.class)) == null) {
            parent = PsiTreeUtil.getParentOfType((PsiElement)var, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        }
        JavaMemberNameCompletionContributor.addLookupItems(set, suggestedNameInfo, matcher, project, JavaMemberNameCompletionContributor.getUnresolvedReferences(parent, false, matcher));
        if (var instanceof PsiParameter && parent instanceof PsiMethod) {
            JavaMemberNameCompletionContributor.addSuggestionsInspiredByFieldNames(set, matcher, var, project, codeStyleManager);
        }
        if ((initializer = var.getInitializer()) != null) {
            SuggestedNameInfo initializerSuggestions = IntroduceVariableBase.getSuggestedName(type2, initializer);
            JavaMemberNameCompletionContributor.addLookupItems(set, initializerSuggestions, matcher, project, initializerSuggestions.names);
        }
    }

    private static boolean hasStartMatches(PrefixMatcher matcher, Set<String> set) {
        for (String s : set) {
            if (!matcher.isStartMatch(s)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasStartMatches(Set<LookupElement> set, PrefixMatcher matcher) {
        for (LookupElement lookupElement : set) {
            if (!matcher.isStartMatch(lookupElement)) continue;
            return true;
        }
        return false;
    }

    private static void addSuggestionsInspiredByFieldNames(Set<LookupElement> set, PrefixMatcher matcher, PsiVariable var, Project project, JavaCodeStyleManager codeStyleManager) {
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)var, PsiClass.class);
        if (psiClass == null) {
            return;
        }
        for (PsiField field : psiClass.getFields()) {
            String name2 = field.getName();
            if (!field.getType().isAssignableFrom(var.getType()) || name2 == null) continue;
            String prop = codeStyleManager.variableNameToPropertyName(name2, VariableKind.FIELD);
            JavaMemberNameCompletionContributor.addLookupItems(set, null, matcher, project, codeStyleManager.propertyNameToVariableName(prop, VariableKind.PARAMETER));
        }
    }

    private static String[] getOverlappedNameVersions(String prefix, String[] suggestedNames, String suffix) {
        ArrayList<String> newSuggestions = new ArrayList<String>();
        int longestOverlap = 0;
        for (String suggestedName : suggestedNames) {
            String suggestion;
            int lastIndexOfSuffix;
            int overlap;
            if (suggestedName.length() < 3) continue;
            if (StringUtil.startsWithIgnoreCase((String)suggestedName, (String)prefix)) {
                newSuggestions.add(suggestedName);
                longestOverlap = prefix.length();
            }
            if ((overlap = JavaMemberNameCompletionContributor.getOverlap(suggestedName = Character.toUpperCase(suggestedName.charAt(0)) + suggestedName.substring(1), prefix)) < longestOverlap) continue;
            if (overlap > longestOverlap) {
                newSuggestions.clear();
                longestOverlap = overlap;
            }
            if ((lastIndexOfSuffix = (suggestion = prefix.substring(0, prefix.length() - overlap) + suggestedName).lastIndexOf(suffix)) >= 0 && suffix.length() < suggestion.length() - lastIndexOfSuffix) {
                suggestion = suggestion.substring(0, lastIndexOfSuffix) + suffix;
            }
            if (newSuggestions.contains(suggestion)) continue;
            newSuggestions.add(suggestion);
        }
        return ArrayUtil.toStringArray(newSuggestions);
    }

    private static int getOverlap(String propertyName, String prefix) {
        int overlap = 0;
        int propertyNameLen = propertyName.length();
        int prefixLen = prefix.length();
        for (int j = 1; j < prefixLen && j < propertyNameLen; ++j) {
            if (!prefix.substring(prefixLen - j).equals(propertyName.substring(0, j))) continue;
            overlap = j;
        }
        return overlap;
    }

    private static String[] getUnresolvedReferences(PsiElement parentOfType, final boolean referenceOnMethod, final PrefixMatcher matcher) {
        if (parentOfType != null && parentOfType.getTextLength() > 50000) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        final LinkedHashSet unresolvedRefs = new LinkedHashSet();
        if (parentOfType != null) {
            parentOfType.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression reference) {
                    PsiElement parent = reference.getParent();
                    if (parent instanceof PsiReference || referenceOnMethod != parent instanceof PsiMethodCallExpression) {
                        return;
                    }
                    String refName = reference.getReferenceName();
                    if (refName != null && matcher.prefixMatches(refName) && reference.resolve() == null) {
                        unresolvedRefs.add(refName);
                    }
                }
            });
        }
        return ArrayUtil.toStringArray(unresolvedRefs);
    }

    private static void completeFieldName(Set<LookupElement> set, PsiField var, PrefixMatcher matcher, boolean includeOverlapped) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.variable.name");
        Project project = var.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        VariableKind variableKind = JavaCodeStyleManager.getInstance((Project)project).getVariableKind((PsiVariable)var);
        String prefix = matcher.getPrefix();
        if (PsiType.VOID.equals((Object)var.getType()) || ((PsiFieldPattern)PsiJavaPatterns.psiField().inClass((ElementPattern)PsiJavaPatterns.psiClass().isInterface().andNot((ElementPattern)PsiJavaPatterns.psiClass().isAnnotationType()))).accepts((Object)var)) {
            JavaMemberNameCompletionContributor.completeVariableNameForRefactoring(project, set, matcher, var.getType(), variableKind, includeOverlapped, true);
            return;
        }
        SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(variableKind, null, null, var.getType());
        String[] suggestedNames = suggestedNameInfo.names;
        JavaMemberNameCompletionContributor.addLookupItems(set, suggestedNameInfo, matcher, project, suggestedNames);
        if (!JavaMemberNameCompletionContributor.hasStartMatches(set, matcher) && includeOverlapped) {
            String requiredSuffix = codeStyleManager.getSuffixByVariableKind(variableKind);
            if (variableKind != VariableKind.STATIC_FINAL_FIELD) {
                for (int i = 0; i < suggestedNames.length; ++i) {
                    suggestedNames[i] = codeStyleManager.variableNameToPropertyName(suggestedNames[i], variableKind);
                }
            }
            JavaMemberNameCompletionContributor.addLookupItems(set, null, matcher, project, JavaMemberNameCompletionContributor.getOverlappedNameVersions(prefix, suggestedNames, requiredSuffix));
        }
        JavaMemberNameCompletionContributor.addLookupItems(set, suggestedNameInfo, matcher, project, JavaMemberNameCompletionContributor.getUnresolvedReferences(var.getParent(), false, matcher));
        PsiExpression initializer = var.getInitializer();
        PsiClass containingClass = var.getContainingClass();
        if (initializer != null && containingClass != null) {
            SuggestedNameInfo initializerSuggestions = InplaceIntroduceFieldPopup.suggestFieldName(var.getType(), null, initializer, var.hasModifierProperty("static"), containingClass);
            JavaMemberNameCompletionContributor.addLookupItems(set, initializerSuggestions, matcher, project, initializerSuggestions.names);
        }
    }

    public static void completeVariableNameForRefactoring(Project project, Set<LookupElement> set, PrefixMatcher matcher, PsiType varType, VariableKind varKind, boolean includeOverlapped, boolean methodPrefix) {
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(varKind, null, null, varType);
        String[] strings = JavaMemberNameCompletionContributor.completeVariableNameForRefactoring(codeStyleManager, matcher, varType, varKind, suggestedNameInfo, includeOverlapped, methodPrefix);
        JavaMemberNameCompletionContributor.addLookupItems(set, suggestedNameInfo, matcher, project, strings);
    }

    public static String[] completeVariableNameForRefactoring(JavaCodeStyleManager codeStyleManager, PrefixMatcher matcher, @Nullable PsiType varType, VariableKind varKind, SuggestedNameInfo suggestedNameInfo, boolean includeOverlapped, boolean methodPrefix) {
        String[] suggestedNames;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String suggestedName : suggestedNames = suggestedNameInfo.names) {
            if (!matcher.prefixMatches(suggestedName)) continue;
            result.add(suggestedName);
        }
        if (!JavaMemberNameCompletionContributor.hasStartMatches(matcher, result) && !PsiType.VOID.equals((Object)varType) && includeOverlapped) {
            String requiredSuffix = codeStyleManager.getSuffixByVariableKind(varKind);
            String prefix = matcher.getPrefix();
            if (varKind != VariableKind.STATIC_FINAL_FIELD || methodPrefix) {
                for (int i = 0; i < suggestedNames.length; ++i) {
                    suggestedNames[i] = codeStyleManager.variableNameToPropertyName(suggestedNames[i], varKind);
                }
            }
            ContainerUtil.addAll(result, (Object[])JavaMemberNameCompletionContributor.getOverlappedNameVersions(prefix, suggestedNames, requiredSuffix));
        }
        return ArrayUtil.toStringArray(result);
    }

    private static void completeMethodName(Set<LookupElement> set, PsiElement element, PrefixMatcher matcher) {
        PsiMethod method;
        if (element instanceof PsiMethod && (method = (PsiMethod)element).isConstructor()) {
            String name2;
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null && StringUtil.isNotEmpty((String)(name2 = containingClass.getName()))) {
                JavaMemberNameCompletionContributor.addLookupItems(set, null, matcher, element.getProject(), name2);
            }
            return;
        }
        PsiClass ourClassParent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (ourClassParent == null) {
            return;
        }
        if (ourClassParent.isAnnotationType() && matcher.prefixMatches("value")) {
            set.add((LookupElement)LookupElementBuilder.create((String)"value").withIcon(PlatformIcons.METHOD_ICON).withTailText("()").withInsertHandler((InsertHandler)ParenthesesInsertHandler.NO_PARAMETERS));
        }
        if (element instanceof PsiField && ((PsiField)element).hasModifierProperty("static") && ourClassParent.equals(PsiUtil.resolveClassInClassTypeOnly((PsiType)((PsiField)element).getType()))) {
            set.add((LookupElement)LookupElementBuilder.create((String)"getInstance").withIcon(PlatformIcons.METHOD_ICON).withTailText("()").withInsertHandler((InsertHandler)ParenthesesInsertHandler.WITH_PARAMETERS));
        }
        JavaMemberNameCompletionContributor.addLookupItems(set, null, matcher, element.getProject(), JavaMemberNameCompletionContributor.getUnresolvedReferences((PsiElement)ourClassParent, true, matcher));
        JavaMemberNameCompletionContributor.addLookupItems(set, null, matcher, element.getProject(), JavaMemberNameCompletionContributor.getPropertiesHandlersNames(ourClassParent, ((PsiModifierListOwner)element).hasModifierProperty("static"), PsiUtil.getTypeByPsiElement((PsiElement)element), element));
    }

    private static String[] getPropertiesHandlersNames(PsiClass psiClass, boolean staticContext, PsiType varType, PsiElement element) {
        ArrayList<String> propertyHandlers = new ArrayList<String>();
        for (PsiField field : psiClass.getFields()) {
            String setterName;
            String getterName;
            if (field == element || StringUtil.isEmpty((String)field.getName())) continue;
            PsiUtilCore.ensureValid((PsiElement)field);
            PsiType fieldType = field.getType();
            PsiUtil.ensureValidType((PsiType)fieldType);
            PsiModifierList modifierList = field.getModifierList();
            if (staticContext && modifierList != null && !modifierList.hasModifierProperty("static")) continue;
            if (fieldType.equals(varType) && (psiClass.findMethodsByName(getterName = PropertyUtilBase.suggestGetterName((PsiField)field), true).length == 0 || psiClass.findMethodBySignature(GenerateMembersUtil.generateGetterPrototype(field), true) == null)) {
                propertyHandlers.add(getterName);
            }
            if (!PsiType.VOID.equals((Object)varType) || psiClass.findMethodsByName(setterName = PropertyUtilBase.suggestSetterName((PsiField)field), true).length != 0 && psiClass.findMethodBySignature(GenerateMembersUtil.generateSetterPrototype(field), true) != null) continue;
            propertyHandlers.add(setterName);
        }
        return ArrayUtil.toStringArray(propertyHandlers);
    }

    private static void addLookupItems(Set<LookupElement> lookupElements, @Nullable SuggestedNameInfo callback, PrefixMatcher matcher, Project project, String ... strings) {
        block0: for (int i = 0; i < strings.length; ++i) {
            String name2 = strings[i];
            if (!matcher.prefixMatches(name2) || !PsiNameHelper.getInstance((Project)project).isIdentifier(name2, LanguageLevel.HIGHEST)) continue;
            for (LookupElement lookupElement : lookupElements) {
                if (!lookupElement.getAllLookupStrings().contains(name2)) continue;
                continue block0;
            }
            LookupElementDecorator<LookupElement> element = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)name2).withAutoCompletionPolicy(AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE), (double)(-i));
            if (callback != null) {
                element = JavaMemberNameCompletionContributor.withInsertHandler(callback, (LookupElement)element);
            }
            lookupElements.add((LookupElement)element);
        }
    }

    private static LookupElementDecorator<LookupElement> withInsertHandler(final SuggestedNameInfo callback, LookupElement element) {
        return LookupElementDecorator.withInsertHandler((LookupElement)element, (InsertHandler)new InsertHandler<LookupElementDecorator<LookupElement>>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElementDecorator<LookupElement> item) {
                TailType tailType;
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((tailType = LookupItem.getDefaultTailType((char)context.getCompletionChar())) != null) {
                    context.setAddCompletionChar(false);
                    tailType.processTail(context.getEditor(), context.getTailOffset());
                }
                callback.nameChosen(item.getLookupString());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/JavaMemberNameCompletionContributor$2";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/completion/JavaMemberNameCompletionContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

