/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecursiveCallLineMarkerProvider
extends LineMarkerProviderDescriptor {
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            RecursiveCallLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            RecursiveCallLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            RecursiveCallLineMarkerProvider.$$$reportNull$$$0(2);
        }
        HashSet<PsiStatement> statements = new HashSet<PsiStatement>();
        for (PsiElement element : elements) {
            PsiMethodCallExpression methodCall;
            PsiStatement statement;
            ProgressManager.checkCanceled();
            if (!(element instanceof PsiMethodCallExpression) || statements.contains(statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)(methodCall = (PsiMethodCallExpression)element), PsiStatement.class, (boolean)true, (Class[])new Class[]{PsiMethod.class})) || !RecursiveCallLineMarkerProvider.isRecursiveMethodCall(methodCall)) continue;
            statements.add(statement);
            ContainerUtil.addIfNotNull(result, (Object)((Object)RecursiveMethodCallMarkerInfo.create(methodCall)));
        }
    }

    public static boolean isRecursiveMethodCall(@NotNull PsiMethodCallExpression methodCall) {
        PsiExpression qualifier;
        if (methodCall == null) {
            RecursiveCallLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if ((qualifier = methodCall.getMethodExpression().getQualifierExpression()) != null && !(qualifier instanceof PsiThisExpression)) {
            return false;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class});
        if (method == null || !method.getName().equals(methodCall.getMethodExpression().getReferenceName())) {
            return false;
        }
        return Comparing.equal((Object)method, (Object)methodCall.resolveMethod());
    }

    @NotNull
    public String getName() {
        if ("Recursive call" == null) {
            RecursiveCallLineMarkerProvider.$$$reportNull$$$0(4);
        }
        return "Recursive call";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Gutter.RecursiveMethod;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/RecursiveCallLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/RecursiveCallLineMarkerProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRecursiveMethodCall";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RecursiveMethodCallMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private static RecursiveMethodCallMarkerInfo create(@NotNull PsiMethodCallExpression methodCall) {
            PsiElement nameElement;
            if (methodCall == null) {
                RecursiveMethodCallMarkerInfo.$$$reportNull$$$0(0);
            }
            if ((nameElement = methodCall.getMethodExpression().getReferenceNameElement()) != null) {
                return new RecursiveMethodCallMarkerInfo(nameElement);
            }
            return null;
        }

        private RecursiveMethodCallMarkerInfo(@NotNull PsiElement name2) {
            if (name2 == null) {
                RecursiveMethodCallMarkerInfo.$$$reportNull$$$0(1);
            }
            super(name2, name2.getTextRange(), AllIcons.Gutter.RecursiveMethod, 11, FunctionUtil.constant((Object)"Recursive call"), null, GutterIconRenderer.Alignment.RIGHT);
        }

        public GutterIconRenderer createGutterRenderer() {
            if (this.myIcon == null) {
                return null;
            }
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return null;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodCall";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/RecursiveCallLineMarkerProvider$RecursiveMethodCallMarkerInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

