/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.impl.GlobalUsageHelper;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.reference.UnusedDeclarationFixProvider;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaClassFindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesHelper;
import com.intellij.find.findUsages.JavaFindUsagesOptions;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.find.findUsages.JavaPackageFindUsagesOptions;
import com.intellij.find.findUsages.JavaVariableFindUsagesOptions;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.RefResolveService;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedSymbolUtil {
    public static boolean isInjected(@NotNull Project project, @NotNull PsiModifierListOwner modifierListOwner) {
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(0);
        }
        if (modifierListOwner == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(1);
        }
        return EntryPointsManagerBase.getInstance(project).isEntryPoint((PsiElement)modifierListOwner);
    }

    public static boolean isImplicitUsage(@NotNull Project project, @NotNull PsiModifierListOwner element, @Nullable ProgressIndicator progress) {
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(2);
        }
        if (element == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(3);
        }
        if (UnusedSymbolUtil.isInjected(project, element)) {
            return true;
        }
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            ProgressManager.checkCanceled();
            if (!provider.isImplicitUsage((PsiElement)element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isImplicitRead(@NotNull PsiVariable variable) {
        if (variable == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(4);
        }
        return UnusedSymbolUtil.isImplicitRead(variable.getProject(), variable, null);
    }

    public static boolean isImplicitRead(@NotNull Project project, @NotNull PsiVariable element, @Nullable ProgressIndicator progress) {
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(5);
        }
        if (element == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(6);
        }
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            ProgressManager.checkCanceled();
            if (!provider.isImplicitRead((PsiElement)element)) continue;
            return true;
        }
        return UnusedSymbolUtil.isInjected(project, (PsiModifierListOwner)element);
    }

    public static boolean isImplicitWrite(@NotNull PsiVariable variable) {
        if (variable == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(7);
        }
        return UnusedSymbolUtil.isImplicitWrite(variable.getProject(), variable, null);
    }

    public static boolean isImplicitWrite(@NotNull Project project, @NotNull PsiVariable element, @Nullable ProgressIndicator progress) {
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(8);
        }
        if (element == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(9);
        }
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            ProgressManager.checkCanceled();
            if (!provider.isImplicitWrite((PsiElement)element)) continue;
            return true;
        }
        return EntryPointsManager.getInstance((Project)project).isImplicitWrite((PsiElement)element);
    }

    @Nullable
    public static HighlightInfo createUnusedSymbolInfo(@NotNull PsiElement element, @NotNull String message2, @NotNull HighlightInfoType highlightInfoType) {
        HighlightInfo info;
        if (element == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(10);
        }
        if (message2 == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(11);
        }
        if (highlightInfoType == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(12);
        }
        if ((info = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(element).descriptionAndTooltip(message2).create()) == null) {
            return null;
        }
        for (UnusedDeclarationFixProvider provider : UnusedDeclarationFixProvider.EP_NAME.getExtensionList()) {
            IntentionAction[] fixes;
            for (IntentionAction fix2 : fixes = provider.getQuickFixes(element)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)fix2);
            }
        }
        return info;
    }

    public static boolean isFieldUnused(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiField field, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(13);
        }
        if (containingFile == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(14);
        }
        if (field == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(15);
        }
        if (progress == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(16);
        }
        if (helper == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(17);
        }
        if (helper.isLocallyUsed((PsiNamedElement)field)) {
            return false;
        }
        if (field instanceof PsiEnumConstant && UnusedSymbolUtil.isEnumValuesMethodUsed(project, containingFile, (PsiMember)field, progress, helper)) {
            return false;
        }
        return UnusedSymbolUtil.weAreSureThereAreNoUsages(project, containingFile, (PsiMember)field, progress, helper);
    }

    public static boolean isMethodReferenced(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiMethod method, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(18);
        }
        if (containingFile == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(19);
        }
        if (method == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(20);
        }
        if (progress == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(21);
        }
        if (helper == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(22);
        }
        if (helper.isLocallyUsed((PsiNamedElement)method)) {
            return true;
        }
        boolean isPrivate = method.hasModifierProperty("private");
        PsiClass containingClass = method.getContainingClass();
        if (JavaHighlightUtil.isSerializationRelatedMethod(method, containingClass)) {
            return true;
        }
        if (isPrivate) {
            if (UnusedSymbolUtil.isIntentionalPrivateConstructor(method, containingClass)) {
                return true;
            }
            if (UnusedSymbolUtil.isImplicitUsage(project, (PsiModifierListOwner)method, progress)) {
                return true;
            }
            if (!helper.isCurrentFileAlreadyChecked()) {
                return !UnusedSymbolUtil.weAreSureThereAreNoUsages(project, containingFile, (PsiMember)method, progress, helper);
            }
        } else {
            boolean isConstructor = method.isConstructor();
            if (containingClass != null && isConstructor && containingClass.getConstructors().length == 1 && UnusedSymbolUtil.isClassUsed(project, containingFile, containingClass, progress, helper)) {
                return true;
            }
            if (UnusedSymbolUtil.isImplicitUsage(project, (PsiModifierListOwner)method, progress)) {
                return true;
            }
            if (!isConstructor && FindSuperElementsHelper.findSuperElements((PsiElement)method).length != 0) {
                return true;
            }
            if (!UnusedSymbolUtil.weAreSureThereAreNoUsages(project, containingFile, (PsiMember)method, progress, helper)) {
                return true;
            }
        }
        return false;
    }

    private static boolean weAreSureThereAreNoUsages(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiMember member, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(23);
        }
        if (containingFile == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(24);
        }
        if (member == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(25);
        }
        if (progress == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(26);
        }
        if (helper == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(27);
        }
        UnusedSymbolUtil.log("* " + member.getName() + ": call wearesure");
        if (!helper.shouldCheckUsages(member)) {
            UnusedSymbolUtil.log("* " + member.getName() + ": should not check");
            return false;
        }
        PsiFile ignoreFile = helper.isCurrentFileAlreadyChecked() ? containingFile : null;
        boolean sure = UnusedSymbolUtil.processUsages(project, containingFile, member, progress, ignoreFile, (Processor<? super UsageInfo>)((Processor)info -> {
            PsiFile psiFile;
            if (member == null) {
                UnusedSymbolUtil.$$$reportNull$$$0(51);
            }
            if ((psiFile = info.getFile()) == ignoreFile || psiFile == null) {
                return true;
            }
            int offset = info.getNavigationOffset();
            if (offset == -1) {
                return true;
            }
            PsiElement element = psiFile.findElementAt(offset);
            boolean inComment = element instanceof PsiComment;
            UnusedSymbolUtil.log("*     " + member.getName() + ": usage :" + element);
            return inComment;
        }));
        UnusedSymbolUtil.log("*     " + member.getName() + ": result:" + sure);
        return sure;
    }

    private static void log(String s) {
    }

    public static boolean processUsages(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiMember member, @NotNull ProgressIndicator progress, @Nullable PsiFile ignoreFile, @NotNull Processor<? super UsageInfo> usageInfoProcessor) {
        JavaFindUsagesOptions options;
        String name2;
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(28);
        }
        if (containingFile == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(29);
        }
        if (member == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(30);
        }
        if (progress == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(31);
        }
        if (usageInfoProcessor == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(32);
        }
        if ((name2 = member.getName()) == null) {
            UnusedSymbolUtil.log("* " + member.getName() + " no name; false");
            return false;
        }
        SearchScope useScope = member.getUseScope();
        PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)project);
        if (useScope instanceof GlobalSearchScope) {
            SearchScope fileScope;
            String propertyName;
            PsiSearchHelper.SearchCostResult cheapEnough;
            if (member instanceof PsiClass) {
                useScope = GlobalSearchScope.projectScope((Project)project).uniteWith((GlobalSearchScope)useScope);
            }
            PsiSearchHelper.SearchCostResult searchCostResult = cheapEnough = RefResolveService.ENABLED && RefResolveService.getInstance((Project)project).isUpToDate() ? PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES : searchHelper.isCheapEnoughToSearch(name2, (GlobalSearchScope)useScope, ignoreFile, progress);
            if (cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                UnusedSymbolUtil.log("* " + member.getName() + " too many usages; false");
                return false;
            }
            if (cheapEnough == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES && !UnusedSymbolUtil.canBeReferencedViaWeirdNames(member, containingFile)) {
                UnusedSymbolUtil.log("* " + member.getName() + " 0 usages; true");
                return true;
            }
            if (member instanceof PsiMethod && (propertyName = PropertyUtilBase.getPropertyName((PsiMember)member)) != null && (fileScope = containingFile.getUseScope()) instanceof GlobalSearchScope && searchHelper.isCheapEnoughToSearch(propertyName, (GlobalSearchScope)fileScope, ignoreFile, progress) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                UnusedSymbolUtil.log("* " + member.getName() + " too many prop usages; false");
                return false;
            }
        }
        if (member instanceof PsiPackage) {
            options = new JavaPackageFindUsagesOptions(useScope);
            options.isSearchForTextOccurrences = true;
        } else if (member instanceof PsiClass) {
            options = new JavaClassFindUsagesOptions(useScope);
            options.isSearchForTextOccurrences = true;
        } else if (member instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)member;
            options = new JavaMethodFindUsagesOptions(useScope);
            options.isSearchForTextOccurrences = method.isConstructor();
        } else if (member instanceof PsiVariable) {
            options = new JavaVariableFindUsagesOptions(useScope);
            options.isSearchForTextOccurrences = false;
        } else {
            options = new FindUsagesOptions(useScope);
            options.isSearchForTextOccurrences = true;
        }
        options.isUsages = true;
        return JavaFindUsagesHelper.processElementUsages((PsiElement)member, options, usageInfoProcessor);
    }

    private static boolean isEnumValuesMethodUsed(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiMember member, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        PsiClass containingClass;
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(33);
        }
        if (containingFile == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(34);
        }
        if (member == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(35);
        }
        if (progress == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(36);
        }
        if (helper == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(37);
        }
        if (!((containingClass = member.getContainingClass()) instanceof PsiClassImpl)) {
            return true;
        }
        PsiMethod valuesMethod = ((PsiClassImpl)containingClass).getValuesMethod();
        return valuesMethod == null || UnusedSymbolUtil.isMethodReferenced(project, containingFile, valuesMethod, progress, helper);
    }

    private static boolean canBeReferencedViaWeirdNames(@NotNull PsiMember member, @NotNull PsiFile containingFile) {
        if (member == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(38);
        }
        if (containingFile == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(39);
        }
        if (member instanceof PsiClass) {
            return false;
        }
        if (!(containingFile instanceof PsiJavaFile)) {
            return true;
        }
        if (member instanceof PsiField) {
            return false;
        }
        if (member instanceof PsiMethod) {
            return PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)((PsiMethod)member));
        }
        return false;
    }

    public static boolean isClassUsed(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiClass aClass, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        Boolean result;
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(40);
        }
        if (containingFile == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(41);
        }
        if (aClass == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(42);
        }
        if (progress == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(43);
        }
        if (helper == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(44);
        }
        if ((result = helper.unusedClassCache.get(aClass)) == null) {
            result = UnusedSymbolUtil.isReallyUsed(project, containingFile, aClass, progress, helper);
            helper.unusedClassCache.put(aClass, result);
        }
        return result;
    }

    private static boolean isReallyUsed(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiClass aClass, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(45);
        }
        if (containingFile == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(46);
        }
        if (aClass == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(47);
        }
        if (progress == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(48);
        }
        if (helper == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(49);
        }
        if (UnusedSymbolUtil.isImplicitUsage(project, (PsiModifierListOwner)aClass, progress) || helper.isLocallyUsed((PsiNamedElement)aClass)) {
            return true;
        }
        if (helper.isCurrentFileAlreadyChecked() && (aClass.getContainingClass() != null && aClass.hasModifierProperty("private") || aClass.getParent() instanceof PsiDeclarationStatement || aClass instanceof PsiTypeParameter)) {
            return false;
        }
        return !UnusedSymbolUtil.weAreSureThereAreNoUsages(project, containingFile, (PsiMember)aClass, progress, helper);
    }

    private static boolean isIntentionalPrivateConstructor(@NotNull PsiMethod method, PsiClass containingClass) {
        if (method == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(50);
        }
        return method.isConstructor() && containingClass != null && containingClass.getConstructors().length == 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoType";
                break;
            }
            case 14: 
            case 19: 
            case 24: 
            case 29: 
            case 34: 
            case 39: 
            case 41: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 16: 
            case 21: 
            case 26: 
            case 31: 
            case 36: 
            case 43: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 17: 
            case 22: 
            case 27: 
            case 37: 
            case 44: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 20: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 25: 
            case 30: 
            case 35: 
            case 38: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfoProcessor";
                break;
            }
            case 42: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInjected";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitUsage";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitRead";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitWrite";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createUnusedSymbolInfo";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "isFieldUnused";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "isMethodReferenced";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "weAreSureThereAreNoUsages";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "processUsages";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnumValuesMethodUsed";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeReferencedViaWeirdNames";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[2] = "isClassUsed";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[2] = "isReallyUsed";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[2] = "isIntentionalPrivateConstructor";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$weAreSureThereAreNoUsages$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

