/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.ClassUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaMatchers;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.JavaPsiConstructorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightClassUtil {
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();

    @Nullable
    static HighlightInfo checkAbstractInstantiation(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            HighlightClassUtil.$$$reportNull$$$0(0);
        }
        PsiElement parent = ref.getParent();
        HighlightInfo highlightInfo = null;
        if (parent instanceof PsiAnonymousClass && parent.getParent() instanceof PsiNewExpression && !PsiUtilCore.hasErrorElementChild((PsiElement)parent.getParent())) {
            PsiAnonymousClass aClass = (PsiAnonymousClass)parent;
            highlightInfo = HighlightClassUtil.checkClassWithAbstractMethods((PsiClass)aClass, ref.getTextRange());
        }
        return highlightInfo;
    }

    @Nullable
    private static HighlightInfo checkClassWithAbstractMethods(@NotNull PsiClass aClass, @NotNull TextRange range) {
        if (aClass == null) {
            HighlightClassUtil.$$$reportNull$$$0(1);
        }
        if (range == null) {
            HighlightClassUtil.$$$reportNull$$$0(2);
        }
        return HighlightClassUtil.checkClassWithAbstractMethods(aClass, (PsiElement)aClass, range);
    }

    @Nullable
    static HighlightInfo checkClassWithAbstractMethods(@NotNull PsiClass aClass, @NotNull PsiElement implementsFixElement, @NotNull TextRange range) {
        PsiMethod abstractMethod;
        if (aClass == null) {
            HighlightClassUtil.$$$reportNull$$$0(3);
        }
        if (implementsFixElement == null) {
            HighlightClassUtil.$$$reportNull$$$0(4);
        }
        if (range == null) {
            HighlightClassUtil.$$$reportNull$$$0(5);
        }
        if ((abstractMethod = ClassUtil.getAnyAbstractMethod((PsiClass)aClass)) == null) {
            return null;
        }
        PsiClass superClass = abstractMethod.getContainingClass();
        if (superClass == null) {
            return null;
        }
        String baseClassName = HighlightUtil.formatClass(aClass, false);
        String methodName = JavaHighlightUtil.formatMethod(abstractMethod);
        String message2 = JavaErrorMessages.message(aClass instanceof PsiEnumConstantInitializer || implementsFixElement instanceof PsiEnumConstant ? "enum.constant.should.implement.method" : "class.must.be.abstract", baseClassName, methodName, HighlightUtil.formatClass(superClass, false));
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message2).create();
        PsiMethod anyMethodToImplement = ClassUtil.getAnyMethodToImplement((PsiClass)aClass);
        if (anyMethodToImplement != null) {
            if (!anyMethodToImplement.hasModifierProperty("packageLocal") || JavaPsiFacade.getInstance((Project)aClass.getProject()).arePackagesTheSame((PsiElement)aClass, (PsiElement)superClass)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createImplementMethodsFix(implementsFixElement));
            } else {
                QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)anyMethodToImplement, "protected", true, true));
                QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)anyMethodToImplement, "public", true, true));
            }
        }
        if (!(aClass instanceof PsiAnonymousClass) && !aClass.isEnum() && HighlightUtil.getIncompatibleModifier("abstract", aClass.getModifierList()) == null) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "abstract", true, false));
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkClassMustBeAbstract(@NotNull PsiClass aClass, @NotNull TextRange textRange) {
        if (aClass == null) {
            HighlightClassUtil.$$$reportNull$$$0(6);
        }
        if (textRange == null) {
            HighlightClassUtil.$$$reportNull$$$0(7);
        }
        if (aClass.isEnum() ? HighlightClassUtil.hasEnumConstantsWithInitializer(aClass) : aClass.hasModifierProperty("abstract") || aClass.getRBrace() == null) {
            return null;
        }
        return HighlightClassUtil.checkClassWithAbstractMethods(aClass, textRange);
    }

    @Nullable
    static HighlightInfo checkInstantiationOfAbstractClass(@NotNull PsiClass aClass, @NotNull PsiElement highlightElement) {
        if (aClass == null) {
            HighlightClassUtil.$$$reportNull$$$0(8);
        }
        if (highlightElement == null) {
            HighlightClassUtil.$$$reportNull$$$0(9);
        }
        HighlightInfo errorResult = null;
        if (!(!aClass.hasModifierProperty("abstract") || highlightElement instanceof PsiNewExpression && ((PsiNewExpression)highlightElement).getType() instanceof PsiArrayType)) {
            String baseClassName = aClass.getName();
            String message2 = JavaErrorMessages.message("abstract.cannot.be.instantiated", baseClassName);
            errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(highlightElement).descriptionAndTooltip(message2).create();
            PsiMethod anyAbstractMethod = ClassUtil.getAnyAbstractMethod((PsiClass)aClass);
            if (!aClass.isInterface() && anyAbstractMethod == null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "abstract", false, false));
            }
            if (anyAbstractMethod != null && highlightElement instanceof PsiNewExpression && ((PsiNewExpression)highlightElement).getClassReference() != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createImplementAbstractClassMethodsFix(highlightElement));
            }
        }
        return errorResult;
    }

    static boolean hasEnumConstantsWithInitializer(@NotNull PsiClass aClass) {
        if (aClass == null) {
            HighlightClassUtil.$$$reportNull$$$0(10);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> {
            PsiField[] fields;
            if (aClass == null) {
                HighlightClassUtil.$$$reportNull$$$0(61);
            }
            for (PsiField field : fields = aClass.getFields()) {
                if (!(field instanceof PsiEnumConstant) || ((PsiEnumConstant)field).getInitializingClass() == null) continue;
                return new CachedValueProvider.Result((Object)true, new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
            return new CachedValueProvider.Result((Object)false, new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    @Nullable
    static HighlightInfo checkDuplicateTopLevelClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            HighlightClassUtil.$$$reportNull$$$0(11);
        }
        if (!(aClass.getParent() instanceof PsiFile)) {
            return null;
        }
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        int numOfClassesToFind = 2;
        if (qualifiedName.contains("$")) {
            qualifiedName = qualifiedName.replaceAll("\\$", ".");
            numOfClassesToFind = 1;
        }
        PsiManager manager = aClass.getManager();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
        if (module == null) {
            return null;
        }
        PsiClass[] classes2 = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClasses(qualifiedName, GlobalSearchScope.moduleScope((Module)module).intersectWith(aClass.getResolveScope()));
        if (classes2.length < numOfClassesToFind) {
            return null;
        }
        ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)aClass);
        if (virtualFile == null) {
            return null;
        }
        boolean isTestSourceRoot = fileIndex.isInTestSourceContent(virtualFile);
        String dupFileName = null;
        for (PsiClass dupClass : classes2) {
            VirtualFile file;
            if (dupClass == aClass || (file = dupClass.getContainingFile().getVirtualFile()) == null || !manager.isInProject((PsiElement)dupClass) || fileIndex.isInTestSourceContent(file) != isTestSourceRoot) continue;
            dupFileName = FileUtil.toSystemDependentName((String)file.getPath());
            break;
        }
        if (dupFileName == null) {
            return null;
        }
        String message2 = JavaErrorMessages.message("duplicate.class.in.other.file", dupFileName);
        TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(message2).create();
    }

    @Nullable
    static HighlightInfo checkDuplicateNestedClass(@NotNull PsiClass aClass) {
        String name2;
        if (aClass == null) {
            HighlightClassUtil.$$$reportNull$$$0(12);
        }
        PsiClass parent = aClass;
        if (aClass.getParent() instanceof PsiDeclarationStatement) {
            parent = aClass.getParent();
        }
        if ((name2 = aClass.getName()) == null) {
            return null;
        }
        boolean duplicateFound = false;
        boolean checkSiblings = true;
        while (parent != null && !(parent instanceof PsiFile)) {
            PsiElement element;
            PsiElement psiElement = element = checkSiblings ? parent.getPrevSibling() : null;
            if (element == null && ((element = parent.getParent()) instanceof PsiMethod || element instanceof PsiClass || element instanceof PsiCodeBlock && element.getParent() instanceof PsiClassInitializer)) {
                checkSiblings = false;
            }
            parent = element;
            if (element instanceof PsiDeclarationStatement) {
                element = PsiTreeUtil.getChildOfType((PsiElement)element, PsiClass.class);
            }
            if (!(element instanceof PsiClass) || !name2.equals(((PsiClass)element).getName())) continue;
            duplicateFound = true;
            break;
        }
        if (duplicateFound) {
            String message2 = JavaErrorMessages.message("duplicate.class", name2);
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkPublicClassInRightFile(@NotNull PsiClass aClass) {
        if (aClass == null) {
            HighlightClassUtil.$$$reportNull$$$0(13);
        }
        PsiFile containingFile = aClass.getContainingFile();
        if (aClass.getParent() != containingFile || !aClass.hasModifierProperty("public") || !(containingFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiJavaFile file = (PsiJavaFile)containingFile;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || virtualFile.getNameWithoutExtension().equals(aClass.getName())) {
            return null;
        }
        String message2 = JavaErrorMessages.message("public.class.should.be.named.after.file", aClass.getName());
        TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)aClass, range.getStartOffset(), range.getEndOffset()).descriptionAndTooltip(message2).create();
        PsiModifierList psiModifierList = aClass.getModifierList();
        QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix(psiModifierList, "public", false, false));
        PsiClass[] classes2 = file.getClasses();
        if (classes2.length > 1) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createMoveClassToSeparateFileFix(aClass));
        }
        for (PsiClass otherClass : classes2) {
            if (otherClass.getManager().areElementsEquivalent((PsiElement)otherClass, (PsiElement)aClass) || !otherClass.hasModifierProperty("public") || !virtualFile.getNameWithoutExtension().equals(otherClass.getName())) continue;
            return errorResult;
        }
        QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createRenameFileFix(aClass.getName() + ".java"));
        QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createRenameElementFix((PsiNamedElement)aClass));
        return errorResult;
    }

    static HighlightInfo checkVarClassConflict(@NotNull PsiClass psiClass, @NotNull PsiIdentifier identifier) {
        String className;
        if (psiClass == null) {
            HighlightClassUtil.$$$reportNull$$$0(14);
        }
        if (identifier == null) {
            HighlightClassUtil.$$$reportNull$$$0(15);
        }
        if ("var".equals(className = psiClass.getName())) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip("'var' is a restricted local variable type and cannot be used for type declarations").range((PsiElement)identifier).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkClassAndPackageConflict(@NotNull PsiClass aClass) {
        String simpleName;
        PsiDirectory subDirectory;
        PsiElement directory;
        String name2;
        if (aClass == null) {
            HighlightClassUtil.$$$reportNull$$$0(16);
        }
        if ("java.lang".equals(name2 = aClass.getQualifiedName())) {
            String message2 = JavaErrorMessages.message("class.clashes.with.package", name2);
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message2).create();
        }
        PsiElement file = aClass.getParent();
        if (file instanceof PsiJavaFile && !((PsiJavaFile)file).getPackageName().isEmpty() && (directory = file.getParent()) instanceof PsiDirectory && (subDirectory = ((PsiDirectory)directory).findSubdirectory(simpleName = aClass.getName())) != null && simpleName.equals(subDirectory.getName()) && PsiTreeUtil.findChildOfType((PsiElement)subDirectory, PsiJavaFile.class) != null) {
            String message3 = JavaErrorMessages.message("class.clashes.with.package", name2);
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message3).create();
        }
        return null;
    }

    @Nullable
    private static HighlightInfo checkStaticFieldDeclarationInInnerClass(@NotNull PsiKeyword keyword) {
        if (keyword == null) {
            HighlightClassUtil.$$$reportNull$$$0(17);
        }
        if (HighlightClassUtil.getEnclosingStaticClass(keyword, PsiField.class) == null) {
            return null;
        }
        PsiField field = (PsiField)keyword.getParent().getParent();
        if (PsiUtilCore.hasErrorElementChild((PsiElement)field) || PsiUtil.isCompileTimeConstant((PsiVariable)field)) {
            return null;
        }
        String message2 = JavaErrorMessages.message("static.declaration.in.inner.class", new Object[0]);
        HighlightInfo result = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)keyword).descriptionAndTooltip(message2).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)result, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)field, "static", false, false));
        HighlightClassUtil.registerMakeInnerClassStatic(field.getContainingClass(), result);
        return result;
    }

    private static void registerMakeInnerClassStatic(@Nullable PsiClass aClass, @Nullable HighlightInfo result) {
        if (aClass != null && aClass.getContainingClass() != null) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)result, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "static", true, false));
        }
    }

    @Nullable
    private static HighlightInfo checkStaticMethodDeclarationInInnerClass(@NotNull PsiKeyword keyword) {
        if (keyword == null) {
            HighlightClassUtil.$$$reportNull$$$0(18);
        }
        if (HighlightClassUtil.getEnclosingStaticClass(keyword, PsiMethod.class) == null) {
            return null;
        }
        PsiMethod method = (PsiMethod)keyword.getParent().getParent();
        if (PsiUtilCore.hasErrorElementChild((PsiElement)method)) {
            return null;
        }
        String message2 = JavaErrorMessages.message("static.declaration.in.inner.class", new Object[0]);
        HighlightInfo result = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)keyword).descriptionAndTooltip(message2).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)result, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "static", false, false));
        HighlightClassUtil.registerMakeInnerClassStatic((PsiClass)keyword.getParent().getParent().getParent(), result);
        return result;
    }

    @Nullable
    private static HighlightInfo checkStaticInitializerDeclarationInInnerClass(@NotNull PsiKeyword keyword) {
        if (keyword == null) {
            HighlightClassUtil.$$$reportNull$$$0(19);
        }
        if (HighlightClassUtil.getEnclosingStaticClass(keyword, PsiClassInitializer.class) == null) {
            return null;
        }
        PsiClassInitializer initializer = (PsiClassInitializer)keyword.getParent().getParent();
        if (PsiUtilCore.hasErrorElementChild((PsiElement)initializer)) {
            return null;
        }
        String message2 = JavaErrorMessages.message("static.declaration.in.inner.class", new Object[0]);
        HighlightInfo result = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)keyword).descriptionAndTooltip(message2).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)result, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)initializer, "static", false, false));
        HighlightClassUtil.registerMakeInnerClassStatic((PsiClass)keyword.getParent().getParent().getParent(), result);
        return result;
    }

    private static PsiElement getEnclosingStaticClass(@NotNull PsiKeyword keyword, @NotNull Class<?> parentClass) {
        if (keyword == null) {
            HighlightClassUtil.$$$reportNull$$$0(20);
        }
        if (parentClass == null) {
            HighlightClassUtil.$$$reportNull$$$0(21);
        }
        return new PsiMatcherImpl((PsiElement)keyword).dot(PsiMatchers.hasText("static")).parent(PsiMatchers.hasClass(PsiModifierList.class)).parent(PsiMatchers.hasClass(parentClass)).parent(PsiMatchers.hasClass(PsiClass.class)).dot(JavaMatchers.hasModifier("static", false)).parent(PsiMatchers.hasClass(PsiClass.class, PsiDeclarationStatement.class, PsiNewExpression.class, PsiEnumConstant.class)).getElement();
    }

    @Nullable
    private static HighlightInfo checkStaticClassDeclarationInInnerClass(@NotNull PsiKeyword keyword) {
        if (keyword == null) {
            HighlightClassUtil.$$$reportNull$$$0(22);
        }
        if (new PsiMatcherImpl((PsiElement)keyword).parent(PsiMatchers.hasClass(PsiClass.class)).dot(JavaMatchers.hasModifier("static", true)).parent(PsiMatchers.hasClass(PsiClass.class)).dot(JavaMatchers.hasModifier("static", false)).parent(PsiMatchers.hasClass(PsiClass.class, PsiDeclarationStatement.class, PsiNewExpression.class, PsiEnumConstant.class)).getElement() == null) {
            return null;
        }
        PsiClass aClass = (PsiClass)keyword.getParent();
        if (PsiUtilCore.hasErrorElementChild((PsiElement)aClass)) {
            return null;
        }
        PsiElement context = null;
        PsiModifierList modifierList = aClass.getModifierList();
        if (modifierList != null) {
            for (PsiElement element : modifierList.getChildren()) {
                if (!Comparing.equal((String)element.getText(), (String)"static")) continue;
                context = element;
                break;
            }
        }
        TextRange range = context != null ? context.getTextRange() : HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        String message2 = JavaErrorMessages.message("static.declaration.in.inner.class", new Object[0]);
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message2).create();
        if (context != keyword) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "static", false, false));
        }
        PsiClass containingClass = aClass.getContainingClass();
        HighlightClassUtil.registerMakeInnerClassStatic(containingClass, info);
        return info;
    }

    @Nullable
    static HighlightInfo checkStaticDeclarationInInnerClass(@NotNull PsiKeyword keyword) {
        HighlightInfo errorResult;
        if (keyword == null) {
            HighlightClassUtil.$$$reportNull$$$0(23);
        }
        if ((errorResult = HighlightClassUtil.checkStaticFieldDeclarationInInnerClass(keyword)) != null) {
            return errorResult;
        }
        errorResult = HighlightClassUtil.checkStaticMethodDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        errorResult = HighlightClassUtil.checkStaticClassDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        errorResult = HighlightClassUtil.checkStaticInitializerDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkExtendsAllowed(@NotNull PsiReferenceList list) {
        boolean isExtends;
        PsiClass aClass;
        if (list == null) {
            HighlightClassUtil.$$$reportNull$$$0(24);
        }
        if (list.getParent() instanceof PsiClass && (aClass = (PsiClass)list.getParent()).isEnum() && (isExtends = list.equals(aClass.getExtendsList()))) {
            String description = JavaErrorMessages.message("extends.after.enum", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkImplementsAllowed(@NotNull PsiReferenceList list) {
        boolean isImplements;
        PsiClass aClass;
        if (list == null) {
            HighlightClassUtil.$$$reportNull$$$0(25);
        }
        if (list.getParent() instanceof PsiClass && (aClass = (PsiClass)list.getParent()).isInterface() && (isImplements = list.equals(aClass.getImplementsList()))) {
            String description = JavaErrorMessages.message("implements.after.interface", new Object[0]);
            HighlightInfo result = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(description).create();
            PsiClassType[] referencedTypes = list.getReferencedTypes();
            if (referencedTypes.length > 0) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)result, (IntentionAction)QUICK_FIX_FACTORY.createChangeExtendsToImplementsFix(aClass, referencedTypes[0]));
            }
            return result;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkExtendsClassAndImplementsInterface(@NotNull PsiReferenceList referenceList, @NotNull JavaResolveResult resolveResult, @NotNull PsiJavaCodeReferenceElement ref) {
        if (referenceList == null) {
            HighlightClassUtil.$$$reportNull$$$0(26);
        }
        if (resolveResult == null) {
            HighlightClassUtil.$$$reportNull$$$0(27);
        }
        if (ref == null) {
            HighlightClassUtil.$$$reportNull$$$0(28);
        }
        PsiClass aClass = (PsiClass)referenceList.getParent();
        boolean isImplements = referenceList.equals(aClass.getImplementsList());
        boolean isInterface = aClass.isInterface();
        if (isInterface && isImplements) {
            return null;
        }
        boolean mustBeInterface = isImplements || isInterface;
        HighlightInfo errorResult = null;
        PsiClass extendFrom = (PsiClass)resolveResult.getElement();
        if (extendFrom.isInterface() != mustBeInterface) {
            String message2 = JavaErrorMessages.message(mustBeInterface ? "interface.expected" : "no.interface.expected", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)ref).descriptionAndTooltip(message2).create();
            PsiClassType type2 = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(ref);
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createChangeExtendsToImplementsFix(aClass, type2));
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkCannotInheritFromFinal(@NotNull PsiClass superClass, @NotNull PsiElement elementToHighlight) {
        if (superClass == null) {
            HighlightClassUtil.$$$reportNull$$$0(29);
        }
        if (elementToHighlight == null) {
            HighlightClassUtil.$$$reportNull$$$0(30);
        }
        HighlightInfo errorResult = null;
        if (superClass.hasModifierProperty("final") || superClass.isEnum()) {
            String message2 = JavaErrorMessages.message("inheritance.from.final.class", superClass.getQualifiedName(), superClass.isEnum() ? "enum" : "final");
            errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)superClass, "final", false, false));
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkAnonymousInheritFinal(@NotNull PsiNewExpression expression2) {
        PsiAnonymousClass aClass;
        if (expression2 == null) {
            HighlightClassUtil.$$$reportNull$$$0(31);
        }
        if ((aClass = (PsiAnonymousClass)PsiTreeUtil.getChildOfType((PsiElement)expression2, PsiAnonymousClass.class)) == null) {
            return null;
        }
        PsiClassType baseClassReference = aClass.getBaseClassType();
        PsiClass baseClass = baseClassReference.resolve();
        if (baseClass == null) {
            return null;
        }
        return HighlightClassUtil.checkCannotInheritFromFinal(baseClass, (PsiElement)aClass.getBaseClassReference());
    }

    @Nullable
    private static String checkDefaultConstructorThrowsException(@NotNull PsiMethod constructor, @NotNull PsiClassType[] handledExceptions) {
        if (constructor == null) {
            HighlightClassUtil.$$$reportNull$$$0(32);
        }
        if (handledExceptions == null) {
            HighlightClassUtil.$$$reportNull$$$0(33);
        }
        PsiClassType[] referencedTypes = constructor.getThrowsList().getReferencedTypes();
        ArrayList<PsiClassType> exceptions = new ArrayList<PsiClassType>();
        for (PsiClassType referencedType : referencedTypes) {
            if (ExceptionUtil.isUncheckedException(referencedType) || ExceptionUtil.isHandledBy(referencedType, handledExceptions)) continue;
            exceptions.add(referencedType);
        }
        if (!exceptions.isEmpty()) {
            return HighlightUtil.getUnhandledExceptionsDescriptor(exceptions);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkClassDoesNotCallSuperConstructorOrHandleExceptions(@NotNull PsiClass aClass, @Nullable RefCountHolder refCountHolder, @NotNull PsiResolveHelper resolveHelper) {
        if (aClass == null) {
            HighlightClassUtil.$$$reportNull$$$0(34);
        }
        if (resolveHelper == null) {
            HighlightClassUtil.$$$reportNull$$$0(35);
        }
        if (aClass.isEnum()) {
            return null;
        }
        if (aClass.getConstructors().length != 0) {
            return null;
        }
        TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        return HighlightClassUtil.checkBaseClassDefaultConstructorProblem(aClass, refCountHolder, resolveHelper, textRange, PsiClassType.EMPTY_ARRAY);
    }

    static HighlightInfo checkBaseClassDefaultConstructorProblem(@NotNull PsiClass aClass, @Nullable RefCountHolder refCountHolder, @NotNull PsiResolveHelper resolveHelper, @NotNull TextRange range, @NotNull PsiClassType[] handledExceptions) {
        if (aClass == null) {
            HighlightClassUtil.$$$reportNull$$$0(36);
        }
        if (resolveHelper == null) {
            HighlightClassUtil.$$$reportNull$$$0(37);
        }
        if (range == null) {
            HighlightClassUtil.$$$reportNull$$$0(38);
        }
        if (handledExceptions == null) {
            HighlightClassUtil.$$$reportNull$$$0(39);
        }
        if (aClass instanceof PsiAnonymousClass) {
            return null;
        }
        PsiClass baseClass = aClass.getSuperClass();
        if (baseClass == null) {
            return null;
        }
        PsiMethod[] constructors = baseClass.getConstructors();
        if (constructors.length == 0) {
            return null;
        }
        PsiElement resolved = JavaResolveUtil.resolveImaginarySuperCallInThisPlace((PsiMember)aClass, aClass.getProject(), baseClass);
        List constructorCandidates = (resolved != null ? Collections.singletonList((PsiMethod)resolved) : Arrays.asList(constructors)).stream().filter(constructor -> {
            PsiParameter[] parameters2;
            if (resolveHelper == null) {
                HighlightClassUtil.$$$reportNull$$$0(59);
            }
            if (aClass == null) {
                HighlightClassUtil.$$$reportNull$$$0(60);
            }
            return ((parameters2 = constructor.getParameterList().getParameters()).length == 0 || parameters2.length == 1 && parameters2[0].isVarArgs()) && resolveHelper.isAccessible((PsiMember)constructor, (PsiElement)aClass, null);
        }).limit(2L).collect(Collectors.toList());
        if (constructorCandidates.size() >= 2) {
            String m1 = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)constructorCandidates.get(0)), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2);
            String m2 = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)constructorCandidates.get(1)), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(JavaErrorMessages.message("ambiguous.method.call", m1, m2)).create();
        }
        if (!constructorCandidates.isEmpty()) {
            PsiMethod constructor2 = (PsiMethod)constructorCandidates.get(0);
            String description = HighlightClassUtil.checkDefaultConstructorThrowsException(constructor2, handledExceptions);
            if (description != null) {
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createCreateConstructorMatchingSuperFix(aClass));
                return info;
            }
            if (refCountHolder != null) {
                refCountHolder.registerLocallyReferenced((PsiNamedElement)constructor2);
            }
            return null;
        }
        String description = JavaErrorMessages.message("no.default.constructor.available", HighlightUtil.formatClass(baseClass));
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createCreateConstructorMatchingSuperFix(aClass));
        return info;
    }

    @Nullable
    static HighlightInfo checkInterfaceCannotBeLocal(@NotNull PsiClass aClass) {
        if (aClass == null) {
            HighlightClassUtil.$$$reportNull$$$0(40);
        }
        if (PsiUtil.isLocalClass((PsiClass)aClass)) {
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            String description = JavaErrorMessages.message("interface.cannot.be.local", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkCyclicInheritance(@NotNull PsiClass aClass) {
        PsiClass circularClass;
        if (aClass == null) {
            HighlightClassUtil.$$$reportNull$$$0(41);
        }
        if ((circularClass = HighlightClassUtil.getCircularClass(aClass, new HashSet())) != null) {
            String description = JavaErrorMessages.message("cyclic.inheritance", HighlightUtil.formatClass(circularClass));
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description).create();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static PsiClass getCircularClass(@NotNull PsiClass aClass, @NotNull Collection<? super PsiClass> usedClasses) {
        if (aClass == null) {
            HighlightClassUtil.$$$reportNull$$$0(42);
        }
        if (usedClasses == null) {
            HighlightClassUtil.$$$reportNull$$$0(43);
        }
        if (usedClasses.contains(aClass)) {
            return aClass;
        }
        try {
            PsiClass[] superTypes;
            usedClasses.add((PsiClass)aClass);
            for (PsiClass superType : superTypes = aClass.getSupers()) {
                while (superType instanceof PsiClass) {
                    PsiClass circularClass;
                    if (!"java.lang.Object".equals(superType.getQualifiedName()) && (circularClass = HighlightClassUtil.getCircularClass(superType, usedClasses)) != null) {
                        PsiClass psiClass = circularClass;
                        return psiClass;
                    }
                    superType = superType.getParent();
                }
            }
        }
        finally {
            usedClasses.remove(aClass);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkExtendsDuplicate(@NotNull PsiJavaCodeReferenceElement element, @Nullable PsiElement resolved, @NotNull PsiFile containingFile) {
        if (element == null) {
            HighlightClassUtil.$$$reportNull$$$0(44);
        }
        if (containingFile == null) {
            HighlightClassUtil.$$$reportNull$$$0(45);
        }
        if (!(element.getParent() instanceof PsiReferenceList)) {
            return null;
        }
        PsiReferenceList list = (PsiReferenceList)element.getParent();
        if (!(list.getParent() instanceof PsiClass)) {
            return null;
        }
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass = (PsiClass)resolved;
        PsiClassType[] referencedTypes = list.getReferencedTypes();
        int dupCount = 0;
        PsiManager manager = containingFile.getManager();
        for (PsiClassType referencedType : referencedTypes) {
            PsiClass resolvedElement = referencedType.resolve();
            if (resolvedElement == null || !manager.areElementsEquivalent((PsiElement)resolvedElement, (PsiElement)aClass)) continue;
            ++dupCount;
        }
        if (dupCount > 1) {
            String description = JavaErrorMessages.message("duplicate.class", HighlightUtil.formatClass(aClass));
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)element).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkClassAlreadyImported(@NotNull PsiClass aClass, @NotNull PsiElement elementToHighlight) {
        PsiImportStatementBase[] importStatements;
        PsiFile file;
        if (aClass == null) {
            HighlightClassUtil.$$$reportNull$$$0(46);
        }
        if (elementToHighlight == null) {
            HighlightClassUtil.$$$reportNull$$$0(47);
        }
        if (!((file = aClass.getContainingFile()) instanceof PsiJavaFile)) {
            return null;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file;
        if (aClass.getParent() != javaFile) {
            return null;
        }
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return null;
        }
        for (PsiImportStatementBase importStatement : importStatements = importList.getAllImportStatements()) {
            PsiElement resolved;
            if (importStatement.isOnDemand() || !((resolved = importStatement.resolve()) instanceof PsiClass) || resolved.equals(aClass) || !Comparing.equal((String)aClass.getName(), (String)((PsiClass)resolved).getName(), (boolean)true)) continue;
            String description = JavaErrorMessages.message("class.already.imported", HighlightUtil.formatClass(aClass, false));
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkClassExtendsOnlyOneClass(@NotNull PsiReferenceList list) {
        if (list == null) {
            HighlightClassUtil.$$$reportNull$$$0(48);
        }
        PsiClassType[] referencedTypes = list.getReferencedTypes();
        PsiElement parent = list.getParent();
        if (!(parent instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass = (PsiClass)parent;
        if (!aClass.isInterface() && referencedTypes.length > 1 && aClass.getExtendsList() == list) {
            String description = JavaErrorMessages.message("class.cannot.extend.multiple.classes", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkThingNotAllowedInInterface(@NotNull PsiElement element, @Nullable PsiClass aClass) {
        if (element == null) {
            HighlightClassUtil.$$$reportNull$$$0(49);
        }
        if (aClass == null || !aClass.isInterface()) {
            return null;
        }
        String description = JavaErrorMessages.message("not.allowed.in.interface", new Object[0]);
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
    }

    @Nullable
    static HighlightInfo checkQualifiedNew(@NotNull PsiNewExpression expression2, @Nullable PsiType type2, @Nullable PsiClass aClass) {
        PsiExpression qualifier;
        if (expression2 == null) {
            HighlightClassUtil.$$$reportNull$$$0(50);
        }
        if ((qualifier = expression2.getQualifier()) == null) {
            return null;
        }
        if (type2 instanceof PsiArrayType) {
            String description = JavaErrorMessages.message("invalid.qualified.new", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createRemoveNewQualifierFix(expression2, null));
            return info;
        }
        HighlightInfo info = null;
        if (aClass != null) {
            PsiClass baseClass;
            if (aClass.hasModifierProperty("static")) {
                String description = JavaErrorMessages.message("qualified.new.of.static.class", new Object[0]);
                info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
                if (!aClass.isEnum()) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "static", false, false));
                }
            } else if (aClass instanceof PsiAnonymousClass && (baseClass = PsiUtil.resolveClassInType((PsiType)((PsiAnonymousClass)aClass).getBaseClassType())) != null && baseClass.isInterface()) {
                info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip("Anonymous class implements interface; cannot have qualifier for new").create();
            }
            QuickFixAction.registerQuickFixAction(info, (IntentionAction)QUICK_FIX_FACTORY.createRemoveNewQualifierFix(expression2, aClass));
        }
        return info;
    }

    @Nullable
    static HighlightInfo checkClassExtendsForeignInnerClass(final @NotNull PsiJavaCodeReferenceElement extendRef, final PsiElement resolved) {
        PsiClass containerClass;
        PsiElement parent;
        if (extendRef == null) {
            HighlightClassUtil.$$$reportNull$$$0(51);
        }
        if (!((parent = extendRef.getParent()) instanceof PsiReferenceList)) {
            return null;
        }
        PsiElement grand = parent.getParent();
        if (!(grand instanceof PsiClass)) {
            return null;
        }
        final PsiClass aClass = (PsiClass)grand;
        if (aClass instanceof PsiTypeParameter) {
            PsiTypeParameterListOwner owner2 = ((PsiTypeParameter)aClass).getOwner();
            if (!(owner2 instanceof PsiClass)) {
                return null;
            }
            containerClass = (PsiClass)owner2;
        } else {
            containerClass = aClass;
        }
        if (aClass.getExtendsList() != parent && aClass.getImplementsList() != parent) {
            return null;
        }
        if (!(resolved instanceof PsiClass)) {
            String description = JavaErrorMessages.message("class.name.expected", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)extendRef).descriptionAndTooltip(description).create();
        }
        final HighlightInfo[] infos = new HighlightInfo[1];
        extendRef.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (infos[0] != null) {
                    return;
                }
                super.visitElement(element);
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                PsiElement resolve = reference.resolve();
                if (resolve instanceof PsiClass) {
                    PsiClass base = (PsiClass)resolve;
                    PsiClass baseClass = base.getContainingClass();
                    if (baseClass != null && base.hasModifierProperty("private") && baseClass == containerClass && baseClass.getContainingClass() == null) {
                        String description = JavaErrorMessages.message("private.symbol", HighlightUtil.formatClass(base), HighlightUtil.formatClass(baseClass));
                        infos[0] = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)extendRef).descriptionAndTooltip(description).create();
                        return;
                    }
                    if (!PsiUtil.isInnerClass((PsiClass)base)) {
                        return;
                    }
                    if (!(resolve != resolved || baseClass == null || PsiTreeUtil.isAncestor((PsiElement)baseClass, (PsiElement)extendRef, (boolean)true) && !aClass.hasModifierProperty("static") || InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)baseClass, (PsiElement)extendRef, psiClass -> psiClass != aClass, (boolean)true) || HighlightClassUtil.qualifiedNewCalledInConstructors(aClass))) {
                        String description = JavaErrorMessages.message("no.enclosing.instance.in.scope", HighlightUtil.formatClass(baseClass));
                        infos[0] = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)extendRef).descriptionAndTooltip(description).create();
                    }
                }
            }
        });
        return infos[0];
    }

    private static boolean qualifiedNewCalledInConstructors(@NotNull PsiClass aClass) {
        PsiMethod[] constructors;
        if (aClass == null) {
            HighlightClassUtil.$$$reportNull$$$0(52);
        }
        if ((constructors = aClass.getConstructors()).length == 0) {
            return false;
        }
        for (PsiMethod constructor : constructors) {
            PsiReferenceExpression referenceExpression;
            PsiExpression qualifierExpression2;
            PsiMethodCallExpression methodCallExpression = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)constructor);
            if (methodCallExpression == null) {
                return false;
            }
            if (JavaPsiConstructorUtil.isChainedConstructorCall((PsiElement)methodCallExpression) || (qualifierExpression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)(referenceExpression = methodCallExpression.getMethodExpression()).getQualifierExpression())) != null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    static HighlightInfo checkCreateInnerClassFromStaticContext(@NotNull PsiNewExpression expression2, @Nullable PsiType type2, @Nullable PsiClass aClass) {
        if (expression2 == null) {
            HighlightClassUtil.$$$reportNull$$$0(53);
        }
        if (type2 == null || type2 instanceof PsiArrayType || type2 instanceof PsiPrimitiveType) {
            return null;
        }
        if (aClass == null) {
            return null;
        }
        if (aClass instanceof PsiAnonymousClass && (aClass = ((PsiAnonymousClass)aClass).getBaseClassType().resolve()) == null) {
            return null;
        }
        PsiExpression qualifier = expression2.getQualifier();
        return HighlightClassUtil.checkCreateInnerClassFromStaticContext((PsiElement)expression2, qualifier, aClass);
    }

    @Nullable
    public static HighlightInfo checkCreateInnerClassFromStaticContext(@NotNull PsiElement element, @Nullable PsiExpression qualifier, @Nullable PsiClass aClass) {
        PsiElement placeToSearchEnclosingFrom;
        if (element == null) {
            HighlightClassUtil.$$$reportNull$$$0(54);
        }
        if (qualifier != null) {
            PsiType qType = qualifier.getType();
            placeToSearchEnclosingFrom = PsiUtil.resolveClassInType((PsiType)qType);
        } else {
            placeToSearchEnclosingFrom = element;
        }
        return HighlightClassUtil.checkCreateInnerClassFromStaticContext(element, placeToSearchEnclosingFrom, aClass);
    }

    @Nullable
    static HighlightInfo checkCreateInnerClassFromStaticContext(@NotNull PsiElement element, @Nullable PsiElement placeToSearchEnclosingFrom, @Nullable PsiClass aClass) {
        if (element == null) {
            HighlightClassUtil.$$$reportNull$$$0(55);
        }
        if (aClass == null || !PsiUtil.isInnerClass((PsiClass)aClass)) {
            return null;
        }
        PsiClass outerClass = aClass.getContainingClass();
        if (outerClass == null) {
            return null;
        }
        if (outerClass instanceof PsiSyntheticClass || InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)outerClass, (PsiElement)placeToSearchEnclosingFrom, (boolean)true, (boolean)false)) {
            return null;
        }
        return HighlightClassUtil.reportIllegalEnclosingUsage(placeToSearchEnclosingFrom, aClass, outerClass, element);
    }

    @Nullable
    static HighlightInfo checkSuperQualifierType(@NotNull Project project, @NotNull PsiMethodCallExpression superCall) {
        if (project == null) {
            HighlightClassUtil.$$$reportNull$$$0(56);
        }
        if (superCall == null) {
            HighlightClassUtil.$$$reportNull$$$0(57);
        }
        if (!JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)superCall)) {
            return null;
        }
        PsiMethod ctr = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)superCall, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
        if (ctr == null) {
            return null;
        }
        PsiClass aClass = ctr.getContainingClass();
        if (aClass == null) {
            return null;
        }
        PsiClass targetClass = aClass.getSuperClass();
        if (targetClass == null) {
            return null;
        }
        PsiExpression qualifier = superCall.getMethodExpression().getQualifierExpression();
        if (qualifier != null) {
            if (PsiUtil.isInnerClass((PsiClass)targetClass)) {
                PsiClass outerClass = targetClass.getContainingClass();
                if (outerClass != null) {
                    PsiClassType outerType = JavaPsiFacade.getElementFactory((Project)project).createType(outerClass);
                    return HighlightUtil.checkAssignability((PsiType)outerType, null, qualifier, (PsiElement)qualifier);
                }
            } else {
                String description = "'" + HighlightUtil.formatClass(targetClass) + "' is not an inner class";
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)qualifier).descriptionAndTooltip(description).create();
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo reportIllegalEnclosingUsage(PsiElement place, @Nullable PsiClass aClass, @Nullable PsiClass outerClass, @NotNull PsiElement elementToHighlight) {
        if (elementToHighlight == null) {
            HighlightClassUtil.$$$reportNull$$$0(58);
        }
        if (outerClass != null && !PsiTreeUtil.isContextAncestor((PsiElement)outerClass, (PsiElement)place, (boolean)false)) {
            String description = JavaErrorMessages.message("is.not.an.enclosing.class", HighlightUtil.formatClass(outerClass));
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(description).create();
            HighlightClassUtil.registerMakeInnerClassStatic(aClass, highlightInfo);
            return highlightInfo;
        }
        PsiModifierListOwner staticParent = PsiUtil.getEnclosingStaticElement((PsiElement)place, (PsiClass)outerClass);
        if (staticParent != null) {
            String element = outerClass == null ? "" : HighlightUtil.formatClass(outerClass) + "." + (place instanceof PsiSuperExpression ? "super" : "this");
            String description = JavaErrorMessages.message("cannot.be.referenced.from.static.context", element);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix(staticParent, "static", false, false));
            if (aClass != null && HighlightUtil.getIncompatibleModifier("static", aClass.getModifierList()) == null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "static", true, false));
            }
            return highlightInfo;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 34: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 52: 
            case 60: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 5: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementsFixElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 24: 
            case 25: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceList";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 30: 
            case 47: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
            case 31: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 33: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handledExceptions";
                break;
            }
            case 35: 
            case 37: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveHelper";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedClasses";
                break;
            }
            case 44: 
            case 49: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendRef";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superCall";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAbstractInstantiation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClassWithAbstractMethods";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClassMustBeAbstract";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInstantiationOfAbstractClass";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "hasEnumConstantsWithInitializer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDuplicateTopLevelClass";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDuplicateNestedClass";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPublicClassInRightFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "checkVarClassConflict";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClassAndPackageConflict";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "checkStaticFieldDeclarationInInnerClass";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "checkStaticMethodDeclarationInInnerClass";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "checkStaticInitializerDeclarationInInnerClass";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnclosingStaticClass";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "checkStaticClassDeclarationInInnerClass";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "checkStaticDeclarationInInnerClass";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "checkExtendsAllowed";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "checkImplementsAllowed";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "checkExtendsClassAndImplementsInterface";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCannotInheritFromFinal";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAnonymousInheritFinal";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDefaultConstructorThrowsException";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClassDoesNotCallSuperConstructorOrHandleExceptions";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "checkBaseClassDefaultConstructorProblem";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInterfaceCannotBeLocal";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCyclicInheritance";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "getCircularClass";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "checkExtendsDuplicate";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClassAlreadyImported";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClassExtendsOnlyOneClass";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[2] = "checkThingNotAllowedInInterface";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[2] = "checkQualifiedNew";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClassExtendsForeignInnerClass";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[2] = "qualifiedNewCalledInConstructors";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCreateInnerClassFromStaticContext";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSuperQualifierType";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[2] = "reportIllegalEnclosingUsage";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$checkBaseClassDefaultConstructorProblem$1";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$hasEnumConstantsWithInitializer$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

