/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AddConstructorFix
implements LocalQuickFix,
IntentionAction {
    private final SmartPsiElementPointer<PsiClass> myBeanClass;
    private final List<? extends PsiParameter> myParameters;
    private final String name;

    public AddConstructorFix(PsiClass beanClass, List<? extends PsiParameter> parameters2) {
        this.myBeanClass = SmartPointerManager.getInstance((Project)beanClass.getProject()).createSmartPsiElementPointer((PsiElement)beanClass);
        this.myParameters = parameters2;
        String params = this.myParameters.stream().map(p -> p.getText()).collect(Collectors.joining(", "));
        String signature = beanClass.getName() + "(" + params + ")";
        this.name = QuickFixBundle.message("model.create.constructor.quickfix.message", signature);
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            AddConstructorFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.name;
        if (string == null) {
            AddConstructorFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("model.create.constructor.quickfix.message.family.name", new Object[0]);
        if (string == null) {
            AddConstructorFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            AddConstructorFix.$$$reportNull$$$0(3);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            AddConstructorFix.$$$reportNull$$$0(4);
        }
        this.applyFix();
    }

    private void applyFix() {
        try {
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.myBeanClass.getContainingFile())) {
                return;
            }
            PsiClass psiClass = (PsiClass)this.myBeanClass.getElement();
            if (psiClass == null) {
                return;
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myBeanClass.getProject());
            PsiMethod constructor = elementFactory.createConstructor();
            for (PsiParameter psiParameter : this.myParameters) {
                constructor.getParameterList().add((PsiElement)psiParameter);
            }
            psiClass.add((PsiElement)constructor);
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            AddConstructorFix.$$$reportNull$$$0(5);
        }
        if (descriptor2 == null) {
            AddConstructorFix.$$$reportNull$$$0(6);
        }
        this.applyFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddConstructorFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddConstructorFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

