/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AddNewArrayExpressionFix
implements IntentionAction {
    private final PsiArrayInitializerExpression myInitializer;

    public AddNewArrayExpressionFix(@NotNull PsiArrayInitializerExpression initializer) {
        if (initializer == null) {
            AddNewArrayExpressionFix.$$$reportNull$$$0(0);
        }
        this.myInitializer = initializer;
    }

    @NotNull
    public String getText() {
        PsiType type2 = this.getType();
        String string = QuickFixBundle.message("add.new.array.text", type2.getPresentableText());
        if (string == null) {
            AddNewArrayExpressionFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.new.array.family", new Object[0]);
        if (string == null) {
            AddNewArrayExpressionFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            AddNewArrayExpressionFix.$$$reportNull$$$0(3);
        }
        if (!this.myInitializer.isValid() || !BaseIntentionAction.canModify((PsiElement)this.myInitializer)) {
            return false;
        }
        return this.getType() != null;
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        if (file == null) {
            AddNewArrayExpressionFix.$$$reportNull$$$0(4);
        }
        PsiArrayInitializerExpression psiArrayInitializerExpression = this.myInitializer;
        if (psiArrayInitializerExpression == null) {
            AddNewArrayExpressionFix.$$$reportNull$$$0(5);
        }
        return psiArrayInitializerExpression;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            AddNewArrayExpressionFix.$$$reportNull$$$0(6);
        }
        PsiManager manager = file.getManager();
        PsiType type2 = this.getType();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        String text2 = "new " + type2.getCanonicalText() + "[]{}";
        PsiNewExpression newExpr = (PsiNewExpression)factory.createExpressionFromText(text2, null);
        newExpr.getArrayInitializer().replace((PsiElement)this.myInitializer);
        newExpr = (PsiNewExpression)CodeStyleManager.getInstance((Project)manager.getProject()).reformat((PsiElement)newExpr);
        this.myInitializer.replace((PsiElement)newExpr);
    }

    private PsiType getType() {
        PsiExpression[] initializers = this.myInitializer.getInitializers();
        PsiElement parent = this.myInitializer.getParent();
        if (!(parent instanceof PsiAssignmentExpression)) {
            if (initializers.length <= 0) {
                return null;
            }
            return AddNewArrayExpressionFix.validateType(initializers[0].getType(), parent);
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
        PsiType type2 = assignmentExpression.getType();
        if (!(type2 instanceof PsiArrayType)) {
            if (initializers.length <= 0) {
                return null;
            }
            return AddNewArrayExpressionFix.validateType(initializers[0].getType(), parent);
        }
        return AddNewArrayExpressionFix.validateType(((PsiArrayType)type2).getComponentType(), parent);
    }

    private static PsiType validateType(PsiType type2, @NotNull PsiElement context) {
        if (context == null) {
            AddNewArrayExpressionFix.$$$reportNull$$$0(7);
        }
        if (PsiType.NULL.equals((Object)type2)) {
            return null;
        }
        return LambdaUtil.notInferredType((PsiType)type2) || !PsiTypesUtil.isDenotableType((PsiType)type2, (PsiElement)context) ? null : TypeConversionUtil.erasure((PsiType)type2);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddNewArrayExpressionFix";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddNewArrayExpressionFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToMakeWritable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validateType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

